/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.impl;

import com.github.sakserv.minicluster.MiniCluster;
import com.github.sakserv.minicluster.util.FileUtils;
import com.github.sakserv.minicluster.util.WindowsLibsUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsLocalCluster
implements MiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsLocalCluster.class);
    MiniDFSCluster miniDFSCluster;
    private Integer hdfsNamenodePort;
    private String hdfsTempDir;
    private Integer hdfsNumDatanodes;
    private Boolean hdfsEnablePermissions;
    private Boolean hdfsFormat;
    private Boolean hdfsEnableRunningUserAsProxyUser;
    private Configuration hdfsConfig;

    public Integer getHdfsNamenodePort() {
        return this.hdfsNamenodePort;
    }

    public String getHdfsTempDir() {
        return this.hdfsTempDir;
    }

    public Integer getHdfsNumDatanodes() {
        return this.hdfsNumDatanodes;
    }

    public Boolean getHdfsEnablePermissions() {
        return this.hdfsEnablePermissions;
    }

    public Boolean getHdfsFormat() {
        return this.hdfsFormat;
    }

    public Boolean getHdfsEnableRunningUserAsProxyUser() {
        return this.hdfsEnableRunningUserAsProxyUser;
    }

    public Configuration getHdfsConfig() {
        return this.hdfsConfig;
    }

    private HdfsLocalCluster(Builder builder) {
        this.hdfsNamenodePort = builder.hdfsNamenodePort;
        this.hdfsTempDir = builder.hdfsTempDir;
        this.hdfsNumDatanodes = builder.hdfsNumDatanodes;
        this.hdfsEnablePermissions = builder.hdfsEnablePermissions;
        this.hdfsFormat = builder.hdfsFormat;
        this.hdfsEnableRunningUserAsProxyUser = builder.hdfsEnableRunningUserAsProxyUser;
        this.hdfsConfig = builder.hdfsConfig;
    }

    public void start() throws Exception {
        LOG.info("HDFS: Starting MiniDfsCluster");
        this.configure();
        this.miniDFSCluster = new MiniDFSCluster.Builder(this.hdfsConfig).nameNodePort(this.hdfsNamenodePort.intValue()).numDataNodes(this.hdfsNumDatanodes.intValue()).format(this.hdfsFormat.booleanValue()).racks(null).build();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean cleanUp) throws Exception {
        LOG.info("HDFS: Stopping MiniDfsCluster");
        this.miniDFSCluster.shutdown();
        if (cleanUp) {
            this.cleanUp();
        }
    }

    public void configure() throws Exception {
        if (null != this.hdfsEnableRunningUserAsProxyUser && this.hdfsEnableRunningUserAsProxyUser.booleanValue()) {
            this.hdfsConfig.set("hadoop.proxyuser." + System.getProperty("user.name") + ".hosts", "*");
            this.hdfsConfig.set("hadoop.proxyuser." + System.getProperty("user.name") + ".groups", "*");
        }
        this.hdfsConfig.setBoolean("dfs.permissions", this.hdfsEnablePermissions.booleanValue());
        System.setProperty("test.build.data", this.hdfsTempDir);
        WindowsLibsUtils.setHadoopHome();
    }

    public void cleanUp() throws Exception {
        FileUtils.deleteFolder((String)this.hdfsTempDir);
    }

    public FileSystem getHdfsFileSystemHandle() throws Exception {
        DistributedFileSystem hdfsFileSystemHandle = null;
        hdfsFileSystemHandle = this.miniDFSCluster.getFileSystem();
        return hdfsFileSystemHandle;
    }

    public static class Builder {
        private Integer hdfsNamenodePort;
        private String hdfsTempDir;
        private Integer hdfsNumDatanodes;
        private Boolean hdfsEnablePermissions;
        private Boolean hdfsFormat;
        private Boolean hdfsEnableRunningUserAsProxyUser;
        private Configuration hdfsConfig;

        public Builder setHdfsNamenodePort(Integer hdfsNameNodePort) {
            this.hdfsNamenodePort = hdfsNameNodePort;
            return this;
        }

        public Builder setHdfsTempDir(String hdfsTempDir) {
            this.hdfsTempDir = hdfsTempDir;
            return this;
        }

        public Builder setHdfsNumDatanodes(Integer hdfsNumDatanodes) {
            this.hdfsNumDatanodes = hdfsNumDatanodes;
            return this;
        }

        public Builder setHdfsEnablePermissions(Boolean hdfsEnablePermissions) {
            this.hdfsEnablePermissions = hdfsEnablePermissions;
            return this;
        }

        public Builder setHdfsFormat(Boolean hdfsFormat) {
            this.hdfsFormat = hdfsFormat;
            return this;
        }

        public Builder setHdfsEnableRunningUserAsProxyUser(Boolean hdfsEnableRunningUserAsProxyUser) {
            this.hdfsEnableRunningUserAsProxyUser = hdfsEnableRunningUserAsProxyUser;
            return this;
        }

        public Builder setHdfsConfig(Configuration hdfsConfig) {
            this.hdfsConfig = hdfsConfig;
            return this;
        }

        public HdfsLocalCluster build() {
            HdfsLocalCluster hdfsLocalCluster = new HdfsLocalCluster(this);
            this.validateObject(hdfsLocalCluster);
            return hdfsLocalCluster;
        }

        public void validateObject(HdfsLocalCluster hdfsLocalCluster) {
            if (hdfsLocalCluster.hdfsNamenodePort == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HDFS Namenode Port");
            }
            if (hdfsLocalCluster.hdfsTempDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HDFS Temp Dir");
            }
            if (hdfsLocalCluster.hdfsNumDatanodes == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HDFS Num Datanodes");
            }
            if (hdfsLocalCluster.hdfsEnablePermissions == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HDFS Enable Permissions");
            }
            if (hdfsLocalCluster.hdfsFormat == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HDFS Format");
            }
            if (hdfsLocalCluster.hdfsConfig == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HDFS Config");
            }
        }
    }
}

