/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.impl;

import com.github.sakserv.minicluster.MiniCluster;
import com.github.sakserv.minicluster.util.FileUtils;
import com.github.sakserv.minicluster.util.WindowsLibsUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseLocalCluster
implements MiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(HbaseLocalCluster.class);
    MiniHBaseCluster miniHBaseCluster;
    private Integer hbaseMasterPort;
    private Integer hbaseMasterInfoPort;
    private Integer numRegionServers;
    private String hbaseRootDir;
    private Integer zookeeperPort;
    private String zookeeperConnectionString;
    private String zookeeperZnodeParent;
    private Boolean hbaseWalReplicationEnabled;
    private Configuration hbaseConfiguration;

    public Integer getHbaseMasterPort() {
        return this.hbaseMasterPort;
    }

    public Integer getHbaseMasterInfoPort() {
        return this.hbaseMasterInfoPort;
    }

    public Integer getNumRegionServers() {
        return this.numRegionServers;
    }

    public String getHbaseRootDir() {
        return this.hbaseRootDir;
    }

    public Integer getZookeeperPort() {
        return this.zookeeperPort;
    }

    public String getZookeeperConnectionString() {
        return this.zookeeperConnectionString;
    }

    public String getZookeeperZnodeParent() {
        return this.zookeeperZnodeParent;
    }

    public Boolean getHbaseWalReplicationEnabled() {
        return this.hbaseWalReplicationEnabled;
    }

    public Configuration getHbaseConfiguration() {
        return this.hbaseConfiguration;
    }

    private HbaseLocalCluster(Builder builder) {
        this.hbaseMasterPort = builder.hbaseMasterPort;
        this.hbaseMasterInfoPort = builder.hbaseMasterInfoPort;
        this.numRegionServers = builder.numRegionServers;
        this.hbaseRootDir = builder.hbaseRootDir;
        this.zookeeperPort = builder.zookeeperPort;
        this.zookeeperConnectionString = builder.zookeeperConnectionString;
        this.zookeeperZnodeParent = builder.zookeeperZnodeParent;
        this.hbaseWalReplicationEnabled = builder.hbaseWalReplicationEnabled;
        this.hbaseConfiguration = builder.hbaseConfiguration;
    }

    public void start() throws Exception {
        LOG.info("HBASE: Starting MiniHBaseCluster");
        this.configure();
        this.miniHBaseCluster = new MiniHBaseCluster(this.hbaseConfiguration, this.numRegionServers.intValue());
        this.miniHBaseCluster.startMaster();
        this.miniHBaseCluster.startRegionServer();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean cleanUp) throws Exception {
        LOG.info("HBASE: Stopping MiniHBaseCluster");
        this.miniHBaseCluster.flushcache();
        this.miniHBaseCluster.close();
        this.miniHBaseCluster.shutdown();
        this.miniHBaseCluster.waitUntilShutDown();
        if (cleanUp) {
            this.cleanUp();
        }
    }

    public void configure() throws Exception {
        this.hbaseConfiguration.set("hbase.master.port", this.hbaseMasterPort.toString());
        this.hbaseConfiguration.set("hbase.master.info.port", this.hbaseMasterInfoPort.toString());
        this.hbaseConfiguration.set("hbase.rootdir", this.hbaseRootDir);
        this.hbaseConfiguration.set("hbase.zookeeper.property.clientPort", this.zookeeperPort.toString());
        this.hbaseConfiguration.set("hbase.zookeeper.quorum", this.zookeeperConnectionString);
        this.hbaseConfiguration.set("zookeeper.znode.parent", this.zookeeperZnodeParent);
        this.hbaseConfiguration.set("hbase.replication", this.hbaseWalReplicationEnabled.toString());
        this.hbaseConfiguration.set("hbase.splitlog.manager.unassigned.timeout", "999999999");
        this.hbaseConfiguration.set("hbase.splitlog.manager.timeoutmonitor.period", "999999999");
        WindowsLibsUtils.setHadoopHome();
    }

    public void cleanUp() throws Exception {
        FileUtils.deleteFolder((String)this.hbaseRootDir);
    }

    public static class Builder {
        private Integer hbaseMasterPort;
        private Integer hbaseMasterInfoPort;
        private Integer numRegionServers;
        private String hbaseRootDir;
        private Integer zookeeperPort;
        private String zookeeperConnectionString;
        private String zookeeperZnodeParent;
        private Boolean hbaseWalReplicationEnabled;
        private Configuration hbaseConfiguration;

        public Builder setHbaseMasterPort(Integer hbaseMasterPort) {
            this.hbaseMasterPort = hbaseMasterPort;
            return this;
        }

        public Builder setHbaseMasterInfoPort(Integer hbaseMasterInfoPort) {
            this.hbaseMasterInfoPort = hbaseMasterInfoPort;
            return this;
        }

        public Builder setNumRegionServers(Integer numRegionServers) {
            this.numRegionServers = numRegionServers;
            return this;
        }

        public Builder setHbaseRootDir(String hbaseRootDir) {
            this.hbaseRootDir = hbaseRootDir;
            return this;
        }

        public Builder setZookeeperPort(Integer zookeeperPort) {
            this.zookeeperPort = zookeeperPort;
            return this;
        }

        public Builder setZookeeperConnectionString(String zookeeperConnectionString) {
            this.zookeeperConnectionString = zookeeperConnectionString;
            return this;
        }

        public Builder setZookeeperZnodeParent(String zookeeperZnodeParent) {
            this.zookeeperZnodeParent = zookeeperZnodeParent;
            return this;
        }

        public Builder setHbaseWalReplicationEnabled(Boolean hbaseWalReplicationEnabled) {
            this.hbaseWalReplicationEnabled = hbaseWalReplicationEnabled;
            return this;
        }

        public Builder setHbaseConfiguration(Configuration hbaseConfiguration) {
            this.hbaseConfiguration = hbaseConfiguration;
            return this;
        }

        public HbaseLocalCluster build() {
            HbaseLocalCluster hbaseLocalCluster = new HbaseLocalCluster(this);
            this.validateObject(hbaseLocalCluster);
            return hbaseLocalCluster;
        }

        public void validateObject(HbaseLocalCluster hbaseLocalCluster) {
            if (hbaseLocalCluster.hbaseMasterPort == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HBase Master Port");
            }
            if (hbaseLocalCluster.hbaseMasterInfoPort == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HBase Master Info Port");
            }
            if (hbaseLocalCluster.numRegionServers == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HBase Number of Region Servers");
            }
            if (hbaseLocalCluster.hbaseRootDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HBase Root Dir");
            }
            if (hbaseLocalCluster.zookeeperPort == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Zookeeper Port");
            }
            if (hbaseLocalCluster.zookeeperConnectionString == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Zookeeper Connection String");
            }
            if (hbaseLocalCluster.zookeeperZnodeParent == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Zookeeper Znode Parent");
            }
            if (hbaseLocalCluster.hbaseWalReplicationEnabled == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HBase WAL Replication Enabled");
            }
            if (hbaseLocalCluster.hbaseConfiguration == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: HBase Configuration");
            }
        }
    }
}

