/*
 * Messages.java
 * Copyright 2020 Rob Spoor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file has been generated by i18n-maven-plugin
// (https://robtimus.github.io/i18n-maven-plugin/)

package com.github.robtimus.obfuscation.json;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

@SuppressWarnings("nls")
final class Messages {

    private static final Map<Locale, ResourceBundle> BUNDLES = new ConcurrentHashMap<>();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + getClass().getName());
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        Locale l = nonNull(locale);
        return BUNDLES.computeIfAbsent(l, k -> ResourceBundle.getBundle("com.github.robtimus.obfuscation.json.obfuscation-json", l));
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final JSONObfuscator_ JSONObfuscator = new JSONObfuscator_();

    static final class JSONObfuscator_ {

        private JSONObfuscator_() {
            super();
        }

        final MalformedJSON_ malformedJSON = new MalformedJSON_();

        static final class MalformedJSON_ {

            private MalformedJSON_() {
                super();
            }

            String warning() {
                return warning(null);
            }

            String warning(Locale locale) {
                Locale l = nonNull(locale);
                return getString(l, "JSONObfuscator.malformedJSON.warning");
            }

            String text() {
                return text(null);
            }

            String text(Locale locale) {
                Locale l = nonNull(locale);
                return getString(l, "JSONObfuscator.malformedJSON.text");
            }
        }

        String unexpectedEvent(Object arg) {
            return unexpectedEvent(null, arg);
        }

        String unexpectedEvent(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "JSONObfuscator.unexpectedEvent");
            return String.format(l, s, arg);
        }
    }
}
