/*
 * Messages.java
 * Copyright 2017 Rob Spoor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file has been generated by i18n-maven-plugin
// (https://robtimus.github.io/i18n-maven-plugin/)

package com.github.robtimus.net.protocol.data;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

@SuppressWarnings("nls")
final class Messages {

    private static final Map<Locale, ResourceBundle> BUNDLES = new HashMap<>();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + getClass().getName());
    }

    private static synchronized ResourceBundle getResourceBundle(Locale locale) {
        Locale l = nonNull(locale);
        ResourceBundle bundle = BUNDLES.get(l);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("com.github.robtimus.net.protocol.data.data-url", l);
            BUNDLES.put(l, bundle);
        }
        return bundle;
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final DataURLConnection_ dataURLConnection = new DataURLConnection_();

    static final class DataURLConnection_ {

        private DataURLConnection_() {
            super();
        }

        final GetInputStream_ getInputStream = new GetInputStream_();

        static final class GetInputStream_ {

            private GetInputStream_() {
                super();
            }

            final FalseDoInput_ falseDoInput = new FalseDoInput_();

            static final class FalseDoInput_ {

                private FalseDoInput_() {
                    super();
                }

                String get() {
                    return get(null);
                }

                String get(Locale locale) {
                    Locale l = nonNull(locale);
                    return getString(l, "dataURLConnection.getInputStream.falseDoInput");
                }
            }
        }
    }

    static final Handler_ handler = new Handler_();

    static final class Handler_ {

        private Handler_() {
            super();
        }

        final InvalidProtocol_ invalidProtocol = new InvalidProtocol_();

        static final class InvalidProtocol_ {

            private InvalidProtocol_() {
                super();
            }

            String get(
                    Object arg1,
                    Object arg2) {

                return get(null,
                        arg1,
                        arg2
                );
            }

            String get(Locale locale,
                    Object arg1,
                    Object arg2) {

                Locale l = nonNull(locale);
                String s = getString(l, "handler.invalidProtocol");
                return String.format(l, s,
                        arg1,
                        arg2
                );
            }
        }

        final MissingComma_ missingComma = new MissingComma_();

        static final class MissingComma_ {

            private MissingComma_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "handler.missingComma");
                return String.format(l, s, arg);
            }
        }
    }

    static final MediaType_ mediaType = new MediaType_();

    static final class MediaType_ {

        private MediaType_() {
            super();
        }

        final InvalidMimeType_ invalidMimeType = new InvalidMimeType_();

        static final class InvalidMimeType_ {

            private InvalidMimeType_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "mediaType.invalidMimeType");
                return String.format(l, s, arg);
            }
        }
    }
}
