@file:JvmName("Utils")

package com.github.richardwrq.krouter.compiler

import com.github.richardwrq.krouter.annotation.PACKAGE
import com.github.richardwrq.krouter.annotation.SEPARATOR

/**
 * KRouter class or interface
 *
 * @author: Wuruiqiang <a href="mailto:263454190@qq.com">Contact me.</a>
 * @version: v1.0
 * @since: 18/1/4 下午6:38
 */
const val ROUTE_LOADER = "$PACKAGE.api.interfaces.IRouteLoader"
const val INTERCEPTOR_LOADER = "$PACKAGE.api.interfaces.IInterceptorLoader"
const val PROVIDER_LOADER = "$PACKAGE.api.interfaces.IProviderLoader"
const val INJECTOR = "$PACKAGE.api.interfaces.IInjector"
const val INTERCEPTOR = "$PACKAGE.api.interfaces.IRouteInterceptor"
const val PROVIDER = "$PACKAGE.api.interfaces.IProvider"
const val KROUTER = "$PACKAGE.api.core.KRouter"
const val SERIALIZE_PATH = "$PACKAGE.api.utils.SERIALIZE_PATH"
const val SERIALIZE_PROVIDER = "$PACKAGE.api.interfaces.SerializationProvider"
const val TYPE_TOKEN = "$PACKAGE.api.utils.TypeToken"

/**
 * Android Type
 */
const val BUNDLE = "android.os.Bundle"

/**
 * JAVA Type
 */
const val LANG = "java.lang"
const val TYPE = "$LANG.reflect.Type"
const val ILLEGAL_ARGUMENT_EXCEPTION = "$LANG.IllegalArgumentException"
const val NP_EXCEPTION = "$LANG.NullPointerException"

/**
 * Annotation Type
 */
const val METADATA = "kotlin.Metadata"
const val NONNULL = "android.support.annotation.NonNull"

const val KAPT_KOTLIN_GENERATED_OPTION_NAME = "kapt.kotlin.generated"

val WARNINGS = """   ***************************************************
                  |   * THIS CODE IS GENERATED BY KRouter, DO NOT EDIT. *
                  |   ***************************************************
                     |""".trimMargin()

const val METHOD_LOAD = "loadInto"
const val METHOD_EX_INJECT = "exInject"
const val METHOD_INJECT = "inject"
const val METHOD_GET_BUNDLE = "getBundle"
const val METHOD_PARSE_OBJECT = "parseObject"


