/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb.util;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.river.mongodb.Status;

public abstract class MongoDBRiverHelper {
    private static final ESLogger logger = Loggers.getLogger(MongoDBRiverHelper.class);

    public static Status getRiverStatus(Client client, String riverName) {
        GetResponse statusResponse = (GetResponse)client.prepareGet("_river", riverName, "_riverstatus").get();
        if (!statusResponse.isExists()) {
            return Status.UNKNOWN;
        }
        Object obj = XContentMapValues.extractValue((String)"mongodb.status", (Map)statusResponse.getSourceAsMap());
        return Status.valueOf(obj.toString());
    }

    public static void setRiverStatus(Client client, String riverName, Status status) {
        logger.info("setRiverStatus called with {} - {}", new Object[]{riverName, status});
        try {
            XContentBuilder xb = XContentFactory.jsonBuilder().startObject().startObject("mongodb").field("status", (Object)status).endObject().endObject();
            client.prepareIndex("_river", riverName, "_riverstatus").setSource(xb).get();
        }
        catch (IOException ioEx) {
            logger.error("setRiverStatus failed for river {}", (Throwable)ioEx, new Object[]{riverName});
        }
    }
}

