/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb.util;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public abstract class MongoDBHelper {
    public static XContentBuilder serialize(GridFSDBFile file) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream stream = file.getInputStream();){
            int nRead;
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String encodedContent = Base64.encodeBytes((byte[])buffer.toByteArray());
        buffer.close();
        builder.startObject();
        builder.startObject("content");
        builder.field("_content_type", file.getContentType());
        builder.field("_title", file.getFilename());
        builder.field("_content", encodedContent);
        builder.endObject();
        builder.field("filename", file.getFilename());
        builder.field("contentType", file.getContentType());
        builder.field("md5", file.getMD5());
        builder.field("length", file.getLength());
        builder.field("chunkSize", file.getChunkSize());
        builder.field("uploadDate", file.getUploadDate());
        builder.startObject("metadata");
        DBObject metadata = file.getMetaData();
        if (metadata != null) {
            for (String key : metadata.keySet()) {
                builder.field(key, metadata.get(key));
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static DBObject applyExcludeFields(DBObject bsonObject, Set<String> excludeFields) {
        if (excludeFields == null) {
            return bsonObject;
        }
        DBObject filteredObject = bsonObject;
        for (String field : excludeFields) {
            if (field.contains(".")) {
                Object object;
                String rootObject = field.substring(0, field.indexOf("."));
                String childObject = field.substring(field.indexOf(".") + 1);
                if (!filteredObject.containsField(rootObject) || !((object = filteredObject.get(rootObject)) instanceof DBObject)) continue;
                DBObject object2 = (DBObject)object;
                object2 = MongoDBHelper.applyExcludeFields(object2, new HashSet<String>(Arrays.asList(childObject)));
                continue;
            }
            if (!filteredObject.containsField(field)) continue;
            filteredObject.removeField(field);
        }
        return filteredObject;
    }

    private static Set<String> getChildItems(String parent, Set<String> fields) {
        HashSet children = Sets.newHashSet();
        for (String field : fields) {
            if (field.startsWith(String.valueOf(parent) + ".")) {
                children.add(field.substring((String.valueOf(parent) + ".").length()));
                continue;
            }
            if (!field.startsWith(parent)) continue;
            children.add(field);
        }
        return children;
    }

    public static DBObject applyIncludeFields(DBObject bsonObject, Set<String> includeFields) {
        if (includeFields == null) {
            return bsonObject;
        }
        BasicDBObject filteredObject = new BasicDBObject();
        for (String field : bsonObject.keySet()) {
            if (!includeFields.contains(field)) continue;
            filteredObject.put(field, bsonObject.get(field));
        }
        for (String field : includeFields) {
            String rootObject;
            Object object;
            if (!field.contains(".") || !((object = bsonObject.get(rootObject = field.substring(0, field.indexOf(".")))) instanceof DBObject)) continue;
            DBObject object2 = (DBObject)object;
            System.out.println(MongoDBHelper.getChildItems(rootObject, includeFields));
            object2 = MongoDBHelper.applyIncludeFields(object2, MongoDBHelper.getChildItems(rootObject, includeFields));
            filteredObject.put(rootObject, (Object)object2);
        }
        return filteredObject;
    }

    public static String getRiverVersion() {
        String version = "Undefined";
        try {
            String properties = Streams.copyToStringFromClasspath((String)"/org/elasticsearch/river/mongodb/es-build.properties");
            Properties props = new Properties();
            props.load((Reader)new FastStringReader(properties));
            String ver = props.getProperty("version", "undefined");
            String hash = props.getProperty("hash", "undefined");
            if (!"undefined".equals(hash)) {
                hash = hash.substring(0, 7);
            }
            String timestamp = "undefined";
            String gitTimestampRaw = props.getProperty("timestamp");
            if (gitTimestampRaw != null) {
                timestamp = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).print(Long.parseLong(gitTimestampRaw));
            }
            version = String.format("version[%s] - hash[%s] - time[%s]", ver, hash, timestamp);
        }
        catch (Exception exception) {}
        return version;
    }

    public static DBObject applyFieldFilter(DBObject object, Set<String> includeFields, Set<String> excludeFields) {
        if (object instanceof GridFSFile) {
            GridFSFile file = (GridFSFile)object;
            DBObject metadata = file.getMetaData();
            if (metadata != null) {
                file.setMetaData(MongoDBHelper.applyFieldFilter(metadata, includeFields, excludeFields));
            }
        } else {
            object = MongoDBHelper.applyExcludeFields(object, excludeFields);
            object = MongoDBHelper.applyIncludeFields(object, includeFields);
        }
        return object;
    }
}

