/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb.rest;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.river.mongodb.rest.action.support.RestXContentBuilder;

public class XContentThrowableRestResponse
extends BytesRestResponse {
    public XContentThrowableRestResponse(RestRequest request, Throwable t) throws IOException {
        this(request, t instanceof ElasticsearchException ? ((ElasticsearchException)t).status() : RestStatus.INTERNAL_SERVER_ERROR, t);
    }

    public XContentThrowableRestResponse(RestRequest request, RestStatus status, Throwable t) throws IOException {
        super(status, XContentThrowableRestResponse.convert(request, status, t));
    }

    private static XContentBuilder convert(RestRequest request, RestStatus status, Throwable t) throws IOException {
        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request).startObject().field("error", ExceptionsHelper.detailedMessage((Throwable)t)).field("status", status.getStatus());
        if (t != null && request.paramAsBoolean("error_trace", false)) {
            builder.startObject("error_trace");
            boolean first = true;
            while (t != null) {
                if (!first) {
                    builder.startObject("cause");
                }
                XContentThrowableRestResponse.buildThrowable(t, builder);
                if (!first) {
                    builder.endObject();
                }
                t = t.getCause();
                first = false;
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static void buildThrowable(Throwable t, XContentBuilder builder) throws IOException {
        builder.field("message", t.getMessage());
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stElement = stackTraceElementArray[n2];
            builder.startObject("at").field("class", stElement.getClassName()).field("method", stElement.getMethodName());
            if (stElement.getFileName() != null) {
                builder.field("file", stElement.getFileName());
            }
            if (stElement.getLineNumber() >= 0) {
                builder.field("line", stElement.getLineNumber());
            }
            builder.endObject();
            ++n2;
        }
    }
}

