/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import com.google.common.primitives.UnsignedBytes;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONSerializers;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class Timestamp<T extends Timestamp<T>>
implements Comparable<Timestamp<T>> {
    public abstract long getTime();

    public static int compare(Timestamp oplogTimestamp, Timestamp startTimestamp) {
        return oplogTimestamp.compareTo(startTimestamp);
    }

    public static Timestamp<?> on(DBObject entry) {
        return Timestamp.on(entry.toMap(), false);
    }

    public static Timestamp<?> on(Map<String, Object> map) {
        return Timestamp.on(map, true);
    }

    private static Timestamp<?> on(Map map, boolean meta) {
        String tsField = meta ? "_last_ts" : "ts";
        Object timestamp = map.get(tsField);
        if (timestamp == null) {
            return null;
        }
        if (timestamp instanceof String) {
            timestamp = JSON.parse((String)((String)timestamp));
        }
        if (timestamp instanceof BSONTimestamp) {
            BSON result = new BSON((BSONTimestamp)timestamp);
            return result;
        }
        if (timestamp instanceof Date) {
            String gtidField = meta ? "_last_gtid" : "_id";
            Object id = map.get(gtidField);
            GTID result = null;
            if (id == null) {
                throw new IllegalStateException("Missing property: " + gtidField);
            }
            if (id instanceof String) {
                id = JSON.parse((String)((String)id));
            }
            if (id instanceof Binary) {
                result = new GTID(((Binary)id).getData(), (Date)timestamp);
            } else if (id instanceof byte[]) {
                result = new GTID((byte[])id, (Date)timestamp);
            }
            if (result == null) {
                throw new IllegalStateException("Unable to parse " + gtidField + " " + id + " of type " + id.getClass());
            }
            return result;
        }
        throw new IllegalStateException("Unable to parse " + tsField + " " + timestamp + " of type " + timestamp.getClass());
    }

    public abstract DBObject getOplogFilter();

    public abstract void saveFields(XContentBuilder var1) throws IOException;

    public static final class BSON
    extends Timestamp<BSON> {
        private final BSONTimestamp ts;

        public BSON(BSONTimestamp ts) {
            if (ts == null) {
                throw new IllegalArgumentException("ts must not be null");
            }
            this.ts = ts;
        }

        @Override
        public int compareTo(Timestamp<BSON> o) {
            return this.ts.compareTo(((BSON)o).ts);
        }

        public boolean equals(Object o) {
            return o instanceof BSON && this.ts.equals((Object)((BSON)o).ts);
        }

        public int hashCode() {
            return this.ts.hashCode();
        }

        public String toString() {
            return "Timestamp.BSON(ts=" + JSON.serialize((Object)this.ts) + ")";
        }

        @Override
        public long getTime() {
            return (long)this.ts.getTime() * 1000L;
        }

        @Override
        public DBObject getOplogFilter() {
            return new BasicDBObject("ts", (Object)new BasicDBObject("$gte", (Object)this.ts));
        }

        @Override
        public void saveFields(XContentBuilder builder) throws IOException {
            builder.field("_last_ts", JSON.serialize((Object)this.ts));
        }
    }

    public static final class GTID
    extends Timestamp<GTID> {
        private final byte[] gtid;
        private final Date ts;

        public GTID(byte[] gtid, Date ts) {
            if (gtid == null) {
                throw new IllegalArgumentException("gtid must not be null");
            }
            if (gtid.length != 16) {
                throw new IllegalArgumentException("gtid must encode two unsigned longs (128 total bits in length)");
            }
            this.gtid = gtid;
            this.ts = ts;
        }

        @Override
        public int compareTo(Timestamp<GTID> o) {
            return UnsignedBytes.lexicographicalComparator().compare(this.gtid, ((GTID)o).gtid);
        }

        public boolean equals(Object o) {
            return o instanceof GTID && Arrays.equals(this.gtid, ((GTID)o).gtid);
        }

        public int hashCode() {
            return Arrays.hashCode(this.gtid);
        }

        public String toString() {
            return "Timestamp.GTID(ts=" + JSON.serialize((Object)this.ts) + ", gtid=" + JSONSerializers.getStrict().serialize((Object)this.gtid) + ")";
        }

        @Override
        public long getTime() {
            return this.ts.getTime();
        }

        @Override
        public DBObject getOplogFilter() {
            return new BasicDBObject("_id", (Object)new BasicDBObject("$gte", (Object)this.gtid));
        }

        @Override
        public void saveFields(XContentBuilder builder) throws IOException {
            builder.field("_last_ts", JSON.serialize((Object)this.ts));
            builder.field("_last_gtid", JSONSerializers.getStrict().serialize((Object)this.gtid));
        }
    }
}

