/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import org.elasticsearch.river.mongodb.MongoDBRiver;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;
import org.elasticsearch.river.mongodb.SharedContext;
import org.elasticsearch.river.mongodb.Status;
import org.elasticsearch.river.mongodb.util.MongoDBRiverHelper;

class StatusChecker
implements Runnable {
    private final MongoDBRiver mongoDBRiver;
    private final MongoDBRiverDefinition definition;
    private final SharedContext context;

    public StatusChecker(MongoDBRiver mongoDBRiver, MongoDBRiverDefinition definition, SharedContext context) {
        this.mongoDBRiver = mongoDBRiver;
        this.definition = definition;
        this.context = context;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Status status;
                if ((status = MongoDBRiverHelper.getRiverStatus(this.mongoDBRiver.esClient, this.definition.getRiverName())) != this.context.getStatus()) {
                    if (status == Status.RUNNING) {
                        MongoDBRiver.logger.trace("About to start river: {}", new Object[]{this.definition.getRiverName()});
                        this.mongoDBRiver.start();
                    } else if (status == Status.STOPPED) {
                        MongoDBRiver.logger.info("About to stop river: {}", new Object[]{this.definition.getRiverName()});
                        this.mongoDBRiver.close();
                    }
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            MongoDBRiver.logger.debug("Status thread interrupted", (Throwable)e, new Object[]{null});
            Thread.currentThread().interrupt();
            return;
        }
    }
}

