/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.river.RiverSettings;
import org.elasticsearch.river.mongodb.Timestamp;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;

public class MongoDBRiverDefinition {
    private static final ESLogger logger = Loggers.getLogger(MongoDBRiverDefinition.class);
    public static final String DEFAULT_DB_HOST = "localhost";
    public static final int DEFAULT_DB_PORT = 27017;
    public static final int DEFAULT_CONCURRENT_REQUESTS = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_BULK_ACTIONS = 1000;
    public static final TimeValue DEFAULT_FLUSH_INTERVAL = TimeValue.timeValueMillis((long)10L);
    public static final ByteSizeValue DEFAULT_BULK_SIZE = new ByteSizeValue(5L, ByteSizeUnit.MB);
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    public static final int DEFAULT_CONNECTIONS_PER_HOST = 100;
    public static final int DEFAULT_THREADS_ALLOWED_TO_BLOCK_FOR_CONNECTION_MULTIPLIER = 5;
    public static final String DB_FIELD = "db";
    public static final String SERVERS_FIELD = "servers";
    public static final String HOST_FIELD = "host";
    public static final String PORT_FIELD = "port";
    public static final String OPTIONS_FIELD = "options";
    public static final String SECONDARY_READ_PREFERENCE_FIELD = "secondary_read_preference";
    public static final String CONNECT_TIMEOUT = "connect_timeout";
    public static final String SOCKET_TIMEOUT = "socket_timeout";
    public static final String SSL_CONNECTION_FIELD = "ssl";
    public static final String SSL_VERIFY_CERT_FIELD = "ssl_verify_certificate";
    public static final String IS_MONGOS_FIELD = "is_mongos";
    public static final String DROP_COLLECTION_FIELD = "drop_collection";
    public static final String EXCLUDE_FIELDS_FIELD = "exclude_fields";
    public static final String INCLUDE_FIELDS_FIELD = "include_fields";
    public static final String INCLUDE_COLLECTION_FIELD = "include_collection";
    public static final String INITIAL_TIMESTAMP_FIELD = "initial_timestamp";
    public static final String INITIAL_TIMESTAMP_SCRIPT_TYPE_FIELD = "script_type";
    public static final String INITIAL_TIMESTAMP_SCRIPT_FIELD = "script";
    public static final String ADVANCED_TRANSFORMATION_FIELD = "advanced_transformation";
    public static final String SKIP_INITIAL_IMPORT_FIELD = "skip_initial_import";
    public static final String CONNECTIONS_PER_HOST = "connections_per_host";
    public static final String THREADS_ALLOWED_TO_BLOCK_FOR_CONNECTION_MULTIPLIER = "threads_allowed_to_block_for_connection_multiplier";
    public static final String PARENT_TYPES_FIELD = "parent_types";
    public static final String STORE_STATISTICS_FIELD = "store_statistics";
    public static final String IMPORT_ALL_COLLECTIONS_FIELD = "import_all_collections";
    public static final String DISABLE_INDEX_REFRESH_FIELD = "disable_index_refresh";
    public static final String FILTER_FIELD = "filter";
    public static final String CREDENTIALS_FIELD = "credentials";
    public static final String USER_FIELD = "user";
    public static final String PASSWORD_FIELD = "password";
    public static final String AUTH_FIELD = "auth";
    public static final String SCRIPT_FIELD = "script";
    public static final String SCRIPT_TYPE_FIELD = "script_type";
    public static final String COLLECTION_FIELD = "collection";
    public static final String GRIDFS_FIELD = "gridfs";
    public static final String INDEX_OBJECT = "index";
    public static final String NAME_FIELD = "name";
    public static final String TYPE_FIELD = "type";
    public static final String LOCAL_DB_FIELD = "local";
    public static final String ADMIN_DB_FIELD = "admin";
    public static final String THROTTLE_SIZE_FIELD = "throttle_size";
    public static final String BULK_SIZE_FIELD = "bulk_size";
    public static final String BULK_TIMEOUT_FIELD = "bulk_timeout";
    public static final String CONCURRENT_BULK_REQUESTS_FIELD = "concurrent_bulk_requests";
    public static final String BULK_FIELD = "bulk";
    public static final String ACTIONS_FIELD = "actions";
    public static final String SIZE_FIELD = "size";
    public static final String CONCURRENT_REQUESTS_FIELD = "concurrent_requests";
    public static final String FLUSH_INTERVAL_FIELD = "flush_interval";
    private final String riverName;
    private final String riverIndexName;
    private final List<ServerAddress> mongoServers = new ArrayList<ServerAddress>();
    private final String mongoDb;
    private final String mongoCollection;
    private final boolean mongoGridFS;
    private final BasicDBObject mongoOplogFilter;
    private final BasicDBObject mongoCollectionFilter;
    private final String mongoAdminUser;
    private final String mongoAdminPassword;
    private final String mongoAdminAuthDatabase;
    private final String mongoLocalUser;
    private final String mongoLocalPassword;
    private final String mongoLocalAuthDatabase;
    private final MongoClientOptions mongoClientOptions;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean mongoSecondaryReadPreference;
    private final boolean mongoUseSSL;
    private final boolean mongoSSLVerifyCertificate;
    private final boolean dropCollection;
    private final Boolean isMongos;
    private final Set<String> excludeFields;
    private final Set<String> includeFields;
    private final String includeCollection;
    private final Timestamp<?> initialTimestamp;
    private final String script;
    private final String scriptType;
    private final boolean advancedTransformation;
    private final boolean skipInitialImport;
    private final Set<String> parentTypes;
    private final boolean storeStatistics;
    private final String statisticsIndexName;
    private final String statisticsTypeName;
    private final boolean importAllCollections;
    private final boolean disableIndexRefresh;
    private final String indexName;
    private final String typeName;
    private final int throttleSize;
    private final Bulk bulk;

    public static synchronized MongoDBRiverDefinition parseSettings(String riverName, String riverIndexName, RiverSettings settings, ScriptService scriptService) {
        logger.trace("Parse river settings for {}", new Object[]{riverName});
        Preconditions.checkNotNull((Object)riverName, (Object)"No riverName specified");
        Preconditions.checkNotNull((Object)riverIndexName, (Object)"No riverIndexName specified");
        Preconditions.checkNotNull((Object)settings, (Object)"No settings specified");
        Builder builder = new Builder();
        builder.riverName(riverName);
        builder.riverIndexName(riverIndexName);
        ArrayList<ServerAddress> mongoServers = new ArrayList<ServerAddress>();
        if (settings.settings().containsKey("mongodb")) {
            MongoClientOptions.Builder mongoClientOptionsBuilder;
            Map mongoSettings;
            block53: {
                int mongoPort;
                String mongoHost;
                mongoSettings = (Map)settings.settings().get("mongodb");
                if (mongoSettings.containsKey(SERVERS_FIELD)) {
                    Object mongoServersSettings = mongoSettings.get(SERVERS_FIELD);
                    logger.trace("mongoServersSettings: " + mongoServersSettings, new Object[0]);
                    boolean array = XContentMapValues.isArray(mongoServersSettings);
                    if (array) {
                        ArrayList feeds = (ArrayList)mongoServersSettings;
                        for (Map feed : feeds) {
                            mongoHost = XContentMapValues.nodeStringValue(feed.get(HOST_FIELD), null);
                            mongoPort = XContentMapValues.nodeIntegerValue(feed.get(PORT_FIELD), (int)27017);
                            logger.trace("Server: " + mongoHost + " - " + mongoPort, new Object[0]);
                            try {
                                mongoServers.add(new ServerAddress(mongoHost, mongoPort));
                            }
                            catch (UnknownHostException uhEx) {
                                logger.warn("Cannot add mongo server {}:{}", (Throwable)uhEx, new Object[]{mongoHost, mongoPort});
                            }
                        }
                    }
                } else {
                    mongoHost = XContentMapValues.nodeStringValue(mongoSettings.get(HOST_FIELD), (String)DEFAULT_DB_HOST);
                    mongoPort = XContentMapValues.nodeIntegerValue(mongoSettings.get(PORT_FIELD), (int)27017);
                    try {
                        mongoServers.add(new ServerAddress(mongoHost, mongoPort));
                    }
                    catch (UnknownHostException uhEx) {
                        logger.warn("Cannot add mongo server {}:{}", (Throwable)uhEx, new Object[]{mongoHost, mongoPort});
                    }
                }
                builder.mongoServers(mongoServers);
                mongoClientOptionsBuilder = MongoClientOptions.builder().socketKeepAlive(true);
                if (mongoSettings.containsKey(OPTIONS_FIELD)) {
                    ArrayList fields;
                    Map mongoOptionsSettings = (Map)mongoSettings.get(OPTIONS_FIELD);
                    logger.trace("mongoOptionsSettings: " + mongoOptionsSettings, new Object[0]);
                    builder.mongoSecondaryReadPreference(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(SECONDARY_READ_PREFERENCE_FIELD), (boolean)false));
                    builder.connectTimeout(XContentMapValues.nodeIntegerValue(mongoOptionsSettings.get(CONNECT_TIMEOUT), (int)30000));
                    builder.socketTimeout(XContentMapValues.nodeIntegerValue(mongoOptionsSettings.get(SOCKET_TIMEOUT), (int)60000));
                    builder.dropCollection(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(DROP_COLLECTION_FIELD), (boolean)false));
                    String isMongos = XContentMapValues.nodeStringValue(mongoOptionsSettings.get(IS_MONGOS_FIELD), null);
                    if (isMongos != null) {
                        builder.isMongos(Boolean.valueOf(isMongos));
                    }
                    builder.mongoUseSSL(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(SSL_CONNECTION_FIELD), (boolean)false));
                    builder.mongoSSLVerifyCertificate(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(SSL_VERIFY_CERT_FIELD), (boolean)true));
                    builder.advancedTransformation(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(ADVANCED_TRANSFORMATION_FIELD), (boolean)false));
                    builder.skipInitialImport(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(SKIP_INITIAL_IMPORT_FIELD), (boolean)false));
                    builder.connectionsPerHost(XContentMapValues.nodeIntegerValue(mongoOptionsSettings.get(CONNECTIONS_PER_HOST), (int)100));
                    builder.threadsAllowedToBlockForConnectionMultiplier(XContentMapValues.nodeIntegerValue(mongoOptionsSettings.get(THREADS_ALLOWED_TO_BLOCK_FOR_CONNECTION_MULTIPLIER), (int)5));
                    mongoClientOptionsBuilder.connectTimeout(builder.connectTimeout).socketTimeout(builder.socketTimeout).connectionsPerHost(builder.connectionsPerHost).threadsAllowedToBlockForConnectionMultiplier(builder.threadsAllowedToBlockForConnectionMultiplier);
                    if (builder.mongoSecondaryReadPreference) {
                        mongoClientOptionsBuilder.readPreference(ReadPreference.secondaryPreferred());
                    }
                    if (builder.mongoUseSSL) {
                        mongoClientOptionsBuilder.socketFactory(MongoDBRiverDefinition.getSSLSocketFactory());
                    }
                    if (mongoOptionsSettings.containsKey(PARENT_TYPES_FIELD)) {
                        HashSet<String> parentTypes = new HashSet<String>();
                        Object parentTypesSettings = mongoOptionsSettings.get(PARENT_TYPES_FIELD);
                        logger.trace("parentTypesSettings: " + parentTypesSettings, new Object[0]);
                        boolean array = XContentMapValues.isArray(parentTypesSettings);
                        if (array) {
                            fields = (ArrayList)parentTypesSettings;
                            for (String field : fields) {
                                logger.trace("Field: " + field, new Object[0]);
                                parentTypes.add(field);
                            }
                        }
                        builder.parentTypes(parentTypes);
                    }
                    if (mongoOptionsSettings.containsKey(STORE_STATISTICS_FIELD)) {
                        Object storeStatistics = mongoOptionsSettings.get(STORE_STATISTICS_FIELD);
                        boolean object = XContentMapValues.isObject(storeStatistics);
                        if (object) {
                            Map storeStatisticsSettings = (Map)storeStatistics;
                            builder.storeStatistics(true);
                            builder.statisticsIndexName(XContentMapValues.nodeStringValue(storeStatisticsSettings.get(INDEX_OBJECT), (String)(String.valueOf(riverName) + "-stats")));
                            builder.statisticsTypeName(XContentMapValues.nodeStringValue(storeStatisticsSettings.get(TYPE_FIELD), (String)"stats"));
                        } else {
                            builder.storeStatistics(XContentMapValues.nodeBooleanValue(storeStatistics, (boolean)false));
                            if (builder.storeStatistics) {
                                builder.statisticsIndexName(String.valueOf(riverName) + "-stats");
                                builder.statisticsTypeName("stats");
                            }
                        }
                    }
                    builder.importAllCollections(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(IMPORT_ALL_COLLECTIONS_FIELD), (boolean)false));
                    builder.disableIndexRefresh(XContentMapValues.nodeBooleanValue(mongoOptionsSettings.get(DISABLE_INDEX_REFRESH_FIELD), (boolean)false));
                    builder.includeCollection(XContentMapValues.nodeStringValue(mongoOptionsSettings.get(INCLUDE_COLLECTION_FIELD), (String)""));
                    if (mongoOptionsSettings.containsKey(INCLUDE_FIELDS_FIELD)) {
                        HashSet<String> includeFields = new HashSet<String>();
                        Object includeFieldsSettings = mongoOptionsSettings.get(INCLUDE_FIELDS_FIELD);
                        logger.trace("includeFieldsSettings: " + includeFieldsSettings, new Object[0]);
                        boolean array = XContentMapValues.isArray(includeFieldsSettings);
                        if (array) {
                            fields = (ArrayList)includeFieldsSettings;
                            for (String field : fields) {
                                logger.trace("Field: " + field, new Object[0]);
                                includeFields.add(field);
                            }
                        }
                        if (!includeFields.contains("_id")) {
                            includeFields.add("_id");
                        }
                        builder.includeFields(includeFields);
                    } else if (mongoOptionsSettings.containsKey(EXCLUDE_FIELDS_FIELD)) {
                        HashSet<String> excludeFields = new HashSet<String>();
                        Object excludeFieldsSettings = mongoOptionsSettings.get(EXCLUDE_FIELDS_FIELD);
                        logger.trace("excludeFieldsSettings: " + excludeFieldsSettings, new Object[0]);
                        boolean array = XContentMapValues.isArray(excludeFieldsSettings);
                        if (array) {
                            fields = (ArrayList)excludeFieldsSettings;
                            for (String field : fields) {
                                logger.trace("Field: " + field, new Object[0]);
                                excludeFields.add(field);
                            }
                        }
                        builder.excludeFields(excludeFields);
                    }
                    if (mongoOptionsSettings.containsKey(INITIAL_TIMESTAMP_FIELD)) {
                        BSONTimestamp timeStamp = null;
                        try {
                            try {
                                Map initalTimestampSettings = (Map)mongoOptionsSettings.get(INITIAL_TIMESTAMP_FIELD);
                                String scriptType = "js";
                                if (initalTimestampSettings.containsKey("script_type")) {
                                    scriptType = initalTimestampSettings.get("script_type").toString();
                                }
                                if (initalTimestampSettings.containsKey("script")) {
                                    ExecutableScript scriptExecutable = scriptService.executable(scriptType, initalTimestampSettings.get("script").toString(), ScriptService.ScriptType.INLINE, (Map)Maps.newHashMap());
                                    Object ctx = scriptExecutable.run();
                                    logger.trace("initialTimestamp script returned: {}", new Object[]{ctx});
                                    if (ctx != null) {
                                        long timestamp = Long.parseLong(ctx.toString());
                                        timeStamp = new BSONTimestamp((int)(new Date(timestamp).getTime() / 1000L), 1);
                                    }
                                }
                            }
                            catch (Throwable t) {
                                logger.error("Could not set initial timestamp", t, new Object[0]);
                                builder.initialTimestamp(timeStamp);
                                break block53;
                            }
                        }
                        catch (Throwable throwable) {
                            builder.initialTimestamp(timeStamp);
                            throw throwable;
                        }
                        builder.initialTimestamp(timeStamp);
                    }
                }
            }
            builder.mongoClientOptions(mongoClientOptionsBuilder.build());
            if (mongoSettings.containsKey(CREDENTIALS_FIELD)) {
                String mau = "";
                String map = "";
                String maad = "";
                String mlu = "";
                String mlp = "";
                String mlad = "";
                Object mongoCredentialsSettings = mongoSettings.get(CREDENTIALS_FIELD);
                boolean array = XContentMapValues.isArray(mongoCredentialsSettings);
                if (array) {
                    ArrayList credentials = (ArrayList)mongoCredentialsSettings;
                    for (Map credential : credentials) {
                        String dbCredential = XContentMapValues.nodeStringValue(credential.get(DB_FIELD), null);
                        if (ADMIN_DB_FIELD.equals(dbCredential)) {
                            mau = XContentMapValues.nodeStringValue(credential.get(USER_FIELD), null);
                            map = XContentMapValues.nodeStringValue(credential.get(PASSWORD_FIELD), null);
                            maad = XContentMapValues.nodeStringValue(credential.get(AUTH_FIELD), null);
                            continue;
                        }
                        if (!LOCAL_DB_FIELD.equals(dbCredential)) continue;
                        mlu = XContentMapValues.nodeStringValue(credential.get(USER_FIELD), null);
                        mlp = XContentMapValues.nodeStringValue(credential.get(PASSWORD_FIELD), null);
                        mlad = XContentMapValues.nodeStringValue(credential.get(AUTH_FIELD), null);
                    }
                }
                builder.mongoAdminUser(mau);
                builder.mongoAdminPassword(map);
                builder.mongoAdminAuthDatabase(maad);
                builder.mongoLocalUser(mlu);
                builder.mongoLocalPassword(mlp);
                builder.mongoLocalAuthDatabase(mlad);
            }
            builder.mongoDb(XContentMapValues.nodeStringValue(mongoSettings.get(DB_FIELD), (String)riverName));
            builder.mongoCollection(XContentMapValues.nodeStringValue(mongoSettings.get(COLLECTION_FIELD), (String)riverName));
            builder.mongoGridFS(XContentMapValues.nodeBooleanValue(mongoSettings.get(GRIDFS_FIELD), (boolean)false));
            if (mongoSettings.containsKey(FILTER_FIELD)) {
                String filter = XContentMapValues.nodeStringValue(mongoSettings.get(FILTER_FIELD), (String)"");
                filter = MongoDBRiverDefinition.removePrefix("o.", filter);
                builder.mongoCollectionFilter(MongoDBRiverDefinition.convertToBasicDBObject(filter));
                builder.mongoOplogFilter(MongoDBRiverDefinition.convertToBasicDBObject(MongoDBRiverDefinition.removePrefix("o.", filter)));
            }
            if (mongoSettings.containsKey("script")) {
                String scriptType = "js";
                builder.script(mongoSettings.get("script").toString());
                if (mongoSettings.containsKey("scriptType")) {
                    scriptType = mongoSettings.get("scriptType").toString();
                } else if (mongoSettings.containsKey("script_type")) {
                    scriptType = mongoSettings.get("script_type").toString();
                }
                builder.scriptType(scriptType);
            }
        } else {
            String mongoHost = DEFAULT_DB_HOST;
            int mongoPort = 27017;
            try {
                mongoServers.add(new ServerAddress(mongoHost, mongoPort));
                builder.mongoServers(mongoServers);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            builder.mongoDb(riverName);
            builder.mongoCollection(riverName);
        }
        if (settings.settings().containsKey(INDEX_OBJECT)) {
            Map indexSettings = (Map)settings.settings().get(INDEX_OBJECT);
            builder.indexName(XContentMapValues.nodeStringValue(indexSettings.get(NAME_FIELD), (String)builder.mongoDb));
            builder.typeName(XContentMapValues.nodeStringValue(indexSettings.get(TYPE_FIELD), (String)builder.mongoDb));
            Bulk.Builder bulkBuilder = new Bulk.Builder();
            if (indexSettings.containsKey(BULK_FIELD)) {
                Map bulkSettings = (Map)indexSettings.get(BULK_FIELD);
                int bulkActions = XContentMapValues.nodeIntegerValue(bulkSettings.get(ACTIONS_FIELD), (int)1000);
                bulkBuilder.bulkActions(bulkActions);
                String size = XContentMapValues.nodeStringValue(bulkSettings.get(SIZE_FIELD), (String)DEFAULT_BULK_SIZE.toString());
                bulkBuilder.bulkSize(ByteSizeValue.parseBytesSizeValue((String)size));
                bulkBuilder.concurrentRequests(XContentMapValues.nodeIntegerValue(bulkSettings.get(CONCURRENT_REQUESTS_FIELD), (int)EsExecutors.boundedNumberOfProcessors((Settings)ImmutableSettings.EMPTY)));
                bulkBuilder.flushInterval(XContentMapValues.nodeTimeValue(bulkSettings.get(FLUSH_INTERVAL_FIELD), (TimeValue)DEFAULT_FLUSH_INTERVAL));
                builder.throttleSize(XContentMapValues.nodeIntegerValue(indexSettings.get(THROTTLE_SIZE_FIELD), (int)(bulkActions * 5)));
            } else {
                int bulkActions = XContentMapValues.nodeIntegerValue(indexSettings.get(BULK_SIZE_FIELD), (int)1000);
                bulkBuilder.bulkActions(bulkActions);
                bulkBuilder.bulkSize(DEFAULT_BULK_SIZE);
                bulkBuilder.flushInterval(XContentMapValues.nodeTimeValue(indexSettings.get(BULK_TIMEOUT_FIELD), (TimeValue)DEFAULT_FLUSH_INTERVAL));
                bulkBuilder.concurrentRequests(XContentMapValues.nodeIntegerValue(indexSettings.get(CONCURRENT_BULK_REQUESTS_FIELD), (int)EsExecutors.boundedNumberOfProcessors((Settings)ImmutableSettings.EMPTY)));
                builder.throttleSize(XContentMapValues.nodeIntegerValue(indexSettings.get(THROTTLE_SIZE_FIELD), (int)(bulkActions * 5)));
            }
            builder.bulk(bulkBuilder.build());
        } else {
            builder.indexName(builder.mongoDb);
            builder.typeName(builder.mongoDb);
            builder.bulk(new Bulk.Builder().build());
        }
        return builder.build();
    }

    private static SocketFactory getSSLSocketFactory() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return sslSocketFactory;
        }
        catch (Exception ex) {
            logger.warn("Unable to build ssl socket factory without certificate validation, using default instead.", (Throwable)ex, new Object[0]);
            return SSLSocketFactory.getDefault();
        }
    }

    static BasicDBObject convertToBasicDBObject(String object) {
        if (object == null || object.length() == 0) {
            return new BasicDBObject();
        }
        return (BasicDBObject)JSON.parse((String)object);
    }

    static String removePrefix(String prefix, String object) {
        return MongoDBRiverDefinition.addRemovePrefix(prefix, object, false);
    }

    static String addPrefix(String prefix, String object) {
        return MongoDBRiverDefinition.addRemovePrefix(prefix, object, true);
    }

    static String addRemovePrefix(String prefix, String object, boolean add) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix");
        }
        if (object == null) {
            throw new NullPointerException("object");
        }
        if (object.length() == 0) {
            return "";
        }
        DBObject bsonObject = (DBObject)JSON.parse((String)object);
        BasicBSONObject newObject = new BasicBSONObject();
        for (String key : bsonObject.keySet()) {
            if (add) {
                newObject.put(String.valueOf(prefix) + key, bsonObject.get(key));
                continue;
            }
            if (key.startsWith(prefix)) {
                newObject.put(key.substring(prefix.length()), bsonObject.get(key));
                continue;
            }
            newObject.put(key, bsonObject.get(key));
        }
        return newObject.toString();
    }

    private MongoDBRiverDefinition(Builder builder) {
        this.riverName = builder.riverName;
        this.riverIndexName = builder.riverIndexName;
        this.mongoServers.addAll(builder.mongoServers);
        this.mongoDb = builder.mongoDb;
        this.mongoCollection = builder.mongoCollection;
        this.mongoGridFS = builder.mongoGridFS;
        this.mongoOplogFilter = builder.mongoOplogFilter;
        this.mongoCollectionFilter = builder.mongoCollectionFilter;
        this.mongoAdminUser = builder.mongoAdminUser;
        this.mongoAdminPassword = builder.mongoAdminPassword;
        this.mongoAdminAuthDatabase = builder.mongoAdminAuthDatabase;
        this.mongoLocalUser = builder.mongoLocalUser;
        this.mongoLocalPassword = builder.mongoLocalPassword;
        this.mongoLocalAuthDatabase = builder.mongoLocalAuthDatabase;
        this.mongoClientOptions = builder.mongoClientOptions;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.mongoSecondaryReadPreference = builder.mongoSecondaryReadPreference;
        this.mongoUseSSL = builder.mongoUseSSL;
        this.mongoSSLVerifyCertificate = builder.mongoSSLVerifyCertificate;
        this.dropCollection = builder.dropCollection;
        this.isMongos = builder.isMongos;
        this.excludeFields = builder.excludeFields;
        this.includeFields = builder.includeFields;
        this.includeCollection = builder.includeCollection;
        this.initialTimestamp = builder.initialTimestamp;
        this.script = builder.script;
        this.scriptType = builder.scriptType;
        this.advancedTransformation = builder.advancedTransformation;
        this.skipInitialImport = builder.skipInitialImport;
        this.parentTypes = builder.parentTypes;
        this.storeStatistics = builder.storeStatistics;
        this.statisticsIndexName = builder.statisticsIndexName;
        this.statisticsTypeName = builder.statisticsTypeName;
        this.importAllCollections = builder.importAllCollections;
        this.disableIndexRefresh = builder.disableIndexRefresh;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.throttleSize = builder.throttleSize;
        this.bulk = builder.bulk;
    }

    public List<ServerAddress> getMongoServers() {
        return this.mongoServers;
    }

    public String getRiverName() {
        return this.riverName;
    }

    public String getRiverIndexName() {
        return this.riverIndexName;
    }

    public String getMongoDb() {
        return this.mongoDb;
    }

    public String getMongoCollection() {
        return this.mongoCollection;
    }

    public boolean isMongoGridFS() {
        return this.mongoGridFS;
    }

    public BasicDBObject getMongoOplogFilter() {
        return this.mongoOplogFilter;
    }

    public BasicDBObject getMongoCollectionFilter() {
        return this.mongoCollectionFilter;
    }

    public String getMongoAdminUser() {
        return this.mongoAdminUser;
    }

    public String getMongoAdminPassword() {
        return this.mongoAdminPassword;
    }

    public String getMongoAdminAuthDatabase() {
        return this.mongoAdminAuthDatabase;
    }

    public String getMongoLocalUser() {
        return this.mongoLocalUser;
    }

    public String getMongoLocalPassword() {
        return this.mongoLocalPassword;
    }

    public String getMongoLocalAuthDatabase() {
        return this.mongoLocalAuthDatabase;
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.mongoClientOptions;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isMongoSecondaryReadPreference() {
        return this.mongoSecondaryReadPreference;
    }

    public boolean isMongoUseSSL() {
        return this.mongoUseSSL;
    }

    public boolean isMongoSSLVerifyCertificate() {
        return this.mongoSSLVerifyCertificate;
    }

    public boolean isDropCollection() {
        return this.dropCollection;
    }

    public Boolean isMongos() {
        return this.isMongos;
    }

    public Set<String> getExcludeFields() {
        return this.excludeFields;
    }

    public Set<String> getIncludeFields() {
        return this.includeFields;
    }

    public String getIncludeCollection() {
        return this.includeCollection;
    }

    public Timestamp<?> getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public boolean isAdvancedTransformation() {
        return this.advancedTransformation;
    }

    public boolean isSkipInitialImport() {
        return this.skipInitialImport;
    }

    public Set<String> getParentTypes() {
        return this.parentTypes;
    }

    public boolean isStoreStatistics() {
        return this.storeStatistics;
    }

    public String getStatisticsIndexName() {
        return this.statisticsIndexName;
    }

    public String getStatisticsTypeName() {
        return this.statisticsTypeName;
    }

    public boolean isImportAllCollections() {
        return this.importAllCollections;
    }

    public boolean isDisableIndexRefresh() {
        return this.disableIndexRefresh;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getThrottleSize() {
        return this.throttleSize;
    }

    public String getMongoOplogNamespace() {
        return String.valueOf(this.getMongoDb()) + "." + this.getMongoCollection();
    }

    public Bulk getBulk() {
        return this.bulk;
    }

    /* synthetic */ MongoDBRiverDefinition(Builder builder, MongoDBRiverDefinition mongoDBRiverDefinition) {
        this(builder);
    }

    public static class Builder {
        private String riverName;
        private String riverIndexName;
        private List<ServerAddress> mongoServers = new ArrayList<ServerAddress>();
        private String mongoDb;
        private String mongoCollection;
        private boolean mongoGridFS;
        private BasicDBObject mongoOplogFilter;
        private BasicDBObject mongoCollectionFilter = new BasicDBObject();
        private String mongoAdminUser = "";
        private String mongoAdminPassword = "";
        private String mongoAdminAuthDatabase = "";
        private String mongoLocalUser = "";
        private String mongoLocalPassword = "";
        private String mongoLocalAuthDatabase = "";
        private MongoClientOptions mongoClientOptions = null;
        private int connectTimeout = 0;
        private int socketTimeout = 0;
        private boolean mongoSecondaryReadPreference = false;
        private boolean mongoUseSSL = false;
        private boolean mongoSSLVerifyCertificate = false;
        private boolean dropCollection = false;
        private Boolean isMongos = null;
        private Set<String> excludeFields = null;
        private Set<String> includeFields = null;
        private String includeCollection = "";
        private Timestamp<?> initialTimestamp = null;
        private String script = null;
        private String scriptType = null;
        private boolean advancedTransformation = false;
        private boolean skipInitialImport;
        private Set<String> parentTypes = null;
        private boolean storeStatistics;
        private String statisticsIndexName;
        private String statisticsTypeName;
        private boolean importAllCollections;
        private boolean disableIndexRefresh;
        private String indexName;
        private String typeName;
        private int throttleSize;
        private Bulk bulk;
        private int connectionsPerHost;
        private int threadsAllowedToBlockForConnectionMultiplier;

        public Builder mongoServers(List<ServerAddress> mongoServers) {
            this.mongoServers = mongoServers;
            return this;
        }

        public Builder riverName(String riverName) {
            this.riverName = riverName;
            return this;
        }

        public Builder riverIndexName(String riverIndexName) {
            this.riverIndexName = riverIndexName;
            return this;
        }

        public Builder mongoDb(String mongoDb) {
            this.mongoDb = mongoDb;
            return this;
        }

        public Builder mongoCollection(String mongoCollection) {
            this.mongoCollection = mongoCollection;
            return this;
        }

        public Builder mongoGridFS(boolean mongoGridFS) {
            this.mongoGridFS = mongoGridFS;
            return this;
        }

        public Builder mongoOplogFilter(BasicDBObject mongoOplogFilter) {
            this.mongoOplogFilter = mongoOplogFilter;
            return this;
        }

        public Builder mongoCollectionFilter(BasicDBObject mongoCollectionFilter) {
            this.mongoCollectionFilter = mongoCollectionFilter;
            return this;
        }

        public Builder mongoAdminUser(String mongoAdminUser) {
            this.mongoAdminUser = mongoAdminUser;
            return this;
        }

        public Builder mongoAdminPassword(String mongoAdminPassword) {
            this.mongoAdminPassword = mongoAdminPassword;
            return this;
        }

        public Builder mongoAdminAuthDatabase(String mongoAdminAuthDatabase) {
            this.mongoAdminAuthDatabase = mongoAdminAuthDatabase;
            return this;
        }

        public Builder mongoLocalUser(String mongoLocalUser) {
            this.mongoLocalUser = mongoLocalUser;
            return this;
        }

        public Builder mongoLocalPassword(String mongoLocalPassword) {
            this.mongoLocalPassword = mongoLocalPassword;
            return this;
        }

        public Builder mongoLocalAuthDatabase(String mongoLocalAuthDatabase) {
            this.mongoLocalAuthDatabase = mongoLocalAuthDatabase;
            return this;
        }

        public Builder mongoClientOptions(MongoClientOptions mongoClientOptions) {
            this.mongoClientOptions = mongoClientOptions;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder mongoSecondaryReadPreference(boolean mongoSecondaryReadPreference) {
            this.mongoSecondaryReadPreference = mongoSecondaryReadPreference;
            return this;
        }

        public Builder mongoUseSSL(boolean mongoUseSSL) {
            this.mongoUseSSL = mongoUseSSL;
            return this;
        }

        public Builder mongoSSLVerifyCertificate(boolean mongoSSLVerifyCertificate) {
            this.mongoSSLVerifyCertificate = mongoSSLVerifyCertificate;
            return this;
        }

        public Builder dropCollection(boolean dropCollection) {
            this.dropCollection = dropCollection;
            return this;
        }

        public Builder isMongos(Boolean isMongos) {
            this.isMongos = isMongos;
            return this;
        }

        public Builder excludeFields(Set<String> excludeFields) {
            this.excludeFields = excludeFields;
            return this;
        }

        public Builder includeFields(Set<String> includeFields) {
            this.includeFields = includeFields;
            return this;
        }

        public Builder includeCollection(String includeCollection) {
            this.includeCollection = includeCollection;
            return this;
        }

        public Builder disableIndexRefresh(boolean disableIndexRefresh) {
            this.disableIndexRefresh = disableIndexRefresh;
            return this;
        }

        public Builder initialTimestamp(Binary initialTimestamp) {
            this.initialTimestamp = new Timestamp.GTID(initialTimestamp.getData(), null);
            return this;
        }

        public Builder initialTimestamp(BSONTimestamp initialTimestamp) {
            this.initialTimestamp = new Timestamp.BSON(initialTimestamp);
            return this;
        }

        public Builder advancedTransformation(boolean advancedTransformation) {
            this.advancedTransformation = advancedTransformation;
            return this;
        }

        public Builder skipInitialImport(boolean skipInitialImport) {
            this.skipInitialImport = skipInitialImport;
            return this;
        }

        public Builder parentTypes(Set<String> parentTypes) {
            this.parentTypes = parentTypes;
            return this;
        }

        public Builder storeStatistics(boolean storeStatistics) {
            this.storeStatistics = storeStatistics;
            return this;
        }

        public Builder statisticsIndexName(String statisticsIndexName) {
            this.statisticsIndexName = statisticsIndexName;
            return this;
        }

        public Builder statisticsTypeName(String statisticsTypeName) {
            this.statisticsTypeName = statisticsTypeName;
            return this;
        }

        public Builder importAllCollections(boolean importAllCollections) {
            this.importAllCollections = importAllCollections;
            return this;
        }

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder scriptType(String scriptType) {
            this.scriptType = scriptType;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder throttleSize(int throttleSize) {
            this.throttleSize = throttleSize;
            return this;
        }

        public Builder bulk(Bulk bulk) {
            this.bulk = bulk;
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            this.connectionsPerHost = connectionsPerHost;
            return this;
        }

        public Builder threadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
            this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
            return this;
        }

        public MongoDBRiverDefinition build() {
            return new MongoDBRiverDefinition(this, null);
        }
    }

    static class Bulk {
        private final int concurrentRequests;
        private final int bulkActions;
        private final ByteSizeValue bulkSize;
        private final TimeValue flushInterval;

        public Bulk(Builder builder) {
            this.bulkActions = builder.bulkActions;
            this.bulkSize = builder.bulkSize;
            this.concurrentRequests = builder.concurrentRequests;
            this.flushInterval = builder.flushInterval;
        }

        public int getConcurrentRequests() {
            return this.concurrentRequests;
        }

        public int getBulkActions() {
            return this.bulkActions;
        }

        public ByteSizeValue getBulkSize() {
            return this.bulkSize;
        }

        public TimeValue getFlushInterval() {
            return this.flushInterval;
        }

        static class Builder {
            private int concurrentRequests = DEFAULT_CONCURRENT_REQUESTS;
            private int bulkActions = 1000;
            private ByteSizeValue bulkSize = DEFAULT_BULK_SIZE;
            private TimeValue flushInterval = DEFAULT_FLUSH_INTERVAL;

            Builder() {
            }

            public Builder concurrentRequests(int concurrentRequests) {
                this.concurrentRequests = concurrentRequests;
                return this;
            }

            public Builder bulkActions(int bulkActions) {
                this.bulkActions = bulkActions;
                return this;
            }

            public Builder bulkSize(ByteSizeValue bulkSize) {
                this.bulkSize = bulkSize;
                return this;
            }

            public Builder flushInterval(TimeValue flushInterval) {
                this.flushInterval = flushInterval;
                return this;
            }

            public Bulk build() {
                return new Bulk(this);
            }
        }
    }
}

