/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.river.mongodb.MongoDBRiver;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;
import org.elasticsearch.river.mongodb.Status;
import org.elasticsearch.river.mongodb.util.MongoDBRiverHelper;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class MongoDBRiverBulkProcessor {
    public static final long DEFAULT_BULK_QUEUE_SIZE = 50L;
    public static final Map<String, Boolean> DROP_INDEX = ImmutableMap.of((Object)"dropIndex", (Object)Boolean.TRUE);
    private final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());
    private final MongoDBRiver river;
    private final MongoDBRiverDefinition definition;
    private final Client client;
    private final BulkProcessor bulkProcessor;
    private final String index;
    private final String type;
    private final AtomicBoolean flushBulkProcessor = new AtomicBoolean();
    private final AtomicInteger deletedDocuments = new AtomicInteger();
    private final AtomicInteger insertedDocuments = new AtomicInteger();
    private final AtomicInteger updatedDocuments = new AtomicInteger();
    private final AtomicLong documentCount = new AtomicLong();
    private static final Semaphore semaphore = new Semaphore(1);
    private final long bulkQueueSize;
    private final BulkProcessor.Listener listener = new BulkProcessor.Listener(){

        public void beforeBulk(long executionId, BulkRequest request) {
            MongoDBRiverBulkProcessor.this.checkBulkProcessorAvailability();
            MongoDBRiverBulkProcessor.this.logger.trace("beforeBulk - new bulk [{}] of items [{}]", new Object[]{executionId, request.numberOfActions()});
            if (MongoDBRiverBulkProcessor.this.flushBulkProcessor.get()) {
                MongoDBRiverBulkProcessor.this.logger.trace("About to flush bulk request index[{}] - type[{}]", new Object[]{MongoDBRiverBulkProcessor.this.index, MongoDBRiverBulkProcessor.this.type});
                int dropDollectionIndex = this.findLastDropCollection(request.requests());
                request.requests().subList(0, dropDollectionIndex + 1).clear();
                try {
                    MongoDBRiverBulkProcessor.this.dropRecreateMapping();
                    MongoDBRiverBulkProcessor.this.deletedDocuments.set(0);
                    MongoDBRiverBulkProcessor.this.updatedDocuments.set(0);
                    MongoDBRiverBulkProcessor.this.insertedDocuments.set(0);
                    MongoDBRiverBulkProcessor.this.flushBulkProcessor.set(false);
                }
                catch (Throwable t) {
                    MongoDBRiverBulkProcessor.this.logger.error("Drop collection operation failed", t, new Object[0]);
                    MongoDBRiverHelper.setRiverStatus(MongoDBRiverBulkProcessor.this.client, MongoDBRiverBulkProcessor.this.definition.getRiverName(), Status.IMPORT_FAILED);
                    request.requests().clear();
                    MongoDBRiverBulkProcessor.this.bulkProcessor.close();
                    MongoDBRiverBulkProcessor.this.river.close();
                }
            }
        }

        private int findLastDropCollection(List<ActionRequest> request) {
            int index = 0;
            int i = 0;
            while (i < request.size()) {
                Map source;
                ActionRequest action = request.get(i);
                if (action instanceof IndexRequest && (source = ((IndexRequest)action).sourceAsMap()).equals(DROP_INDEX)) {
                    index = i;
                }
                ++i;
            }
            return index;
        }

        public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            if (failure.getClass().equals(ActionRequestValidationException.class)) {
                if (MongoDBRiverBulkProcessor.this.logger.isTraceEnabled()) {
                    MongoDBRiverBulkProcessor.this.logger.trace("Ignore ActionRequestValidationException : {}", failure, new Object[0]);
                }
            } else {
                MongoDBRiverBulkProcessor.this.logger.error("afterBulk - Bulk request failed: {} - {} - {}", new Object[]{executionId, request, failure});
                MongoDBRiverHelper.setRiverStatus(MongoDBRiverBulkProcessor.this.client, MongoDBRiverBulkProcessor.this.definition.getRiverName(), Status.IMPORT_FAILED);
                request.requests().clear();
                MongoDBRiverBulkProcessor.this.bulkProcessor.close();
                MongoDBRiverBulkProcessor.this.river.close();
            }
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            if (response.hasFailures()) {
                MongoDBRiverBulkProcessor.this.logger.error("Bulk processor failed. {}", new Object[]{response.buildFailureMessage()});
                MongoDBRiverHelper.setRiverStatus(MongoDBRiverBulkProcessor.this.client, MongoDBRiverBulkProcessor.this.definition.getRiverName(), Status.IMPORT_FAILED);
                request.requests().clear();
                MongoDBRiverBulkProcessor.this.bulkProcessor.close();
                MongoDBRiverBulkProcessor.this.river.close();
            } else {
                MongoDBRiverBulkProcessor.this.documentCount.addAndGet(response.getItems().length);
                MongoDBRiverBulkProcessor.this.logStatistics(response.getTookInMillis());
                MongoDBRiverBulkProcessor.this.deletedDocuments.set(0);
                MongoDBRiverBulkProcessor.this.updatedDocuments.set(0);
                MongoDBRiverBulkProcessor.this.insertedDocuments.set(0);
                if (MongoDBRiverBulkProcessor.this.logger.isTraceEnabled()) {
                    MongoDBRiverBulkProcessor.this.logger.trace("afterBulk - bulk [{}] success [{} items] [{} ms] total [{}]", new Object[]{executionId, response.getItems().length, response.getTookInMillis(), MongoDBRiverBulkProcessor.this.documentCount.get()});
                }
            }
        }
    };

    MongoDBRiverBulkProcessor(MongoDBRiver river, MongoDBRiverDefinition definition, Client client, String index, String type) {
        this.river = river;
        this.bulkProcessor = BulkProcessor.builder((Client)client, (BulkProcessor.Listener)this.listener).setBulkActions(definition.getBulk().getBulkActions()).setConcurrentRequests(definition.getBulk().getConcurrentRequests()).setFlushInterval(definition.getBulk().getFlushInterval()).setBulkSize(definition.getBulk().getBulkSize()).build();
        this.definition = definition;
        this.client = client;
        this.index = index;
        this.type = type;
        this.bulkQueueSize = this.getBulkQueueSize();
    }

    public void dropIndex() {
        this.addBulkRequest(null, DROP_INDEX, null, null);
        this.flushBulkProcessor.set(true);
    }

    public void addBulkRequest(String id, Map<?, ?> source, String routing, String parent) {
        this.bulkProcessor.add(Requests.indexRequest((String)this.index).type(this.type).id(id).source(source).routing(routing).parent(parent));
        this.insertedDocuments.incrementAndGet();
    }

    public void addBulkRequest(String id, XContentBuilder source, String routing, String parent) {
        this.bulkProcessor.add(Requests.indexRequest((String)this.index).type(this.type).id(id).source(source).routing(routing).parent(parent));
        this.insertedDocuments.incrementAndGet();
    }

    public void deleteBulkRequest(String id, String routing, String parent) {
        this.logger.trace("deleteBulkRequest - id: {} - index: {} - type: {} - routing: {} - parent: {}", new Object[]{id, this.index, this.type, routing, parent});
        this.bulkProcessor.add(Requests.deleteRequest((String)this.index).type(this.type).id(id).routing(routing).parent(parent));
        this.deletedDocuments.incrementAndGet();
    }

    public BulkProcessor getBulkProcessor() {
        return this.bulkProcessor;
    }

    private void checkBulkProcessorAvailability() {
        while (!this.isBulkProcessorAvailable()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waiting for bulk queue to empty...", new Object[0]);
                }
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.warn("checkIndexStatistics interrupted", (Throwable)e, new Object[0]);
            }
        }
    }

    private long getBulkQueueSize() {
        NodesInfoResponse response = (NodesInfoResponse)this.client.admin().cluster().prepareNodesInfo(new String[0]).setThreadPool(true).get();
        NodeInfo[] nodeInfoArray = (NodeInfo[])response.getNodes();
        int n = nodeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeInfo node = nodeInfoArray[n2];
            for (ThreadPool.Info info : node.getThreadPool()) {
                if (!"bulk".equals(info.getName())) continue;
                return info.getQueueSize().getSingles();
            }
            ++n2;
        }
        return 50L;
    }

    private boolean isBulkProcessorAvailable() {
        NodesStatsResponse response = (NodesStatsResponse)this.client.admin().cluster().prepareNodesStats(new String[0]).setThreadPool(true).get();
        NodeStats[] nodeStatsArray = (NodeStats[])response.getNodes();
        int n = nodeStatsArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeStats nodeStats = nodeStatsArray[n2];
            for (ThreadPoolStats.Stats stats : nodeStats.getThreadPool()) {
                if (!"bulk".equals(stats.getName())) continue;
                int queue = stats.getQueue();
                this.logger.trace("bulkQueueSize [{}] - queue [{}] - availability [{}]", new Object[]{this.bulkQueueSize, queue, 1L - (long)queue / this.bulkQueueSize});
                return (double)(1L - (long)queue / this.bulkQueueSize) > 0.1;
            }
            ++n2;
        }
        return true;
    }

    private void dropRecreateMapping() throws IOException, InterruptedException {
        try {
            semaphore.acquire();
            this.logger.trace("dropRecreateMapping index[{}] - type[{}]", new Object[]{this.index, this.type});
            this.client.admin().indices().prepareRefresh(new String[]{this.index}).get();
            ImmutableOpenMap mappings = ((ClusterStateResponse)this.client.admin().cluster().prepareState().get()).getState().getMetaData().index(this.index).mappings();
            this.logger.trace("mappings contains type {}: {}", new Object[]{this.type, mappings.containsKey((Object)this.type)});
            if (mappings.containsKey((Object)this.type)) {
                MappingMetaData mapping = (MappingMetaData)mappings.get((Object)this.type);
                if (((DeleteMappingResponse)this.client.admin().indices().prepareDeleteMapping(new String[]{this.index}).setType(new String[]{this.type}).get()).isAcknowledged()) {
                    PutMappingResponse pmr = (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{this.index}).setType(this.type).setSource(mapping.getSourceAsMap()).get();
                    if (!pmr.isAcknowledged()) {
                        this.logger.error("Failed to put mapping {} / {} / {}.", new Object[]{this.index, this.type, mapping.source()});
                    } else {
                        this.logger.info("Delete and recreate for index / type [{}] [{}] successfully executed.", new Object[]{this.index, this.type});
                    }
                } else {
                    this.logger.warn("Delete type[{}] on index[{}] return aknowledge false", new Object[]{this.type, this.index});
                }
            } else {
                this.logger.info("type[{}] does not exist in index[{}]. No need to remove mapping.", new Object[]{this.index, this.type});
            }
        }
        finally {
            semaphore.release();
        }
    }

    private void logStatistics(long duration) {
        if (this.definition.isStoreStatistics()) {
            long totalDocuments = this.deletedDocuments.get() + this.insertedDocuments.get();
            this.logger.trace("Indexed {} documents: {} insertions, {} updates, {} deletions", new Object[]{totalDocuments, this.insertedDocuments.get(), this.updatedDocuments.get(), this.deletedDocuments.get()});
            HashMap<String, HashMap> source = new HashMap<String, HashMap>();
            HashMap statistics = Maps.newHashMap();
            statistics.put("duration", duration);
            statistics.put("date", new Date());
            statistics.put("index", this.index);
            statistics.put("type", this.type);
            statistics.put("documents.inserted", this.insertedDocuments.get());
            statistics.put("documents.updated", this.updatedDocuments.get());
            statistics.put("documents.deleted", this.deletedDocuments.get());
            statistics.put("documents.total", this.documentCount.get());
            source.put("statistics", statistics);
            this.client.prepareIndex(this.definition.getStatisticsIndexName(), this.definition.getStatisticsTypeName()).setSource(source).get();
        }
    }

    public static class Builder {
        private final MongoDBRiver river;
        private final MongoDBRiverDefinition definition;
        private final Client client;
        private String index;
        private String type;

        public Builder(MongoDBRiver river, MongoDBRiverDefinition definition, Client client, String index, String type) {
            this.river = river;
            this.definition = definition;
            this.client = client;
            this.index = index;
            this.type = type;
        }

        public MongoDBRiverBulkProcessor build() {
            return new MongoDBRiverBulkProcessor(this.river, this.definition, this.client, this.index, this.type);
        }
    }
}

