/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.river.AbstractRiverComponent;
import org.elasticsearch.river.River;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.RiverSettings;
import org.elasticsearch.river.mongodb.CollectionSlurper;
import org.elasticsearch.river.mongodb.Indexer;
import org.elasticsearch.river.mongodb.MongoClientService;
import org.elasticsearch.river.mongodb.MongoConfig;
import org.elasticsearch.river.mongodb.MongoConfigProvider;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;
import org.elasticsearch.river.mongodb.Operation;
import org.elasticsearch.river.mongodb.OplogSlurper;
import org.elasticsearch.river.mongodb.SharedContext;
import org.elasticsearch.river.mongodb.Status;
import org.elasticsearch.river.mongodb.StatusChecker;
import org.elasticsearch.river.mongodb.Timestamp;
import org.elasticsearch.river.mongodb.util.MongoDBHelper;
import org.elasticsearch.river.mongodb.util.MongoDBRiverHelper;
import org.elasticsearch.script.ScriptService;

public class MongoDBRiver
extends AbstractRiverComponent
implements River {
    public static final String TYPE = "mongodb";
    public static final String NAME = "mongodb-river";
    public static final String STATUS_ID = "_riverstatus";
    public static final String STATUS_FIELD = "status";
    public static final String DESCRIPTION = "MongoDB River Plugin";
    public static final String LAST_TIMESTAMP_FIELD = "_last_ts";
    public static final String LAST_GTID_FIELD = "_last_gtid";
    public static final String MONGODB_LOCAL_DATABASE = "local";
    public static final String MONGODB_ADMIN_DATABASE = "admin";
    public static final String MONGODB_CONFIG_DATABASE = "config";
    public static final String MONGODB_ID_FIELD = "_id";
    public static final String MONGODB_OID_FIELD = "oid";
    public static final String MONGODB_SEQ_FIELD = "seq";
    public static final String MONGODB_IN_OPERATOR = "$in";
    public static final String MONGODB_OR_OPERATOR = "$or";
    public static final String MONGODB_AND_OPERATOR = "$and";
    public static final String MONGODB_NATURAL_OPERATOR = "$natural";
    public static final String OPLOG_COLLECTION = "oplog.rs";
    public static final String OPLOG_REFS_COLLECTION = "oplog.refs";
    public static final String OPLOG_NAMESPACE = "ns";
    public static final String OPLOG_NAMESPACE_COMMAND = "$cmd";
    public static final String OPLOG_ADMIN_COMMAND = "admin.$cmd";
    public static final String OPLOG_OBJECT = "o";
    public static final String OPLOG_UPDATE = "o2";
    public static final String OPLOG_OPERATION = "op";
    public static final String OPLOG_UPDATE_OPERATION = "u";
    public static final String OPLOG_UPDATE_ROW_OPERATION = "ur";
    public static final String OPLOG_INSERT_OPERATION = "i";
    public static final String OPLOG_DELETE_OPERATION = "d";
    public static final String OPLOG_COMMAND_OPERATION = "c";
    public static final String OPLOG_NOOP_OPERATION = "n";
    public static final String OPLOG_DROP_COMMAND_OPERATION = "drop";
    public static final String OPLOG_DROP_DATABASE_COMMAND_OPERATION = "dropDatabase";
    public static final String OPLOG_RENAME_COLLECTION_COMMAND_OPERATION = "renameCollection";
    public static final String OPLOG_TO = "to";
    public static final String OPLOG_TIMESTAMP = "ts";
    public static final String OPLOG_FROM_MIGRATE = "fromMigrate";
    public static final String OPLOG_OPS = "ops";
    public static final String OPLOG_CREATE_COMMAND = "create";
    public static final String OPLOG_REF = "ref";
    public static final String GRIDFS_FILES_SUFFIX = ".files";
    public static final String GRIDFS_CHUNKS_SUFFIX = ".chunks";
    public static final String INSERTION_ORDER_KEY = "$natural";
    static final int MONGODB_RETRY_ERROR_DELAY_MS = 10000;
    static final ESLogger logger = ESLoggerFactory.getLogger((String)MongoDBRiver.class.getName());
    protected final MongoDBRiverDefinition definition;
    protected final Client esClient;
    protected final ScriptService scriptService;
    protected final SharedContext context;
    protected volatile List<Thread> tailerThreads = Lists.newArrayList();
    protected volatile Thread indexerThread;
    protected volatile Thread statusThread;
    private final MongoClientService mongoClientService;

    @Inject
    public MongoDBRiver(RiverName riverName, RiverSettings settings, @RiverIndexName String riverIndexName, Client esClient, ScriptService scriptService, MongoClientService mongoClientService) {
        super(riverName, settings);
        if (logger.isTraceEnabled()) {
            logger.trace("Initializing river : [{}]", new Object[]{riverName.getName()});
        }
        this.esClient = esClient;
        this.scriptService = scriptService;
        this.mongoClientService = mongoClientService;
        this.definition = MongoDBRiverDefinition.parseSettings(riverName.name(), riverIndexName, settings, scriptService);
        LinkedTransferQueue<QueueEntry> stream = this.definition.getThrottleSize() == -1 ? new LinkedTransferQueue() : new ArrayBlockingQueue(this.definition.getThrottleSize());
        this.context = new SharedContext(stream, Status.STOPPED);
    }

    public void start() {
        try {
            MongoConfig config;
            block24: {
                logger.info("Starting river {}", new Object[]{this.riverName.getName()});
                Status status = MongoDBRiverHelper.getRiverStatus(this.esClient, this.riverName.getName());
                if (status == Status.IMPORT_FAILED || status == Status.INITIAL_IMPORT_FAILED || status == Status.SCRIPT_IMPORT_FAILED || status == Status.START_FAILED) {
                    logger.error("Cannot start river {}. Current status is {}", new Object[]{this.riverName.getName(), status});
                    return;
                }
                if (status == Status.STOPPED) {
                    logger.info("Cannot start river {}. It is currently disabled", new Object[]{this.riverName.getName()});
                    return;
                }
                logger.info("{} - {}", new Object[]{DESCRIPTION, MongoDBHelper.getRiverVersion()});
                logger.info("starting mongodb stream. options: secondaryreadpreference [{}], drop_collection [{}], include_collection [{}], throttlesize [{}], gridfs [{}], filter [{}], db [{}], collection [{}], script [{}], indexing to [{}]/[{}]", new Object[]{this.definition.isMongoSecondaryReadPreference(), this.definition.isDropCollection(), this.definition.getIncludeCollection(), this.definition.getThrottleSize(), this.definition.isMongoGridFS(), this.definition.getMongoOplogFilter(), this.definition.getMongoDb(), this.definition.getMongoCollection(), this.definition.getScript(), this.definition.getIndexName(), this.definition.getTypeName()});
                MongoDBRiverHelper.setRiverStatus(this.esClient, this.riverName.getName(), Status.RUNNING);
                this.context.setStatus(Status.RUNNING);
                for (ServerAddress server : this.definition.getMongoServers()) {
                    logger.debug("Using mongodb server(s): host [{}], port [{}]", new Object[]{server.getHost(), server.getPort()});
                }
                this.statusThread = EsExecutors.daemonThreadFactory((Settings)this.settings.globalSettings(), (String)("mongodb_river_status:" + this.definition.getIndexName())).newThread(new StatusChecker(this, this.definition, this.context));
                this.statusThread.start();
                try {
                    if (!((IndicesExistsResponse)this.esClient.admin().indices().prepareExists(new String[]{this.definition.getIndexName()}).get()).isExists()) {
                        this.esClient.admin().indices().prepareCreate(this.definition.getIndexName()).get();
                    }
                }
                catch (Exception e) {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexAlreadyExistsException || ExceptionsHelper.unwrapCause((Throwable)e) instanceof ClusterBlockException) break block24;
                    logger.error("failed to create index [{}], disabling river...", (Throwable)e, new Object[]{this.definition.getIndexName()});
                    return;
                }
            }
            if (this.definition.isMongoGridFS()) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Set explicit attachment mapping.", new Object[0]);
                    }
                    this.esClient.admin().indices().preparePutMapping(new String[]{this.definition.getIndexName()}).setType(this.definition.getTypeName()).setSource(this.getGridFSMapping()).get();
                }
                catch (Exception e) {
                    logger.warn("Failed to set explicit mapping (attachment): {}", (Throwable)e, new Object[0]);
                }
            }
            MongoClient mongoClusterClient = this.mongoClientService.getMongoClusterClient(this.definition);
            MongoConfigProvider configProvider = new MongoConfigProvider(this.mongoClientService, this.definition);
            while (true) {
                try {
                    config = configProvider.call();
                }
                catch (MongoSocketException | MongoTimeoutException throwable) {
                    Thread.sleep(10000L);
                    continue;
                }
                break;
            }
            Timestamp<?> startTimestamp = null;
            if (this.definition.getInitialTimestamp() != null) {
                startTimestamp = this.definition.getInitialTimestamp();
            } else if (this.getLastProcessedTimestamp() != null) {
                startTimestamp = this.getLastProcessedTimestamp();
            } else {
                for (MongoConfig.Shard shard : config.getShards()) {
                    if (startTimestamp != null && shard.getLatestOplogTimestamp().compareTo(startTimestamp) >= 1) continue;
                    startTimestamp = shard.getLatestOplogTimestamp();
                }
            }
            this.indexerThread = EsExecutors.daemonThreadFactory((Settings)this.settings.globalSettings(), (String)("mongodb_river_indexer:" + this.definition.getIndexName())).newThread(new Indexer(this, this.definition, this.context, this.esClient, this.scriptService));
            this.indexerThread.start();
            CollectionSlurper importer = new CollectionSlurper(startTimestamp, mongoClusterClient, this.definition, this.context, this.esClient);
            importer.run();
            if (config.isMongos()) {
                for (MongoConfig.Shard shard : config.getShards()) {
                    MongoClient mongoClient = this.mongoClientService.getMongoShardClient(this.definition, shard.getReplicas());
                    Thread tailerThread = EsExecutors.daemonThreadFactory((Settings)this.settings.globalSettings(), (String)("mongodb_river_slurper_" + shard.getName() + ":" + this.definition.getIndexName())).newThread(new OplogSlurper(shard.getLatestOplogTimestamp(), mongoClusterClient, mongoClient, this.definition, this.context, this.esClient));
                    this.tailerThreads.add(tailerThread);
                }
            } else {
                MongoConfig.Shard shard;
                shard = config.getShards().get(0);
                Thread tailerThread = EsExecutors.daemonThreadFactory((Settings)this.settings.globalSettings(), (String)("mongodb_river_slurper_" + shard.getName() + ":" + this.definition.getIndexName())).newThread(new OplogSlurper(shard.getLatestOplogTimestamp(), mongoClusterClient, mongoClusterClient, this.definition, this.context, this.esClient));
                this.tailerThreads.add(tailerThread);
            }
            for (Thread thread : this.tailerThreads) {
                thread.start();
            }
        }
        catch (Throwable t) {
            logger.warn("Fail to start river {}", t, new Object[]{this.riverName.getName()});
            MongoDBRiverHelper.setRiverStatus(this.esClient, this.definition.getRiverName(), Status.START_FAILED);
            this.context.setStatus(Status.START_FAILED);
        }
    }

    public void close() {
        logger.info("Closing river {}", new Object[]{this.riverName.getName()});
        try {
            try {
                if (this.statusThread != null) {
                    this.statusThread.interrupt();
                    this.statusThread = null;
                }
                for (Thread thread : this.tailerThreads) {
                    thread.interrupt();
                    thread = null;
                }
                this.tailerThreads.clear();
                if (this.indexerThread != null) {
                    this.indexerThread.interrupt();
                    this.indexerThread = null;
                }
            }
            catch (Throwable t) {
                logger.error("Fail to close river {}", t, new Object[]{this.riverName.getName()});
                this.context.setStatus(Status.STOPPED);
            }
        }
        finally {
            this.context.setStatus(Status.STOPPED);
        }
    }

    protected Timestamp<?> getLastProcessedTimestamp() {
        return MongoDBRiver.getLastTimestamp(this.esClient, this.definition);
    }

    private XContentBuilder getGridFSMapping() throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(this.definition.getTypeName()).startObject("properties").startObject("content").field("type", "attachment").endObject().startObject("filename").field("type", "string").endObject().startObject("contentType").field("type", "string").endObject().startObject("md5").field("type", "string").endObject().startObject("length").field("type", "long").endObject().startObject("chunkSize").field("type", "long").endObject().endObject().endObject().endObject();
        logger.info("GridFS Mapping: {}", new Object[]{mapping.string()});
        return mapping;
    }

    public static Timestamp<?> getLastTimestamp(Client client, MongoDBRiverDefinition definition) {
        client.admin().indices().prepareRefresh(new String[]{definition.getRiverIndexName()}).get();
        GetResponse lastTimestampResponse = (GetResponse)client.prepareGet(definition.getRiverIndexName(), definition.getRiverName(), definition.getMongoOplogNamespace()).get();
        if (lastTimestampResponse.isExists()) {
            Timestamp<?> lastTimestamp;
            Map mongodbState = (Map)lastTimestampResponse.getSourceAsMap().get(TYPE);
            if (mongodbState != null && (lastTimestamp = Timestamp.on(mongodbState)) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{} last timestamp: {}", new Object[]{definition.getMongoOplogNamespace(), lastTimestamp});
                }
                return lastTimestamp;
            }
        } else if (definition.getInitialTimestamp() != null) {
            return definition.getInitialTimestamp();
        }
        return null;
    }

    static void setLastTimestamp(MongoDBRiverDefinition definition, Timestamp<?> time, BulkProcessor bulkProcessor) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("setLastTimestamp [{}] [{}] [{}]", new Object[]{definition.getRiverName(), definition.getMongoOplogNamespace(), time});
            }
            bulkProcessor.add(Requests.indexRequest((String)definition.getRiverIndexName()).type(definition.getRiverName()).id(definition.getMongoOplogNamespace()).source(MongoDBRiver.source(time)));
        }
        catch (IOException iOException) {
            logger.error("error updating last timestamp for namespace {}", new Object[]{definition.getMongoOplogNamespace()});
        }
    }

    private static XContentBuilder source(Timestamp<?> time) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject(TYPE);
        time.saveFields(builder);
        return builder.endObject().endObject();
    }

    public static long getIndexCount(Client client, MongoDBRiverDefinition definition) {
        if (((IndicesExistsResponse)client.admin().indices().prepareExists(new String[]{definition.getIndexName()}).get()).isExists()) {
            if (definition.isImportAllCollections()) {
                return ((CountResponse)client.prepareCount(new String[]{definition.getIndexName()}).execute().actionGet()).getCount();
            }
            if (((TypesExistsResponse)client.admin().indices().prepareTypesExists(new String[]{definition.getIndexName()}).setTypes(new String[]{definition.getTypeName()}).get()).isExists()) {
                return ((CountResponse)client.prepareCount(new String[]{definition.getIndexName()}).setTypes(new String[]{definition.getTypeName()}).get()).getCount();
            }
        }
        return 0L;
    }

    protected static class QueueEntry {
        private final DBObject data;
        private final Operation operation;
        private final Timestamp<?> oplogTimestamp;
        private final String collection;

        public QueueEntry(DBObject data, String collection) {
            this(null, Operation.INSERT, data, collection);
        }

        public QueueEntry(Timestamp<?> oplogTimestamp, Operation oplogOperation, DBObject data, String collection) {
            this.data = data;
            this.operation = oplogOperation;
            this.oplogTimestamp = oplogTimestamp;
            this.collection = collection;
        }

        public boolean isAttachment() {
            return this.data instanceof GridFSDBFile;
        }

        public DBObject getData() {
            return this.data;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public Timestamp<?> getOplogTimestamp() {
            return this.oplogTimestamp;
        }

        public String getCollection() {
            return this.collection;
        }
    }
}

