/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.river.mongodb.MongoClientService;
import org.elasticsearch.river.mongodb.MongoConfig;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;
import org.elasticsearch.river.mongodb.Timestamp;

public class MongoConfigProvider
implements Callable<MongoConfig> {
    private static final ESLogger logger = ESLoggerFactory.getLogger((String)MongoConfigProvider.class.getName());
    private final MongoClientService mongoClientService;
    private final MongoDBRiverDefinition definition;
    private final MongoClient clusterClient;

    public MongoConfigProvider(MongoClientService mongoClientService, MongoDBRiverDefinition definition) {
        this.mongoClientService = mongoClientService;
        this.definition = definition;
        this.clusterClient = mongoClientService.getMongoClusterClient(definition);
    }

    @Override
    public MongoConfig call() {
        this.ensureIsReplicaSet();
        boolean isMongos = this.isMongos();
        List<MongoConfig.Shard> shards = this.getShards(isMongos);
        MongoConfig config = new MongoConfig(isMongos, shards);
        return config;
    }

    protected boolean ensureIsReplicaSet() {
        Set collections = this.clusterClient.getDB("local").getCollectionNames();
        if (!collections.contains("oplog.rs")) {
            throw new IllegalStateException("Cannot find oplog.rs collection. Please check this link: http://docs.mongodb.org/manual/tutorial/deploy-replica-set/");
        }
        return true;
    }

    private DB getAdminDb() {
        DB adminDb = this.clusterClient.getDB("admin");
        if (adminDb == null) {
            throw new ElasticsearchException(String.format("Could not get %s database from MongoDB", "admin"));
        }
        return adminDb;
    }

    private DB getConfigDb() {
        DB configDb = this.clusterClient.getDB("config");
        if (configDb == null) {
            throw new ElasticsearchException(String.format("Could not get %s database from MongoDB", "config"));
        }
        return configDb;
    }

    private boolean isMongos() {
        if (this.definition.isMongos() != null) {
            return this.definition.isMongos();
        }
        DB adminDb = this.getAdminDb();
        if (adminDb == null) {
            return false;
        }
        logger.trace("Found {} database", new Object[]{"admin"});
        DBObject command = BasicDBObjectBuilder.start((Map)ImmutableMap.builder().put((Object)"serverStatus", (Object)1).put((Object)"asserts", (Object)0).put((Object)"backgroundFlushing", (Object)0).put((Object)"connections", (Object)0).put((Object)"cursors", (Object)0).put((Object)"dur", (Object)0).put((Object)"extra_info", (Object)0).put((Object)"globalLock", (Object)0).put((Object)"indexCounters", (Object)0).put((Object)"locks", (Object)0).put((Object)"metrics", (Object)0).put((Object)"network", (Object)0).put((Object)"opcounters", (Object)0).put((Object)"opcountersRepl", (Object)0).put((Object)"recordStats", (Object)0).put((Object)"repl", (Object)0).build()).get();
        logger.trace("About to execute: {}", new Object[]{command});
        CommandResult cr = adminDb.command(command, ReadPreference.primary());
        logger.trace("Command executed return : {}", new Object[]{cr});
        logger.info("MongoDB version - {}", new Object[]{cr.get("version")});
        if (logger.isTraceEnabled()) {
            logger.trace("serverStatus: {}", new Object[]{cr});
        }
        if (!cr.ok()) {
            logger.warn("serverStatus returns error: {}", new Object[]{cr.getErrorMessage()});
            return false;
        }
        if (cr.get("process") == null) {
            logger.warn("serverStatus.process return null.", new Object[0]);
            return false;
        }
        String process = cr.get("process").toString().toLowerCase();
        if (logger.isTraceEnabled()) {
            logger.trace("process: {}", new Object[]{process});
        }
        return process.contains("mongos");
    }

    private List<MongoConfig.Shard> getShards(boolean isMongos) {
        ArrayList<MongoConfig.Shard> shards = new ArrayList<MongoConfig.Shard>();
        if (isMongos) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBCursor cursor = this.getConfigDb().getCollection("shards").find();){
                while (cursor.hasNext()) {
                    DBObject item = cursor.next();
                    List<ServerAddress> shardServers = this.getServerAddressForReplica(item);
                    if (shardServers == null) continue;
                    String shardName = item.get("_id").toString();
                    MongoClient shardClient = this.mongoClientService.getMongoShardClient(this.definition, shardServers);
                    Timestamp<?> latestOplogTimestamp = this.getCurrentOplogTimestamp(shardClient);
                    shards.add(new MongoConfig.Shard(shardName, shardServers, latestOplogTimestamp));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return shards;
        }
        List servers = this.clusterClient.getServerAddressList();
        Timestamp<?> latestOplogTimestamp = this.getCurrentOplogTimestamp(this.clusterClient);
        shards.add(new MongoConfig.Shard("unsharded", servers, latestOplogTimestamp));
        return shards;
    }

    private List<ServerAddress> getServerAddressForReplica(DBObject item) {
        String definition = item.get("host").toString();
        if (definition.contains("/")) {
            definition = definition.substring(definition.indexOf("/") + 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getServerAddressForReplica - definition: {}", new Object[]{definition});
        }
        ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
        String[] stringArray = definition.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            try {
                servers.add(new ServerAddress(server));
            }
            catch (UnknownHostException uhEx) {
                logger.warn("failed to execute bulk", (Throwable)uhEx, new Object[0]);
            }
            ++n2;
        }
        return servers;
    }

    private Timestamp<?> getCurrentOplogTimestamp(MongoClient shardClient) {
        DBCollection oplogCollection = shardClient.getDB("local").getCollection("oplog.rs");
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBCursor cursor = oplogCollection.find().sort((DBObject)new BasicDBObject("$natural", (Object)-1)).limit(1);){
            return Timestamp.on(cursor.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

