/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import com.google.common.base.Strings;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;

@Singleton
public class MongoClientService
extends AbstractLifecycleComponent<MongoClientService> {
    private final Map<ClientCacheKey, MongoClient> mongoClients = new HashMap<ClientCacheKey, MongoClient>();
    private final Object $lock = new Object[0];

    @Inject
    public MongoClientService(Settings settings) {
        super(settings);
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws ElasticsearchException {
        Object object = this.$lock;
        synchronized (object) {
            for (MongoClient mongoClient : this.mongoClients.values()) {
                mongoClient.close();
            }
            this.mongoClients.clear();
        }
    }

    public MongoClient getMongoClusterClient(MongoDBRiverDefinition definition) {
        return this.getMongoShardClient(definition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoClient getMongoShardClient(MongoDBRiverDefinition definition, List<ServerAddress> shardServers) {
        Object object = this.$lock;
        synchronized (object) {
            MongoClientOptions mongoClientOptions;
            ClientCacheKey cacheKey;
            MongoClient mongoClient;
            List<ServerAddress> servers = shardServers != null ? shardServers : definition.getMongoServers();
            ArrayList<MongoCredential> mongoCredentials = new ArrayList<MongoCredential>();
            if (!Strings.isNullOrEmpty((String)definition.getMongoLocalUser()) && !Strings.isNullOrEmpty((String)definition.getMongoLocalPassword())) {
                mongoCredentials.add(MongoCredential.createMongoCRCredential((String)definition.getMongoLocalUser(), (String)(!Strings.isNullOrEmpty((String)definition.getMongoLocalAuthDatabase()) ? definition.getMongoLocalAuthDatabase() : "local"), (char[])definition.getMongoLocalPassword().toCharArray()));
            }
            if (!Strings.isNullOrEmpty((String)definition.getMongoAdminUser()) && !Strings.isNullOrEmpty((String)definition.getMongoAdminPassword())) {
                mongoCredentials.add(MongoCredential.createMongoCRCredential((String)definition.getMongoAdminUser(), (String)(!Strings.isNullOrEmpty((String)definition.getMongoAdminAuthDatabase()) ? definition.getMongoAdminAuthDatabase() : "admin"), (char[])definition.getMongoAdminPassword().toCharArray()));
            }
            if ((mongoClient = this.mongoClients.get(cacheKey = new ClientCacheKey(servers, mongoCredentials, mongoClientOptions = definition.getMongoClientOptions()))) != null) {
                return mongoClient;
            }
            this.logger.info("Creating MongoClient for [{}]", new Object[]{servers});
            mongoClient = new MongoClient(servers, mongoCredentials, mongoClientOptions);
            this.mongoClients.put(cacheKey, mongoClient);
            return mongoClient;
        }
    }

    static class ClientCacheKey {
        private final List<ServerAddress> servers;
        private final List<MongoCredential> mongoCredentials;
        private final MongoClientOptions mongoClientOptions;

        public ClientCacheKey(List<ServerAddress> servers, List<MongoCredential> mongoCredentials, MongoClientOptions mongoClientOptions) {
            this.servers = servers;
            this.mongoCredentials = mongoCredentials;
            this.mongoClientOptions = mongoClientOptions;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.mongoClientOptions == null ? 0 : this.mongoClientOptions.hashCode());
            result = 31 * result + (this.mongoCredentials == null ? 0 : this.mongoCredentials.hashCode());
            result = 31 * result + (this.servers == null ? 0 : this.servers.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientCacheKey other = (ClientCacheKey)obj;
            if (this.mongoClientOptions == null ? other.mongoClientOptions != null : !this.mongoClientOptions.equals((Object)other.mongoClientOptions)) {
                return false;
            }
            if (this.mongoCredentials == null ? other.mongoCredentials != null : !this.mongoCredentials.equals(other.mongoCredentials)) {
                return false;
            }
            return !(this.servers == null ? other.servers != null : !this.servers.equals(other.servers));
        }
    }
}

