/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.types.BasicBSONList;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.HasParentQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.river.mongodb.MongoDBRiver;
import org.elasticsearch.river.mongodb.MongoDBRiverBulkProcessor;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;
import org.elasticsearch.river.mongodb.Operation;
import org.elasticsearch.river.mongodb.SharedContext;
import org.elasticsearch.river.mongodb.Status;
import org.elasticsearch.river.mongodb.Timestamp;
import org.elasticsearch.river.mongodb.util.MongoDBHelper;
import org.elasticsearch.river.mongodb.util.MongoDBRiverHelper;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;

class Indexer
implements Runnable {
    private final ESLogger logger = ESLoggerFactory.getLogger((String)this.getClass().getName());
    private final MongoDBRiver river;
    private final MongoDBRiverDefinition definition;
    private final SharedContext context;
    private final Client esClient;
    private final ScriptService scriptService;
    private final Map<AbstractMap.SimpleEntry<String, String>, MongoDBRiverBulkProcessor> processors = Maps.newHashMap();

    public Indexer(MongoDBRiver river, MongoDBRiverDefinition definition, SharedContext context, Client esClient, ScriptService scriptService) {
        this.river = river;
        this.definition = definition;
        this.context = context;
        this.esClient = esClient;
        this.scriptService = scriptService;
        this.logger.debug("Create bulk processor with parameters - bulk actions: {} - concurrent request: {} - flush interval: {} - bulk size: {}", new Object[]{definition.getBulk().getBulkActions(), definition.getBulk().getConcurrentRequests(), definition.getBulk().getFlushInterval(), definition.getBulk().getBulkSize()});
        this.getBulkProcessor(definition.getIndexName(), definition.getTypeName());
    }

    @Override
    public void run() {
        while (this.context.getStatus() == Status.RUNNING) {
            try {
                Timestamp<?> lastTimestamp = null;
                MongoDBRiver.QueueEntry entry = this.context.getStream().take();
                lastTimestamp = this.processBlockingQueue(entry);
                while ((entry = this.context.getStream().poll(this.definition.getBulk().getFlushInterval().millis(), TimeUnit.MILLISECONDS)) != null) {
                    lastTimestamp = this.processBlockingQueue(entry);
                }
                if (lastTimestamp == null) continue;
                MongoDBRiver.setLastTimestamp(this.definition, lastTimestamp, this.getBulkProcessor(this.definition.getIndexName(), this.definition.getTypeName()).getBulkProcessor());
            }
            catch (InterruptedException interruptedException) {
                this.logger.info("river-mongodb indexer interrupted", new Object[0]);
                this.releaseProcessors();
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private MongoDBRiverBulkProcessor getBulkProcessor(String index, String type) {
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(index, type);
        if (!this.processors.containsKey(entry)) {
            this.processors.put(new AbstractMap.SimpleEntry<String, String>(index, type), new MongoDBRiverBulkProcessor.Builder(this.river, this.definition, this.esClient, index, type).build());
        }
        return this.processors.get(entry);
    }

    private void releaseProcessors() {
        for (MongoDBRiverBulkProcessor processor : this.processors.values()) {
            processor.getBulkProcessor().close();
        }
        this.processors.clear();
    }

    private Timestamp<?> processBlockingQueue(MongoDBRiver.QueueEntry entry) {
        Operation operation = entry.getOperation();
        if (entry.getData().get("_id") == null && (operation == Operation.INSERT || operation == Operation.UPDATE || operation == Operation.DELETE)) {
            this.logger.warn("Cannot get object id. Skip the current item: [{}]", new Object[]{entry.getData()});
            return null;
        }
        Timestamp<?> lastTimestamp = entry.getOplogTimestamp();
        String type = this.definition.isImportAllCollections() ? entry.getCollection() : this.definition.getTypeName();
        if (operation == Operation.COMMAND) {
            try {
                this.updateBulkRequest(entry.getData(), null, operation, this.definition.getIndexName(), type, null, null);
            }
            catch (IOException ioEx) {
                this.logger.error("Update bulk failed.", (Throwable)ioEx, new Object[0]);
            }
            return lastTimestamp;
        }
        String objectId = "";
        if (entry.getData().get("_id") != null) {
            objectId = entry.getData().get("_id").toString();
        }
        if (entry.isAttachment()) {
            try {
                this.updateBulkRequest(entry.getData(), objectId, operation, this.definition.getIndexName(), type, null, null);
            }
            catch (IOException ioEx) {
                this.logger.error("Update bulk failed.", (Throwable)ioEx, new Object[0]);
            }
            return lastTimestamp;
        }
        if (this.hasScript() && this.definition.isAdvancedTransformation()) {
            return this.applyAdvancedTransformation(entry, type);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("updateBulkRequest for id: [{}], operation: [{}]", new Object[]{objectId, operation});
        }
        if (!this.definition.getIncludeCollection().isEmpty()) {
            this.logger.trace("About to include collection. set attribute {} / {} ", new Object[]{this.definition.getIncludeCollection(), this.definition.getMongoCollection()});
            entry.getData().put(this.definition.getIncludeCollection(), (Object)this.definition.getMongoCollection());
        }
        Map<String, Object> ctx = new HashMap<String, Object>();
        Map data = entry.getData().toMap();
        if (this.hasScript() && ctx != null) {
            ctx.put("document", entry.getData());
            ctx.put("operation", operation.getValue());
            if (!objectId.isEmpty()) {
                ctx.put("id", objectId);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Script to be executed: {} - {}", new Object[]{this.definition.getScriptType(), this.definition.getScript()});
                this.logger.trace("Context before script executed: {}", new Object[]{ctx});
            }
            try {
                ExecutableScript executableScript = this.scriptService.executable(this.definition.getScriptType(), this.definition.getScript(), ScriptService.ScriptType.INLINE, (Map)ImmutableMap.of((Object)"logger", (Object)this.logger));
                executableScript.setNextVar("ctx", ctx);
                executableScript.run();
                ctx = (Map)executableScript.unwrap(ctx);
            }
            catch (Exception e) {
                this.logger.warn("failed to script process {}, ignoring", (Throwable)e, new Object[]{ctx});
                MongoDBRiverHelper.setRiverStatus(this.esClient, this.definition.getRiverName(), Status.SCRIPT_IMPORT_FAILED);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Context after script executed: {}", new Object[]{ctx});
            }
            if (this.isDocumentIgnored(ctx)) {
                this.logger.trace("From script ignore document id: {}", new Object[]{objectId});
                return lastTimestamp;
            }
            if (this.isDocumentDeleted(ctx)) {
                ctx.put("operation", "d");
            }
            if (ctx.containsKey("document")) {
                data = (Map)ctx.get("document");
                this.logger.trace("From script document: {}", new Object[]{data});
            }
            operation = this.extractOperation(ctx);
            this.logger.trace("From script operation: {} -> {}", new Object[]{ctx.get("operation").toString(), operation});
        }
        try {
            String index = this.extractIndex(ctx);
            type = this.extractType(ctx, type);
            String parent = this.extractParent(ctx);
            String routing = this.extractRouting(ctx);
            objectId = this.extractObjectId(ctx, objectId);
            this.updateBulkRequest((DBObject)new BasicDBObject(data), objectId, operation, index, type, routing, parent);
        }
        catch (IOException e) {
            this.logger.warn("failed to parse {}", (Throwable)e, new Object[]{entry.getData()});
        }
        return lastTimestamp;
    }

    private void updateBulkRequest(DBObject data, String objectId, Operation operation, String index, String type, String routing, String parent) throws IOException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Operation: {} - index: {} - type: {} - routing: {} - parent: {}", new Object[]{operation, index, type, routing, parent});
        }
        if (operation == Operation.UNKNOWN) {
            this.logger.error("Unknown operation for id[{}] - entry [{}] - index[{}] - type[{}]", new Object[]{objectId, data, index, type});
            this.context.setStatus(Status.IMPORT_FAILED);
            return;
        }
        if (operation == Operation.INSERT) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Insert operation - id: {} - contains attachment: {}", new Object[]{objectId, data instanceof GridFSDBFile});
            }
            this.getBulkProcessor(index, type).addBulkRequest(objectId, this.build(data, objectId), routing, parent);
        }
        if (operation == Operation.UPDATE) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Update operation - id: {} - contains attachment: {}", new Object[]{objectId, data instanceof GridFSDBFile});
            }
            this.deleteBulkRequest(objectId, index, type, routing, parent);
            this.getBulkProcessor(index, type).addBulkRequest(objectId, this.build(data, objectId), routing, parent);
        }
        if (operation == Operation.DELETE) {
            this.logger.trace("Delete request [{}], [{}], [{}]", new Object[]{index, type, objectId});
            this.deleteBulkRequest(objectId, index, type, routing, parent);
        }
        if (operation == Operation.DROP_COLLECTION) {
            if (this.definition.isDropCollection()) {
                MongoDBRiverBulkProcessor processor = this.getBulkProcessor(index, type);
                processor.dropIndex();
            } else {
                this.logger.info("Ignore drop collection request [{}], [{}]. The option has been disabled.", new Object[]{index, type});
            }
        }
    }

    private void deleteBulkRequest(String objectId, String index, String type, String routing, String parent) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("bulkDeleteRequest - objectId: {} - index: {} - type: {} - routing: {} - parent: {}", new Object[]{objectId, index, type, routing, parent});
        }
        if (this.definition.getParentTypes() != null && this.definition.getParentTypes().contains(type)) {
            HasParentQueryBuilder builder = QueryBuilders.hasParentQuery((String)type, (QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)objectId));
            SearchResponse response = (SearchResponse)this.esClient.prepareSearch(new String[]{index}).setQuery((QueryBuilder)builder).setRouting(routing).addField("_id").execute().actionGet();
            SearchHit[] searchHitArray = response.getHits().getHits();
            int n = searchHitArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchHit hit = searchHitArray[n2];
                this.getBulkProcessor(index, hit.getType()).deleteBulkRequest(hit.getId(), routing, objectId);
                ++n2;
            }
        }
        this.getBulkProcessor(index, type).deleteBulkRequest(objectId, routing, parent);
    }

    private Timestamp<?> applyAdvancedTransformation(MongoDBRiver.QueueEntry entry, String type) {
        Timestamp<?> lastTimestamp = entry.getOplogTimestamp();
        Operation operation = entry.getOperation();
        String objectId = "";
        if (entry.getData().get("_id") != null) {
            objectId = entry.getData().get("_id").toString();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("applyAdvancedTransformation for id: [{}], operation: [{}]", new Object[]{objectId, operation});
        }
        if (!this.definition.getIncludeCollection().isEmpty()) {
            this.logger.trace("About to include collection. set attribute {} / {} ", new Object[]{this.definition.getIncludeCollection(), this.definition.getMongoCollection()});
            entry.getData().put(this.definition.getIncludeCollection(), (Object)this.definition.getMongoCollection());
        }
        Map ctx = null;
        try {
            ctx = XContentFactory.xContent((XContentType)XContentType.JSON).createParser("{}").mapAndClose();
        }
        catch (Exception exception) {}
        List documents = new ArrayList();
        HashMap<String, Object> document = new HashMap<String, Object>();
        if (this.hasScript() && ctx != null && documents != null) {
            document.put("data", entry.getData().toMap());
            if (!objectId.isEmpty()) {
                document.put("id", objectId);
            }
            document.put("_index", this.definition.getIndexName());
            document.put("_type", type);
            document.put("operation", operation.getValue());
            documents.add(document);
            ctx.put("documents", documents);
            try {
                ExecutableScript executableScript = this.scriptService.executable(this.definition.getScriptType(), this.definition.getScript(), ScriptService.ScriptType.INLINE, (Map)ImmutableMap.of((Object)"logger", (Object)this.logger));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Script to be executed: {} - {}", new Object[]{this.definition.getScriptType(), this.definition.getScript()});
                    this.logger.trace("Context before script executed: {}", new Object[]{ctx});
                }
                executableScript.setNextVar("ctx", (Object)ctx);
                executableScript.run();
                ctx = (Map)executableScript.unwrap((Object)ctx);
            }
            catch (Exception e) {
                this.logger.error("failed to script process {}, ignoring", (Throwable)e, new Object[]{ctx});
                MongoDBRiverHelper.setRiverStatus(this.esClient, this.definition.getRiverName(), Status.SCRIPT_IMPORT_FAILED);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Context after script executed: {}", new Object[]{ctx});
            }
            if (ctx.containsKey("documents") && ctx.get("documents") instanceof List) {
                documents = (List)ctx.get("documents");
                for (Object object : documents) {
                    if (!(object instanceof Map)) continue;
                    Map item = (Map)object;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("item: {}", new Object[]{item});
                    }
                    if (this.isDocumentDeleted(item)) {
                        item.put("operation", "d");
                    }
                    String index = this.extractIndex(item);
                    type = this.extractType(item, type);
                    String parent = this.extractParent(item);
                    String routing = this.extractRouting(item);
                    operation = this.extractOperation(item);
                    boolean ignore = this.isDocumentIgnored(item);
                    Map data = (Map)item.get("data");
                    objectId = this.extractObjectId(data, objectId);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("#### - Id: {} - operation: {} - ignore: {} - index: {} - type: {} - routing: {} - parent: {}", new Object[]{objectId, operation, ignore, index, type, routing, parent});
                    }
                    if (ignore) continue;
                    try {
                        this.updateBulkRequest((DBObject)new BasicDBObject(data), objectId, operation, index, type, routing, parent);
                    }
                    catch (IOException ioEx) {
                        this.logger.error("Update bulk failed.", (Throwable)ioEx, new Object[0]);
                    }
                }
            }
        }
        return lastTimestamp;
    }

    private XContentBuilder build(DBObject data, String objectId) throws IOException {
        if (data instanceof GridFSDBFile) {
            this.logger.info("Add Attachment: {} to index {} / type {}", new Object[]{objectId, this.definition.getIndexName(), this.definition.getTypeName()});
            return MongoDBHelper.serialize((GridFSDBFile)data);
        }
        Map<String, Object> mapData = this.createObjectMap(data);
        return XContentFactory.jsonBuilder().map(mapData);
    }

    private Map<String, Object> createObjectMap(DBObject dbObj) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        for (String key : dbObj.keySet()) {
            Object value = dbObj.get(key);
            if (value instanceof DBRef) {
                mapData.put(key, this.convertDbRef((DBRef)value));
                continue;
            }
            if (value instanceof BasicDBList) {
                mapData.put(key, ((BasicBSONList)value).toArray());
                continue;
            }
            if (value instanceof BasicDBObject) {
                mapData.put(key, this.createObjectMap((DBObject)value));
                continue;
            }
            mapData.put(key, value);
        }
        return mapData;
    }

    private Map<String, Object> convertDbRef(DBRef ref) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("id", ref.getId());
        obj.put("ref", ref.getRef());
        return obj;
    }

    private boolean hasScript() {
        return this.definition.getScriptType() != null && this.definition.getScript() != null;
    }

    private String extractObjectId(Map<String, Object> ctx, String objectId) {
        Object id = ctx.get("id");
        if (id != null) {
            return id.toString();
        }
        id = ctx.get("_id");
        if (id != null) {
            return id.toString();
        }
        return objectId;
    }

    private String extractParent(Map<String, Object> ctx) {
        Object parent = ctx.get("_parent");
        if (parent == null) {
            return null;
        }
        return parent.toString();
    }

    private String extractRouting(Map<String, Object> ctx) {
        Object routing = ctx.get("_routing");
        if (routing == null) {
            return null;
        }
        return routing.toString();
    }

    private Operation extractOperation(Map<String, Object> ctx) {
        Object operation = ctx.get("operation");
        if (operation == null) {
            return null;
        }
        return Operation.fromString(operation.toString());
    }

    private boolean isDocumentIgnored(Map<String, Object> ctx) {
        return Boolean.TRUE.equals(ctx.get("ignore"));
    }

    private boolean isDocumentDeleted(Map<String, Object> ctx) {
        return Boolean.TRUE.equals(ctx.get("deleted"));
    }

    private String extractType(Map<String, Object> ctx, String defaultType) {
        Object type = ctx.get("_type");
        if (type == null) {
            return defaultType;
        }
        return type.toString();
    }

    private String extractIndex(Map<String, Object> ctx) {
        String index = (String)ctx.get("_index");
        if (index == null) {
            index = this.definition.getIndexName();
        }
        return index;
    }
}

