/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.mongodb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.river.RiverSettings;
import org.elasticsearch.river.mongodb.MongoDBRiver;
import org.elasticsearch.river.mongodb.MongoDBRiverDefinition;
import org.elasticsearch.river.mongodb.Status;
import org.elasticsearch.river.mongodb.Timestamp;
import org.elasticsearch.river.mongodb.rest.XContentThrowableRestResponse;
import org.elasticsearch.river.mongodb.rest.action.support.RestXContentBuilder;
import org.elasticsearch.river.mongodb.util.MongoDBRiverHelper;
import org.elasticsearch.search.SearchHit;

public class RestMongoDBRiverAction
extends BaseRestHandler {
    private final String riverIndexName;

    @Inject
    public RestMongoDBRiverAction(Settings settings, Client esClient, RestController controller, @RiverIndexName String riverIndexName) {
        super(settings, controller, esClient);
        this.riverIndexName = riverIndexName;
        String baseUrl = "/" + riverIndexName + "/" + "mongodb";
        this.logger.trace("RestMongoDBRiverAction - baseUrl: {}", new Object[]{baseUrl});
        controller.registerHandler(RestRequest.Method.GET, String.valueOf(baseUrl) + "/{action}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, String.valueOf(baseUrl) + "/{river}/{action}", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client esClient) throws Exception {
        this.logger.debug("uri: {}", new Object[]{request.uri()});
        this.logger.debug("action: {}", new Object[]{request.param("action")});
        if (request.path().endsWith("list")) {
            this.list(request, channel, esClient);
            return;
        }
        if (request.path().endsWith("start")) {
            this.start(request, channel, esClient);
            return;
        }
        if (request.path().endsWith("stop")) {
            this.stop(request, channel, esClient);
            return;
        }
        if (request.path().endsWith("delete")) {
            this.delete(request, channel, esClient);
            return;
        }
        this.respondError(request, channel, "action not found: " + request.uri(), RestStatus.OK);
    }

    private void delete(RestRequest request, RestChannel channel, Client esClient) {
        String river = request.param("river");
        if (river == null || river.isEmpty()) {
            this.respondError(request, channel, "Parameter 'river' is required", RestStatus.BAD_REQUEST);
            return;
        }
        this.logger.info("Delete river: {}", new Object[]{river});
        if (((TypesExistsResponse)esClient.admin().indices().prepareTypesExists(new String[]{this.riverIndexName}).setTypes(new String[]{river}).get()).isExists()) {
            esClient.admin().indices().prepareDeleteMapping(new String[]{this.riverIndexName}).setType(new String[]{river}).get();
        }
        this.respondSuccess(request, channel, RestStatus.OK);
    }

    private void start(RestRequest request, RestChannel channel, Client esClient) {
        String river = request.param("river");
        if (river == null || river.isEmpty()) {
            this.respondError(request, channel, "Parameter 'river' is required", RestStatus.BAD_REQUEST);
            return;
        }
        MongoDBRiverHelper.setRiverStatus(esClient, river, Status.RUNNING);
        this.respondSuccess(request, channel, RestStatus.OK);
    }

    private void stop(RestRequest request, RestChannel channel, Client esClient) {
        String river = request.param("river");
        if (river == null || river.isEmpty()) {
            this.respondError(request, channel, "Parameter 'river' is required", RestStatus.BAD_REQUEST);
            return;
        }
        MongoDBRiverHelper.setRiverStatus(esClient, river, Status.STOPPED);
        this.respondSuccess(request, channel, RestStatus.OK);
    }

    private void list(RestRequest request, RestChannel channel, Client esClient) {
        try {
            Map<String, Object> rivers = this.getRivers(request.paramAsInt("page", 1), request.paramAsInt("count", 10), esClient);
            XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
            builder.value(rivers);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
        catch (Throwable e) {
            this.errorResponse(request, channel, e);
        }
    }

    private void respondSuccess(RestRequest request, RestChannel channel, RestStatus status) {
        try {
            XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
            builder.startObject();
            builder.field("success", true);
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (IOException e) {
            this.errorResponse(request, channel, e);
        }
    }

    private void respondError(RestRequest request, RestChannel channel, String error, RestStatus status) {
        try {
            XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
            builder.startObject();
            builder.field("success", false);
            builder.field("error", error);
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (IOException e) {
            this.errorResponse(request, channel, e);
        }
    }

    private void errorResponse(RestRequest request, RestChannel channel, Throwable e) {
        try {
            channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, e));
            this.logger.error("errorResponse", e, new Object[0]);
        }
        catch (IOException ioEx) {
            this.logger.error("Failed to send failure response", (Throwable)ioEx, new Object[0]);
        }
    }

    private Map<String, Object> getRivers(int page, int count, Client esClient) {
        int from = (page - 1) * count;
        SearchResponse searchResponse = (SearchResponse)esClient.prepareSearch(new String[]{this.riverIndexName}).setQuery((QueryBuilder)QueryBuilders.queryString((String)"mongodb").defaultField("type")).setFrom(from).setSize(count).get();
        long totalHits = searchResponse.getHits().totalHits();
        this.logger.trace("totalHits: {}", new Object[]{totalHits});
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("hits", totalHits);
        data.put("page", page);
        data.put("pages", Math.ceil((float)totalHits / (float)count));
        ArrayList rivers = new ArrayList();
        int i = 0;
        SearchHit[] searchHitArray = searchResponse.getHits().hits();
        int n = searchHitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            HashMap<String, Object> source = new HashMap<String, Object>();
            String riverName = hit.getType();
            RiverSettings riverSettings = new RiverSettings(null, hit.getSource());
            MongoDBRiverDefinition definition = MongoDBRiverDefinition.parseSettings(riverName, this.riverIndexName, riverSettings, null);
            Timestamp<?> ts = MongoDBRiver.getLastTimestamp(esClient, definition);
            Long lastTimestamp = null;
            if (ts != null) {
                lastTimestamp = ts.getTime();
            }
            source.put("name", riverName);
            source.put("status", (Object)MongoDBRiverHelper.getRiverStatus(esClient, riverName));
            source.put("settings", hit.getSource());
            source.put("lastTimestamp", lastTimestamp);
            source.put("indexCount", MongoDBRiver.getIndexCount(esClient, definition));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("source: {}", new Object[]{hit.getSourceAsString()});
            }
            rivers.add(source);
            ++i;
            ++n2;
        }
        data.put("count", i);
        data.put("results", rivers);
        return data;
    }
}

