/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.river.mongodb;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.rest.action.mongodb.RestMongoDBRiverAction;
import org.elasticsearch.river.RiversModule;
import org.elasticsearch.river.mongodb.MongoClientService;
import org.elasticsearch.river.mongodb.MongoDBRiverModule;
import org.elasticsearch.river.mongodb.NodeLevelModule;

public class MongoDBRiverPlugin
extends AbstractPlugin {
    public String name() {
        return "mongodb-river";
    }

    public String description() {
        return "MongoDB River Plugin";
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        return ImmutableList.builder().addAll((Iterable)super.services()).add(MongoClientService.class).build();
    }

    public Collection<Class<? extends Module>> modules() {
        return ImmutableList.builder().addAll((Iterable)super.modules()).add(NodeLevelModule.class).build();
    }

    public void onModule(RiversModule module) {
        module.registerRiver("mongodb", MongoDBRiverModule.class);
    }

    public void onModule(RestModule module) {
        module.addRestAction(RestMongoDBRiverAction.class);
    }
}

