/*
 * Decompiled with CFR 0.152.
 */
package org.zed.test.rp;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.reactivex.Maybe;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.zed.test.rp.Report;

public class Reportimpl
implements Report {
    public String ProjectName = "";
    public String SprintName = "";
    private String UID;
    private String RURL;
    private ReportPortal rpt = null;
    private String fst = "PASSED";
    private Maybe<String> lid;
    private Maybe<String> sid;
    private Maybe<String> tid;
    private Maybe<String> stid;
    private Maybe<String> itemid;
    String LuanchName;
    public Set<String> Tags;
    public Set<String> stepTags;
    public Set<String> testTags;
    public Set<String> suiteTags;
    Launch launch;
    private static Report.Status oStatus;
    private static Report.LogStatus oLogStatus;

    public Maybe<String> getLaucnId() {
        return this.lid;
    }

    public Reportimpl(String luanchName, String projectName, String sprintName, String uID, String uRL) {
        this.ProjectName = projectName;
        this.SprintName = sprintName;
        this.UID = uID;
        this.RURL = uRL;
        this.LuanchName = luanchName;
    }

    @Override
    public Maybe<String> StartLaunch() {
        ListenerParameters ll = new ListenerParameters();
        ll.setBaseUrl(this.RURL.trim());
        ll.setUuid(this.UID.trim());
        ll.setLaunchName(this.LuanchName);
        ll.setProjectName(this.ProjectName);
        ll.setDescription(this.LuanchName + " FOR " + this.ProjectName);
        ll.setEnable(Boolean.valueOf(true));
        if (this.Tags != null) {
            ll.setTags(this.Tags);
        }
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(ll.getLaunchName());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setMode(ll.getLaunchRunningMode());
        if (this.Tags != null) {
            rq.setTags(ll.getTags());
        }
        rq.setDescription(ll.getDescription());
        try {
            this.rpt = ReportPortal.builder().withParameters(ll).build();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        this.launch = this.rpt.newLaunch(rq);
        this.lid = this.launch.start();
        return this.lid;
    }

    @Override
    public Maybe<String> StartSuite(String Name, String Description) {
        StartTestItemRQ st = new StartTestItemRQ();
        st.setDescription(Description);
        st.setName(Name);
        st.setStartTime(Calendar.getInstance().getTime());
        st.setRetry(Boolean.valueOf(false));
        st.setType("SUITE");
        if (this.suiteTags != null) {
            st.setTags(this.suiteTags);
        }
        this.sid = this.launch.startTestItem(st);
        return this.sid;
    }

    @Override
    public Maybe<String> StartTest(String Name, String Desc) {
        StartTestItemRQ testcase = new StartTestItemRQ();
        testcase.setDescription(Desc);
        testcase.setName(Name);
        testcase.setStartTime(Calendar.getInstance().getTime());
        testcase.setRetry(Boolean.valueOf(false));
        testcase.setType("TEST");
        if (this.testTags != null) {
            testcase.setTags(this.testTags);
        }
        this.tid = this.launch.startTestItem(this.sid, testcase);
        return this.tid;
    }

    @Override
    public Maybe<String> StartStep(String Name, String Description) {
        StartTestItemRQ step = new StartTestItemRQ();
        step.setDescription(Description);
        step.setName(Name);
        step.setStartTime(Calendar.getInstance().getTime());
        step.setRetry(Boolean.valueOf(false));
        step.setType("STEP");
        if (this.stepTags != null) {
            step.setTags(this.stepTags);
        }
        this.stid = this.launch.startTestItem(this.tid, step);
        return this.stid;
    }

    @Override
    public void endLaunch(Report.Status Status2) {
        FinishExecutionRQ fq = new FinishExecutionRQ();
        fq.setEndTime(Calendar.getInstance().getTime());
        fq.setStatus(this.ConvertSStatus(Status2));
        this.launch.finish(fq);
    }

    @Override
    public void endSuite(Report.Status Status2) {
        FinishTestItemRQ ft = new FinishTestItemRQ();
        ft.setEndTime(Calendar.getInstance().getTime());
        ft.setStatus(this.ConvertSStatus(Status2));
        this.launch.finishTestItem(this.sid, ft);
    }

    @Override
    public void endLaunch() {
        FinishExecutionRQ fq = new FinishExecutionRQ();
        fq.setEndTime(Calendar.getInstance().getTime());
        this.launch.finish(fq);
    }

    @Override
    public void endSuite() {
        FinishTestItemRQ ft = new FinishTestItemRQ();
        ft.setEndTime(Calendar.getInstance().getTime());
        this.launch.finishTestItem(this.sid, ft);
    }

    @Override
    public void endTest(Report.Status Status2) {
        FinishTestItemRQ ftc = new FinishTestItemRQ();
        ftc.setEndTime(Calendar.getInstance().getTime());
        ftc.setStatus(this.ConvertSStatus(Status2));
        this.launch.finishTestItem(this.tid, ftc);
    }

    @Override
    public void endStep(Report.Status Status2) {
        FinishTestItemRQ ftep = new FinishTestItemRQ();
        ftep.setEndTime(Calendar.getInstance().getTime());
        ftep.setStatus(this.ConvertSStatus(Status2));
        this.launch.finishTestItem(this.stid, ftep);
    }

    @Override
    public void log(String message, Report.LogStatus status) {
        ReportPortal.emitLog((String)message, (String)this.ConvertStatus(status), (Date)Calendar.getInstance().getTime());
    }

    @Override
    public void log(String message, Report.LogStatus status, File f) {
        ReportPortal.emitLog((String)message, (String)this.ConvertStatus(status), (Date)Calendar.getInstance().getTime(), (File)f);
    }

    private String ConvertStatus(Report.LogStatus S) {
        switch (S) {
            case Info: {
                return "INFO";
            }
            case Error: {
                return "ERROR";
            }
            case Warn: {
                return "WARN";
            }
            case Fatal: {
                return "FATAL";
            }
            case Debug: {
                return "DEBUG";
            }
        }
        return "INFO";
    }

    private String ConvertSStatus(Report.Status S) {
        switch (S) {
            case PASSED: {
                return "PASSED";
            }
            case Failed: {
                return "FAILED";
            }
            case SKIPPED: {
                return "SKIPPED";
            }
        }
        return "PASSED";
    }

    @Override
    public Maybe<String> ReStartLaunch(Maybe<String> elid) {
        this.launch = this.rpt.withLaunch(elid);
        this.lid = this.launch.start();
        return this.lid;
    }

    @Override
    public Maybe<String> ReStartSuite(Maybe<String> esid, String Name, String Description) {
        StartTestItemRQ st = new StartTestItemRQ();
        st.setName(Name);
        st.setDescription(Description);
        st.setStartTime(Calendar.getInstance().getTime());
        st.setType("SUITE");
        this.sid = this.launch.startTestItem(esid, st);
        return this.sid;
    }

    @Override
    public Report.Status getStatus() {
        return oStatus;
    }

    @Override
    public Report.LogStatus getLogStatus() {
        return oLogStatus;
    }

    @Override
    public Set<String> getTags() {
        return this.Tags;
    }

    @Override
    public void setTags(Set<String> s) {
        this.Tags = s;
    }

    @Override
    public Maybe<String> startItem(String item, String Name, String Description) {
        StartTestItemRQ step = new StartTestItemRQ();
        step.setDescription(Description);
        step.setName(Name);
        step.setStartTime(Calendar.getInstance().getTime());
        step.setRetry(Boolean.valueOf(false));
        step.setType(item);
        this.itemid = this.launch.startTestItem(this.tid, step);
        return this.itemid;
    }

    @Override
    public Maybe<String> startItem(boolean test, String item, String Name, String Description) {
        StartTestItemRQ step = new StartTestItemRQ();
        step.setDescription(Description);
        step.setName(Name);
        step.setStartTime(Calendar.getInstance().getTime());
        step.setRetry(Boolean.valueOf(false));
        step.setType(item);
        this.itemid = test ? this.launch.startTestItem(this.lid, step) : this.launch.startTestItem(this.sid, step);
        return this.itemid;
    }

    @Override
    public void endItem(Report.Status Status2) {
        FinishTestItemRQ ftep = new FinishTestItemRQ();
        ftep.setEndTime(Calendar.getInstance().getTime());
        if (Status2 != null) {
            ftep.setStatus(this.ConvertSStatus(Status2));
        }
        this.launch.finishTestItem(this.itemid, ftep);
    }

    @Override
    public void endItem(String Description, Report.Status Status2) {
        FinishTestItemRQ ftep = new FinishTestItemRQ();
        ftep.setEndTime(Calendar.getInstance().getTime());
        ftep.setDescription(Description);
        if (Status2 != null) {
            ftep.setStatus(this.ConvertSStatus(Status2));
        }
        this.launch.finishTestItem(this.itemid, ftep);
    }

    @Override
    public void endStep(String Description, Report.Status Status2) {
        FinishTestItemRQ ftep = new FinishTestItemRQ();
        ftep.setEndTime(Calendar.getInstance().getTime());
        ftep.setStatus(this.ConvertSStatus(Status2));
        ftep.setDescription(Description);
        this.launch.finishTestItem(this.stid, ftep);
    }
}

