/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.test.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@PropertySource(value={"classpath:properties/database.properties"})
public class TestConfiguration {
    @Value(value="${database.datasource.poolname}")
    private String dataSourcePoolName;
    @Value(value="${database.datasource.driver}")
    private String dataSourceDriver;
    @Value(value="${database.datasource.url}")
    private String dataSourceUrl;
    @Value(value="${database.datasource.username}")
    private String dataSourceUsername;
    @Value(value="${database.datasource.password}")
    private String dataSourcePassword;
    @Value(value="${database.dbunit.dataTypeFactory}")
    private String dbUnitDataTypeFactory;
    @Value(value="${database.hibernate.dialect}")
    private String hibernateDialect;
    @Value(value="${database.hibernate.format_sql}")
    private boolean hibernateFormatSql;
    @Value(value="${database.hibernate.show_sql}")
    private boolean hibernateShowSql;
    @Value(value="${database.hibernate.hbm2ddl.auto}")
    private String hibernateHbm2DdlAuto;
    @Resource
    private List<String> hibernatePackagesToScan;

    @Bean(destroyMethod="close")
    public DataSource dataSource() {
        return new HikariDataSource(this.hikariConfig());
    }

    @Bean
    public IDataTypeFactory dataTypeFactory() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (IDataTypeFactory)Class.forName(this.dbUnitDataTypeFactory).newInstance();
    }

    @Bean
    public EntityManagerFactory entityManagerFactory() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setShowSql(true);
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.dialect", this.hibernateDialect);
        jpaProperties.put("hibernate.format_sql", (Object)this.hibernateFormatSql);
        jpaProperties.put("hibernate.show_sql", (Object)this.hibernateShowSql);
        jpaProperties.put("hibernate.hbm2ddl.auto", this.hibernateHbm2DdlAuto);
        jpaProperties.put("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        jpaProperties.put("hibernate.id.new_generator_mappings", "true");
        LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
        factory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        factory.setPackagesToScan(this.hibernatePackagesToScan.toArray(new String[this.hibernatePackagesToScan.size()]));
        factory.setDataSource(this.dataSource());
        factory.setJpaProperties(jpaProperties);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    public HikariConfig hikariConfig() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName(this.dataSourcePoolName);
        hikariConfig.setDriverClassName(this.dataSourceDriver);
        hikariConfig.setJdbcUrl(this.dataSourceUrl);
        hikariConfig.setUsername(this.dataSourceUsername);
        hikariConfig.setPassword(this.dataSourcePassword);
        hikariConfig.setMaximumPoolSize(50);
        return hikariConfig;
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager txManager = new JpaTransactionManager();
        txManager.setEntityManagerFactory(this.entityManagerFactory());
        return txManager;
    }
}

