/*
 * Decompiled with CFR 0.152.
 */
package com.github.ppodgorsek.cache.spring.strategy.impl;

import com.github.ppodgorsek.cache.invalidation.exception.InvalidationException;
import com.github.ppodgorsek.cache.invalidation.model.impl.IdentifiedInvalidationEntry;
import com.github.ppodgorsek.cache.spring.strategy.AbstractCacheManagerInvalidationStrategy;
import com.github.ppodgorsek.cache.spring.strategy.CacheManagerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;

public class IdentifiedCacheManagerInvalidationStrategy
extends AbstractCacheManagerInvalidationStrategy<IdentifiedInvalidationEntry>
implements CacheManagerStrategy<IdentifiedInvalidationEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiedCacheManagerInvalidationStrategy.class);

    @Override
    public void invalidate(IdentifiedInvalidationEntry entry) throws InvalidationException {
        Assert.notNull((Object)entry, (String)"The entry is required");
        String entryId = entry.getId();
        if (entryId == null) {
            LOGGER.warn("Invalidation entry {} has no ID, can't evict it from the cache", (Object)entry);
        } else {
            for (String cacheName : this.getCacheNames()) {
                Cache cache = this.getCacheManager().getCache(cacheName);
                if (cache == null) continue;
                cache.evict((Object)entryId);
                LOGGER.debug("Evicted entry '{}' from cache {}", (Object)entryId, (Object)cacheName);
            }
        }
    }
}

