/*
 * Decompiled with CFR 0.152.
 */
package com.github.ppodgorsek.cache.spring.helper.impl;

import com.github.ppodgorsek.cache.invalidation.exception.InvalidationException;
import com.github.ppodgorsek.cache.invalidation.helper.AbstractChainedInvalidationHelper;
import com.github.ppodgorsek.cache.invalidation.helper.InvalidationHelper;
import com.github.ppodgorsek.cache.invalidation.model.InvalidationEntry;
import com.github.ppodgorsek.cache.spring.strategy.CacheManagerStrategy;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public class CacheManagerHelper<T extends InvalidationEntry>
extends AbstractChainedInvalidationHelper<T>
implements InvalidationHelper<T> {
    private Map<Class<T>, CacheManagerStrategy<T>> cacheManagerStrategies;

    protected void invalidateEntry(T entry) throws InvalidationException {
        CacheManagerStrategy<T> cacheManagerStrategy = this.cacheManagerStrategies.get(entry.getClass());
        if (cacheManagerStrategy != null) {
            cacheManagerStrategy.invalidate(entry);
        }
    }

    public Map<Class<T>, CacheManagerStrategy<T>> getCacheManagerStrategies() {
        return this.cacheManagerStrategies;
    }

    @Required
    public void setCacheManagerStrategies(Map<Class<T>, CacheManagerStrategy<T>> strategies) {
        this.cacheManagerStrategies = strategies;
    }
}

