/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.pool;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionTimeoutedException;
import com.github.mauricio.async.db.pool.ObjectFactory;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.pool.PostgreSQLConnectionFactory$;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%q!B\t\u0013\u0011\u0003\tc!B\u0012\u0013\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%\tA\f\u0005\u0007o\u0005\u0001\u000b\u0011B\u0018\t\u000fa\n\u0011\u0013!C\u0001s!9a*AI\u0001\n\u0003ye\u0001B\u0012\u0013\u0001]C\u0001\"Y\u0004\u0003\u0006\u0004%\tA\u0019\u0005\tO\u001e\u0011\t\u0011)A\u0005G\"A\u0001n\u0002B\u0001B\u0003%1\b\u0003\u0005j\u000f\t\u0005\t\u0015!\u0003R\u0011\u0015Ys\u0001\"\u0001k\u0011\u0015yw\u0001\"\u0001q\u0011\u0015\tx\u0001\"\u0001s\u0011\u0015Ax\u0001\"\u0001z\u0011\u001d\t\u0019a\u0002C!\u0003\u000b\t1\u0004U8ti\u001e\u0014XmU)M\u0007>tg.Z2uS>tg)Y2u_JL(BA\n\u0015\u0003\u0011\u0001xn\u001c7\u000b\u0005U1\u0012A\u00039pgR<'/Z:rY*\u0011q\u0003G\u0001\u0003I\nT!!\u0007\u000e\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005ma\u0012\u0001C7bkJL7-[8\u000b\u0005uq\u0012AB4ji\",(MC\u0001 \u0003\r\u0019w.\\\u0002\u0001!\t\u0011\u0013!D\u0001\u0013\u0005m\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\u001a\u000b7\r^8ssN\u0011\u0011!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0013a\u00017pOV\tq\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005)1\u000f\u001c45U*\tA'A\u0002pe\u001eL!AN\u0019\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005Q$FA\u001eF!\ta4)D\u0001>\u0015\tqt(A\u0004dQ\u0006tg.\u001a7\u000b\u0005\u0001\u000b\u0015!\u00028fiRL(\"\u0001\"\u0002\u0005%|\u0017B\u0001#>\u00059)e/\u001a8u\u0019>|\u0007o\u0012:pkB\\\u0013A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-;\u0013AC1o]>$\u0018\r^5p]&\u0011Q\n\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001QU\t\tV\t\u0005\u0002S+6\t1K\u0003\u0002UO\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Y\u001b&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u'\r9Q\u0005\u0017\t\u00043nkV\"\u0001.\u000b\u0005M1\u0012B\u0001/[\u00055y%M[3di\u001a\u000b7\r^8ssB\u0011alX\u0007\u0002)%\u0011\u0001\r\u0006\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0002\u001b\r|gNZ5hkJ\fG/[8o+\u0005\u0019\u0007C\u00013f\u001b\u00051\u0012B\u00014\u0017\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006q1m\u001c8gS\u001e,(/\u0019;j_:\u0004\u0013!B4s_V\u0004\u0018\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u)\u0011YG.\u001c8\u0011\u0005\t:\u0001\"B1\r\u0001\u0004\u0019\u0007b\u00025\r!\u0003\u0005\ra\u000f\u0005\bS2\u0001\n\u00111\u0001R\u0003\u0019\u0019'/Z1uKV\tQ,A\u0004eKN$(o\\=\u0015\u0005M4\bC\u0001\u0014u\u0013\t)xE\u0001\u0003V]&$\b\"B<\u000f\u0001\u0004i\u0016\u0001B5uK6\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0004u\u0006\u0005\u0001cA>\u007f;6\tAP\u0003\u0002~O\u0005!Q\u000f^5m\u0013\tyHPA\u0002UefDQa^\bA\u0002u\u000bA\u0001^3tiR\u0019!0a\u0002\t\u000b]\u0004\u0002\u0019A/")
public class PostgreSQLConnectionFactory
implements ObjectFactory<PostgreSQLConnection> {
    private final Configuration configuration;
    private final EventLoopGroup group;
    private final ExecutionContext executionContext;

    public static ExecutionContext $lessinit$greater$default$3() {
        return PostgreSQLConnectionFactory$.MODULE$.$lessinit$greater$default$3();
    }

    public static EventLoopGroup $lessinit$greater$default$2() {
        return PostgreSQLConnectionFactory$.MODULE$.$lessinit$greater$default$2();
    }

    public static Logger log() {
        return PostgreSQLConnectionFactory$.MODULE$.log();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public PostgreSQLConnection create() {
        Configuration x$1 = this.configuration();
        EventLoopGroup x$2 = this.group;
        ExecutionContext x$3 = this.executionContext;
        ColumnEncoderRegistry x$4 = PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
        ColumnDecoderRegistry x$5 = PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
        PostgreSQLConnection connection = new PostgreSQLConnection(x$1, x$4, x$5, x$2, x$3);
        Await$.MODULE$.result(connection.connect(), this.configuration().connectTimeout());
        return connection;
    }

    public void destroy(PostgreSQLConnection item) {
        item.disconnect();
    }

    public Try<PostgreSQLConnection> validate(PostgreSQLConnection item) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (item.isTimeouted()) {
                throw new ConnectionTimeoutedException((Connection)item);
            }
            if (!item.isConnected() || item.hasRecentError()) {
                throw new ClosedChannelException();
            }
            item.validateIfItIsReadyForQuery("Trying to give back a connection that is not ready for query");
            return item;
        });
    }

    public Try<PostgreSQLConnection> test(PostgreSQLConnection item) {
        Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Await$.MODULE$.result(item.sendQuery("SELECT 0"), this.configuration().testTimeout());
            return item;
        });
        Try try_ = result;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = item.isConnected() ? item.disconnect() : BoxedUnit.UNIT;
            }
            catch (Exception e) {
                PostgreSQLConnectionFactory$.MODULE$.log().error("Failed disconnecting object", (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return result;
        }
        if (try_ instanceof Success) {
            return result;
        }
        throw new MatchError((Object)try_);
    }

    public PostgreSQLConnectionFactory(Configuration configuration, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.group = group;
        this.executionContext = executionContext;
        ObjectFactory.$init$((ObjectFactory)this);
    }
}

