/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.parsers;

import com.github.mauricio.async.db.exceptions.ParserNotAvailableException;
import com.github.mauricio.async.db.postgresql.messages.backend.ServerMessage;
import com.github.mauricio.async.db.postgresql.parsers.AuthenticationStartupParser$;
import com.github.mauricio.async.db.postgresql.parsers.BackendKeyDataParser$;
import com.github.mauricio.async.db.postgresql.parsers.CommandCompleteParser;
import com.github.mauricio.async.db.postgresql.parsers.DataRowParser$;
import com.github.mauricio.async.db.postgresql.parsers.ErrorParser;
import com.github.mauricio.async.db.postgresql.parsers.MessageParser;
import com.github.mauricio.async.db.postgresql.parsers.NoticeParser;
import com.github.mauricio.async.db.postgresql.parsers.NotificationResponseParser;
import com.github.mauricio.async.db.postgresql.parsers.ParameterStatusParser;
import com.github.mauricio.async.db.postgresql.parsers.ReadyForQueryParser$;
import com.github.mauricio.async.db.postgresql.parsers.ReturningMessageParser$;
import com.github.mauricio.async.db.postgresql.parsers.RowDescriptionParser;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0005\n\u0001C!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u00033\u0001\u0011\u00051\u0007C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\rq\u0002\u0001\u0015!\u0003:\u0011\u001di\u0004A1A\u0005\nyBaA\u0011\u0001!\u0002\u0013y\u0004bB\"\u0001\u0005\u0004%I\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\u000f%\u0003!\u0019!C\u0005\u0015\"1a\n\u0001Q\u0001\n-Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004U\u0001\u0001\u0006I!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019Q\u0006\u0001)A\u0005/\")1\f\u0001C\u00059\")Q\r\u0001C\u0001M\n1R*Z:tC\u001e,\u0007+\u0019:tKJ\u001c(+Z4jgR\u0014\u0018P\u0003\u0002\u0014)\u00059\u0001/\u0019:tKJ\u001c(BA\u000b\u0017\u0003)\u0001xn\u001d;he\u0016\u001c\u0018\u000f\u001c\u0006\u0003/a\t!\u0001\u001a2\u000b\u0005eQ\u0012!B1ts:\u001c'BA\u000e\u001d\u0003!i\u0017-\u001e:jG&|'BA\u000f\u001f\u0003\u00199\u0017\u000e\u001e5vE*\tq$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fqa\u00195beN,G\u000f\u0005\u0002+a5\t1F\u0003\u0002)Y)\u0011QFL\u0001\u0004]&|'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c-\u0012qa\u00115beN,G/\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003IAQ\u0001\u000b\u0002A\u0002%\nQcY8n[\u0006tGmQ8na2,G/\u001a)beN,'/F\u0001:!\t)$(\u0003\u0002<%\t)2i\\7nC:$7i\\7qY\u0016$X\rU1sg\u0016\u0014\u0018AF2p[6\fg\u000eZ\"p[BdW\r^3QCJ\u001cXM\u001d\u0011\u0002\u0017\u0015\u0014(o\u001c:QCJ\u001cXM]\u000b\u0002\u007fA\u0011Q\u0007Q\u0005\u0003\u0003J\u00111\"\u0012:s_J\u0004\u0016M]:fe\u0006aQM\u001d:peB\u000b'o]3sA\u0005aan\u001c;jG\u0016\u0004\u0016M]:feV\tQ\t\u0005\u00026\r&\u0011qI\u0005\u0002\r\u001d>$\u0018nY3QCJ\u001cXM]\u0001\u000e]>$\u0018nY3QCJ\u001cXM\u001d\u0011\u0002+A\f'/Y7fi\u0016\u00148\u000b^1ukN\u0004\u0016M]:feV\t1\n\u0005\u00026\u0019&\u0011QJ\u0005\u0002\u0016!\u0006\u0014\u0018-\\3uKJ\u001cF/\u0019;vgB\u000b'o]3s\u0003Y\u0001\u0018M]1nKR,'o\u0015;biV\u001c\b+\u0019:tKJ\u0004\u0013\u0001\u0006:po\u0012+7o\u0019:jaRLwN\u001c)beN,'/F\u0001R!\t)$+\u0003\u0002T%\t!\"k\\<EKN\u001c'/\u001b9uS>t\u0007+\u0019:tKJ\fQC]8x\t\u0016\u001c8M]5qi&|g\u000eU1sg\u0016\u0014\b%\u0001\u000eo_RLg-[2bi&|gNU3ta>t7/\u001a)beN,'/F\u0001X!\t)\u0004,\u0003\u0002Z%\tQbj\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016\u0004\u0016M]:fe\u0006Ybn\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016\u0004\u0016M]:fe\u0002\n\u0011\u0002]1sg\u0016\u0014hi\u001c:\u0015\u0005u\u0003\u0007CA\u001b_\u0013\ty&CA\u0007NKN\u001c\u0018mZ3QCJ\u001cXM\u001d\u0005\u0006C>\u0001\rAY\u0001\u0002iB\u00111eY\u0005\u0003I\u0012\u0012AAQ=uK\u0006)\u0001/\u0019:tKR\u0019qm\u001c9\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017a\u00022bG.,g\u000e\u001a\u0006\u0003YR\t\u0001\"\\3tg\u0006<Wm]\u0005\u0003]&\u0014QbU3sm\u0016\u0014X*Z:tC\u001e,\u0007\"B1\u0011\u0001\u0004\u0011\u0007\"B9\u0011\u0001\u0004\u0011\u0018!\u00012\u0011\u0005MTX\"\u0001;\u000b\u0005U4\u0018A\u00022vM\u001a,'O\u0003\u0002xq\u0006)a.\u001a;us*\t\u00110\u0001\u0002j_&\u00111\u0010\u001e\u0002\b\u0005f$XMQ;g\u0001")
public class MessageParsersRegistry {
    private final CommandCompleteParser commandCompleteParser;
    private final ErrorParser errorParser;
    private final NoticeParser noticeParser;
    private final ParameterStatusParser parameterStatusParser;
    private final RowDescriptionParser rowDescriptionParser;
    private final NotificationResponseParser notificationResponseParser;

    private CommandCompleteParser commandCompleteParser() {
        return this.commandCompleteParser;
    }

    private ErrorParser errorParser() {
        return this.errorParser;
    }

    private NoticeParser noticeParser() {
        return this.noticeParser;
    }

    private ParameterStatusParser parameterStatusParser() {
        return this.parameterStatusParser;
    }

    private RowDescriptionParser rowDescriptionParser() {
        return this.rowDescriptionParser;
    }

    private NotificationResponseParser notificationResponseParser() {
        return this.notificationResponseParser;
    }

    private MessageParser parserFor(byte t) {
        byte by = t;
        switch (by) {
            case 82: {
                return AuthenticationStartupParser$.MODULE$;
            }
            case 75: {
                return BackendKeyDataParser$.MODULE$;
            }
            case 50: {
                return ReturningMessageParser$.MODULE$.BindCompleteMessageParser();
            }
            case 51: {
                return ReturningMessageParser$.MODULE$.CloseCompleteMessageParser();
            }
            case 67: {
                return this.commandCompleteParser();
            }
            case 68: {
                return DataRowParser$.MODULE$;
            }
            case 69: {
                return this.errorParser();
            }
            case 73: {
                return ReturningMessageParser$.MODULE$.EmptyQueryStringMessageParser();
            }
            case 110: {
                return ReturningMessageParser$.MODULE$.NoDataMessageParser();
            }
            case 78: {
                return this.noticeParser();
            }
            case 65: {
                return this.notificationResponseParser();
            }
            case 83: {
                return this.parameterStatusParser();
            }
            case 49: {
                return ReturningMessageParser$.MODULE$.ParseCompleteMessageParser();
            }
            case 84: {
                return this.rowDescriptionParser();
            }
            case 90: {
                return ReadyForQueryParser$.MODULE$;
            }
        }
        throw new ParserNotAvailableException(t);
    }

    public ServerMessage parse(byte t, ByteBuf b) {
        return this.parserFor(t).parseMessage(b);
    }

    public MessageParsersRegistry(Charset charset) {
        this.commandCompleteParser = new CommandCompleteParser(charset);
        this.errorParser = new ErrorParser(charset);
        this.noticeParser = new NoticeParser(charset);
        this.parameterStatusParser = new ParameterStatusParser(charset);
        this.rowDescriptionParser = new RowDescriptionParser(charset);
        this.notificationResponseParser = new NotificationResponseParser(charset);
    }
}

