/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.encoders;

import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.postgresql.encoders.Encoder;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementEncoderHelper;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementOpeningEncoder$;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.util.ByteBufferUtils$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r<QAC\u0006\t\u0002i1Q\u0001H\u0006\t\u0002uAQ\u0001J\u0001\u0005\u0002\u0015BqAJ\u0001C\u0002\u0013\u0005q\u0005\u0003\u00041\u0003\u0001\u0006I\u0001\u000b\u0004\u00059-\u0001\u0011\u0007\u0003\u00059\u000b\t\u0005\t\u0015!\u0003:\u0011!\u0011UA!A!\u0002\u0013\u0019\u0005\"\u0002\u0013\u0006\t\u0003I\u0005\"B'\u0006\t\u0003r\u0015a\b)sKB\f'/\u001a3Ti\u0006$X-\\3oi>\u0003XM\\5oO\u0016s7m\u001c3fe*\u0011A\"D\u0001\tK:\u001cw\u000eZ3sg*\u0011abD\u0001\u000ba>\u001cHo\u001a:fgFd'B\u0001\t\u0012\u0003\t!'M\u0003\u0002\u0013'\u0005)\u0011m]=oG*\u0011A#F\u0001\t[\u0006,(/[2j_*\u0011acF\u0001\u0007O&$\b.\u001e2\u000b\u0003a\t1aY8n\u0007\u0001\u0001\"aG\u0001\u000e\u0003-\u0011q\u0004\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u001fB,g.\u001b8h\u000b:\u001cw\u000eZ3s'\t\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\t1\u0001\\8h+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0013aA8sO&\u0011qF\u000b\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\n\u0005\u000by\u0011T\u0007\u0005\u0002\u001cg%\u0011Ag\u0003\u0002\b\u000b:\u001cw\u000eZ3s!\tYb'\u0003\u00028\u0017\tq\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;F]\u000e|G-\u001a:IK2\u0004XM]\u0001\bG\"\f'o]3u!\tQ\u0004)D\u0001<\u0015\tADH\u0003\u0002>}\u0005\u0019a.[8\u000b\u0003}\nAA[1wC&\u0011\u0011i\u000f\u0002\b\u0007\"\f'o]3u\u0003\u001d)gnY8eKJ\u0004\"\u0001R$\u000e\u0003\u0015S!AR\b\u0002\r\r|G.^7o\u0013\tAUIA\u000bD_2,XN\\#oG>$WM\u001d*fO&\u001cHO]=\u0015\u0007)[E\n\u0005\u0002\u001c\u000b!)\u0001\b\u0003a\u0001s!)!\t\u0003a\u0001\u0007\u00061QM\\2pI\u0016$\"aT-\u0011\u0005A;V\"A)\u000b\u0005I\u001b\u0016A\u00022vM\u001a,'O\u0003\u0002U+\u0006)a.\u001a;us*\ta+\u0001\u0002j_&\u0011\u0001,\u0015\u0002\b\u0005f$XMQ;g\u0011\u0015Q\u0016\u00021\u0001\\\u0003\u001diWm]:bO\u0016\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u0011\u0019\u0014xN\u001c;f]\u0012T!\u0001Y\u0007\u0002\u00115,7o]1hKNL!AY/\u0003\u001b\rc\u0017.\u001a8u\u001b\u0016\u001c8/Y4f\u0001")
public class PreparedStatementOpeningEncoder
implements Encoder,
PreparedStatementEncoderHelper {
    private final Charset charset;
    private final ColumnEncoderRegistry encoder;

    public static Logger log() {
        return PreparedStatementOpeningEncoder$.MODULE$.log();
    }

    @Override
    public ByteBuf writeExecutePortal(byte[] statementIdBytes, String query, Seq<Object> values, ColumnEncoderRegistry encoder, Charset charset, boolean writeDescribe) {
        return PreparedStatementEncoderHelper.writeExecutePortal$(this, statementIdBytes, query, values, encoder, charset, writeDescribe);
    }

    @Override
    public boolean writeExecutePortal$default$6() {
        return PreparedStatementEncoderHelper.writeExecutePortal$default$6$(this);
    }

    @Override
    public boolean isNull(Object value) {
        return PreparedStatementEncoderHelper.isNull$(this, value);
    }

    @Override
    public ByteBuf encode(ClientMessage message) {
        PreparedStatementOpeningMessage m = (PreparedStatementOpeningMessage)message;
        byte[] statementIdBytes = Integer.toString(m.statementId()).getBytes(this.charset);
        int columnCount = m.valueTypes().size();
        ByteBuf parseBuffer = Unpooled.buffer((int)1024);
        parseBuffer.writeByte(80);
        parseBuffer.writeInt(0);
        parseBuffer.writeBytes(statementIdBytes);
        parseBuffer.writeByte(0);
        parseBuffer.writeBytes(m.query().getBytes(this.charset));
        parseBuffer.writeByte(0);
        parseBuffer.writeShort(columnCount);
        if (PreparedStatementOpeningEncoder$.MODULE$.log().isDebugEnabled()) {
            PreparedStatementOpeningEncoder$.MODULE$.log().debug(new StringBuilder(66).append("Opening query (").append(m.query()).append(") - statement id (").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(statementIdBytes)).mkString("-")).append(") - selected types (").append(m.valueTypes().mkString(", ")).append(") - values (").append(m.values().mkString(", ")).append(")").toString());
        }
        m.valueTypes().foreach((Function1 & Serializable & scala.Serializable)kind -> parseBuffer.writeInt(BoxesRunTime.unboxToInt((Object)kind)));
        ByteBufferUtils$.MODULE$.writeLength(parseBuffer);
        ByteBuf executeBuffer = this.writeExecutePortal(statementIdBytes, m.query(), m.values(), this.encoder, this.charset, true);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{parseBuffer, executeBuffer});
    }

    public PreparedStatementOpeningEncoder(Charset charset, ColumnEncoderRegistry encoder) {
        this.charset = charset;
        this.encoder = encoder;
        PreparedStatementEncoderHelper.$init$(this);
    }
}

