/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.column;

import com.github.mauricio.async.db.column.ColumnDecoder;
import com.github.mauricio.async.db.column.ColumnEncoder;
import com.github.mauricio.async.db.column.ColumnEncoderDecoder;
import com.github.mauricio.async.db.exceptions.DateEncoderNotAvailableException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.util.Log$;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class PostgreSQLIntervalEncoderDecoder$
implements ColumnEncoderDecoder {
    public static PostgreSQLIntervalEncoderDecoder$ MODULE$;
    private final Logger log;
    private final PeriodFormatter formatter;
    private final PeriodFormatter postgres_verboseParser;
    private final PeriodFormatter hmsParser;
    private final PeriodFormatter postgresParser;
    private final PeriodFormatter sqlDTParser;
    private final PeriodFormatter sqlParser;

    static {
        new PostgreSQLIntervalEncoderDecoder$();
    }

    public Object decode(ColumnData kind, ByteBuf value, Charset charset) {
        return ColumnDecoder.decode$((ColumnDecoder)this, (ColumnData)kind, (ByteBuf)value, (Charset)charset);
    }

    public boolean supportsStringDecoding() {
        return ColumnDecoder.supportsStringDecoding$((ColumnDecoder)this);
    }

    private Logger log() {
        return this.log;
    }

    private PeriodFormatter formatter() {
        return this.formatter;
    }

    public String encode(Object value) {
        Object object = value;
        if (object instanceof ReadablePeriod) {
            ReadablePeriod readablePeriod = (ReadablePeriod)object;
            return this.formatter().print(readablePeriod);
        }
        if (object instanceof ReadableDuration) {
            ReadableDuration readableDuration = (ReadableDuration)object;
            return readableDuration.toString();
        }
        throw new DateEncoderNotAvailableException(value);
    }

    private PeriodFormatterBuilder postgresYMDBuilder(PeriodFormatterBuilder builder) {
        return builder.appendYears().appendSuffix(" year", " years").appendSeparator(" ").appendMonths().appendSuffix(" mon", " mons").appendSeparator(" ").appendDays().appendSuffix(" day", " days").appendSeparator(" ");
    }

    private PeriodFormatter postgres_verboseParser() {
        return this.postgres_verboseParser;
    }

    private PeriodFormatterBuilder postgresHMSBuilder(PeriodFormatterBuilder builder) {
        return builder.rejectSignedValues(true).appendHours().appendSuffix(":").appendMinutes().appendSuffix(":").appendSecondsWithOptionalMillis();
    }

    private PeriodFormatter hmsParser() {
        return this.hmsParser;
    }

    private PeriodFormatter postgresParser() {
        return this.postgresParser;
    }

    private PeriodFormatterBuilder sqlDTBuilder(PeriodFormatterBuilder builder) {
        return this.postgresHMSBuilder(builder.appendDays().appendSeparator(" "));
    }

    private PeriodFormatter sqlDTParser() {
        return this.sqlDTParser;
    }

    private PeriodFormatter sqlParser() {
        return this.sqlParser;
    }

    public Period decode(String value) {
        PeriodFormatter format;
        int i;
        if (value.isEmpty()) {
            return Period.ZERO;
        }
        PeriodFormatter periodFormatter = ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0))).equals(BoxesRunTime.boxToCharacter((char)'P')) ? this.formatter() : (value.startsWith("@ ") ? this.postgres_verboseParser() : ((i = new StringOps(Predef$.MODULE$.augmentString(value)).indexWhere((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PostgreSQLIntervalEncoderDecoder$.$anonfun$decode$1(BoxesRunTime.unboxToChar((Object)x$1))), new StringOps(Predef$.MODULE$.augmentString("-+")).contains((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0))) ? 1 : 0)) < 0 || new StringOps(Predef$.MODULE$.augmentString(":.")).contains((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i))) ? this.hmsParser() : (((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i))).equals(BoxesRunTime.boxToCharacter((char)'-')) ? this.sqlParser() : (format = ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i))).equals(BoxesRunTime.boxToCharacter((char)' ')) && i + 1 < value.length() && RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i + 1))) ? this.sqlDTParser() : this.postgresParser()))));
        if (format == this.hmsParser() && ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0))).equals(BoxesRunTime.boxToCharacter((char)'-'))) {
            return format.parsePeriod(value.substring(1)).negated();
        }
        if (value.endsWith(" ago")) {
            return format.parsePeriod(new StringOps(Predef$.MODULE$.augmentString(value)).stripSuffix(" ago")).negated();
        }
        return format.parsePeriod(value);
    }

    public static final /* synthetic */ boolean $anonfun$decode$1(char x$1) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$1));
    }

    private PostgreSQLIntervalEncoderDecoder$() {
        MODULE$ = this;
        ColumnEncoder.$init$((ColumnEncoder)this);
        ColumnDecoder.$init$((ColumnDecoder)this);
        this.log = Log$.MODULE$.getByName(this.getClass().getName());
        this.formatter = ISOPeriodFormat.standard();
        this.postgres_verboseParser = this.postgresYMDBuilder(new PeriodFormatterBuilder().appendLiteral("@ ")).appendHours().appendSuffix(" hour", " hours").appendSeparator(" ").appendMinutes().appendSuffix(" min", " mins").appendSeparator(" ").appendSecondsWithOptionalMillis().appendSuffix(" sec", " secs").toFormatter();
        this.hmsParser = this.postgresHMSBuilder(new PeriodFormatterBuilder()).toFormatter();
        this.postgresParser = this.postgresHMSBuilder(this.postgresYMDBuilder(new PeriodFormatterBuilder())).toFormatter();
        this.sqlDTParser = this.sqlDTBuilder(new PeriodFormatterBuilder()).toFormatter();
        this.sqlParser = this.sqlDTBuilder(new PeriodFormatterBuilder().printZeroAlways().rejectSignedValues(true).appendYears().appendSeparator("-").appendMonths().rejectSignedValues(false).printZeroNever().appendSeparator(" ")).toFormatter();
    }
}

