/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.ResultSetBuilder;
import com.github.mauricio.async.db.pool.TimeoutScheduler;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.NotificationResponse;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.compat.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005s!B/_\u0011\u0003Yg!B7_\u0011\u0003q\u0007\"B;\u0002\t\u00031\bbB<\u0002\u0005\u0004%)\u0001\u001f\u0005\b\u0003\u0017\t\u0001\u0015!\u0004z\u0011%\ti!\u0001b\u0001\n\u000b\ty\u0001\u0003\u0005\u0002\u0018\u0005\u0001\u000bQBA\t\u0011%\tI\"\u0001b\u0001\n\u000b\tY\u0002\u0003\u0005\u0002.\u0005\u0001\u000bQBA\u000f\u0011%\ty#AI\u0001\n\u0003\t\t\u0004C\u0005\u0002P\u0005\t\n\u0011\"\u0001\u0002R!I\u0011\u0011M\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003[\n\u0011\u0013!C\u0001\u0003_B\u0011\"a\"\u0002#\u0003%\t!!#\u0007\u000b5t\u0006!a&\t\u0015\u0005]fB!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002::\u0011\t\u0011)A\u0005\u0003+B!\"a/\u000f\u0005\u0003\u0005\u000b\u0011BA4\u0011)\tiL\u0004B\u0001B\u0003%\u00111\u000f\u0005\u000b\u0003\u007fs!Q1A\u0005\u0004\u0005\u0005\u0007BCAb\u001d\t\u0005\t\u0015!\u0003\u0002\u000e\"1QO\u0004C\u0001\u0003\u000bD\u0011\"a5\u000f\u0005\u0004%i!!6\t\u0011\u0005ug\u0002)A\u0007\u0003/D\u0011\"a8\u000f\u0005\u0004%i!!9\t\u0011\u0005%h\u0002)A\u0007\u0003GD\u0011\"a;\u000f\u0005\u0004%i!!<\t\u0011\u0005Uh\u0002)A\u0007\u0003_D\u0011\"a>\u000f\u0005\u0004%I!!?\t\u0011\t\u0005b\u0002)A\u0005\u0003wD\u0011Ba\t\u000f\u0005\u0004%IA!\n\t\u0011\t=b\u0002)A\u0005\u0005OA\u0011B!\r\u000f\u0001\u0004%IAa\r\t\u0013\tmb\u00021A\u0005\n\tu\u0002\u0002\u0003B%\u001d\u0001\u0006KA!\u000e\t\u0013\t-cB1A\u0005\n\t5\u0003\u0002\u0003B+\u001d\u0001\u0006IAa\u0014\t\u0013\t]c\u00021A\u0005\n\tM\u0002\"\u0003B-\u001d\u0001\u0007I\u0011\u0002B.\u0011!\u0011yF\u0004Q!\n\tU\u0002\"\u0003B1\u001d\t\u0007I\u0011\u0002B2\u0011!\u0011IH\u0004Q\u0001\n\t\u0015\u0004\"\u0003B>\u001d\u0001\u0007I\u0011\u0002B?\u0011%\u0011iJ\u0004a\u0001\n\u0013\u0011y\n\u0003\u0005\u0003$:\u0001\u000b\u0015\u0002B@\u0011%\u0011)K\u0004a\u0001\n\u0013\u00119\u000bC\u0005\u0003,:\u0001\r\u0011\"\u0003\u0003.\"A!\u0011\u0017\b!B\u0013\u0011I\u000bC\u0005\u00034:\u0001\r\u0011\"\u0003\u00036\"I!\u0011\u0019\bA\u0002\u0013%!1\u0019\u0005\t\u0005\u000ft\u0001\u0015)\u0003\u00038\"I!\u0011\u001a\bA\u0002\u0013%!1\u001a\u0005\n\u0005Ct\u0001\u0019!C\u0005\u0005GD\u0001Ba:\u000fA\u0003&!Q\u001a\u0005\n\u0005St\u0001\u0019!C\u0005\u0005WD\u0011Ba<\u000f\u0001\u0004%IA!=\t\u0011\tUh\u0002)Q\u0005\u0005[DqAa>\u000f\t\u0003\u0012I\u0010C\u0004\u0003|:!\tAa\r\t\u000f\tuh\u0002\"\u0001\u0003\u0000\"91q\u0001\b\u0005B\t}\bbBB\u0005\u001d\u0011\u000531\u0002\u0005\b\u0007\u001bqA\u0011\tB\u001a\u0011\u001d\u0019yA\u0004C\u0001\u0007#Aqaa\b\u000f\t\u0003\u001a\t\u0003C\u0004\u0004*9!\tea\u000b\t\u0013\r-c\"%A\u0005\u0002\r5\u0003bBB)\u001d\u0011\u000531\u000b\u0005\b\u0007?rA\u0011\u0001B\u001a\u0011\u001d\u0019\tG\u0004C\u0005\u0007GBqa!\u001b\u000f\t\u0003\u001aY\u0007C\u0004\u0004R9!\te!\u001c\t\u000f\red\u0002\"\u0011\u0004|!91Q\u0011\b\u0005B\r\u001d\u0005bBBI\u001d\u0011\u000531\u0013\u0005\b\u0007;sA\u0011IBP\u0011\u001d\u0019IK\u0004C\u0005\u0007WCqaa.\u000f\t\u0003\u001aI\fC\u0004\u0004F:!\tea2\t\u000f\r-g\u0002\"\u0001\u0004N\"911\u001b\b\u0005\u0002\rU\u0007bBBm\u001d\u0011\u000511\u000e\u0005\b\u00077tA\u0011BBo\u0011!\u0019)P\u0004Q\u0005\n\r]\bb\u0002C\u0004\u001d\u0011\u0005A\u0011\u0002\u0005\b\t\u001bqA\u0011\u0002C\b\u0011\u001d!\u0019B\u0004C\u0005\t+Aq\u0001b\u0006\u000f\t\u0013!I\u0002C\u0004\u0005 9!I\u0001\"\u0006\t\u000f\u0011\u0005b\u0002\"\u0003\u0005$!9A\u0011\u0006\b\u0005\n\u0011-\u0002b\u0002C\u0019\u001d\u0011%A1\u0007\u0005\b\t{qA\u0011\tC \u0003Q\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]*\u0011q\fY\u0001\u000ba>\u001cHo\u001a:fgFd'BA1c\u0003\t!'M\u0003\u0002dI\u0006)\u0011m]=oG*\u0011QMZ\u0001\t[\u0006,(/[2j_*\u0011q\r[\u0001\u0007O&$\b.\u001e2\u000b\u0003%\f1aY8n\u0007\u0001\u0001\"\u0001\\\u0001\u000e\u0003y\u0013A\u0003U8ti\u001e\u0014XmU)M\u0007>tg.Z2uS>t7CA\u0001p!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a[\u0001\b\u0007>,h\u000e^3s+\u0005I\bc\u0001>\u0002\b5\t1P\u0003\u0002}{\u00061\u0011\r^8nS\u000eT!A`@\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B;uS2T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013Y(AC!u_6L7\rT8oO\u0006A1i\\;oi\u0016\u0014\b%\u0001\tTKJ4XM\u001d,feNLwN\\&fsV\u0011\u0011\u0011C\b\u0003\u0003'\t#!!\u0006\u0002\u001dM,'O^3s?Z,'o]5p]\u0006\t2+\u001a:wKJ4VM]:j_:\\U-\u001f\u0011\u0002\u00071|w-\u0006\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!B:mMRR'BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\t\tC\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003gQC!!\u000e\u0002>A!\u0011qGA\u001d\u001b\u0005\u0001\u0017bAA\u001eA\ni1i\u001c8gS\u001e,(/\u0019;j_:\\#!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013\n\u0018AC1o]>$\u0018\r^5p]&!\u0011QJA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M#\u0006BA+\u0003{\u0001B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037\u0002\u0017AB2pYVlg.\u0003\u0003\u0002`\u0005e#!F\"pYVlg.\u00128d_\u0012,'OU3hSN$(/_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015$\u0006BA4\u0003{\u0001B!a\u0016\u0002j%!\u00111NA-\u0005U\u0019u\u000e\\;n]\u0012+7m\u001c3feJ+w-[:uef\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA9U\u0011\t\u0019(!\u0010\u0011\t\u0005U\u00141Q\u0007\u0003\u0003oRA!!\u001f\u0002|\u000591\r[1o]\u0016d'\u0002BA?\u0003\u007f\nQA\\3uifT!!!!\u0002\u0005%|\u0017\u0002BAC\u0003o\u0012a\"\u0012<f]Rdun\u001c9He>,\b/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0017SC!!$\u0002>A!\u0011qRAJ\u001b\t\t\tJ\u0003\u0002\u007fc&!\u0011QSAI\u0005A)\u00050Z2vi&|gnQ8oi\u0016DHo\u0005\u0005\u000f_\u0006e\u0015QUAV!\u0011\tY*!)\u000e\u0005\u0005u%bAAP=\u0006)1m\u001c3fG&!\u00111UAO\u0005q\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\u0012+G.Z4bi\u0016\u0004B!a\u000e\u0002(&\u0019\u0011\u0011\u00161\u0003\u0015\r{gN\\3di&|g\u000e\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fY\u0001\u0005a>|G.\u0003\u0003\u00026\u0006=&\u0001\u0005+j[\u0016|W\u000f^*dQ\u0016$W\u000f\\3s\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\u0006yQM\\2pI\u0016\u0014(+Z4jgR\u0014\u00180A\beK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0003\u00159'o\\;q\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0002\u000e\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0015\u0019\u0005\u001d\u0017\u0011ZAf\u0003\u001b\fy-!5\u0011\u00051t\u0001\"CA\\+A\u0005\t\u0019AA\u001b\u0011%\tI,\u0006I\u0001\u0002\u0004\t)\u0006C\u0005\u0002<V\u0001\n\u00111\u0001\u0002h!I\u0011QX\u000b\u0011\u0002\u0003\u0007\u00111\u000f\u0005\n\u0003\u007f+\u0002\u0013!a\u0002\u0003\u001b\u000b\u0011cY8o]\u0016\u001cG/[8o\u0011\u0006tG\r\\3s+\t\t9\u000e\u0005\u0003\u0002\u001c\u0006e\u0017\u0002BAn\u0003;\u00131\u0004U8ti\u001e\u0014XmU)M\u0007>tg.Z2uS>t\u0007*\u00198eY\u0016\u0014\u0018AE2p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\u0002\nAbY;se\u0016tGoQ8v]R,\"!a9\u0011\u0007A\f)/C\u0002\u0002hF\u0014A\u0001T8oO\u0006i1-\u001e:sK:$8i\\;oi\u0002\n\u0011\u0004\u001d:fa\u0006\u0014X\rZ*uCR,W.\u001a8ug\u000e{WO\u001c;feV\u0011\u0011q\u001e\t\u0004u\u0006E\u0018bAAzw\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\f!\u0004\u001d:fa\u0006\u0014X\rZ*uCR,W.\u001a8ug\u000e{WO\u001c;fe\u0002\nq\u0002]1sC6,G/\u001a:Ti\u0006$Xo]\u000b\u0003\u0003w\u0004\u0002\"!@\u0003\b\t-!1B\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u00059Q.\u001e;bE2,'b\u0001B\u0003c\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%\u0011q \u0002\b\u0011\u0006\u001c\b.T1q!\u0011\u0011iAa\u0007\u000f\t\t=!q\u0003\t\u0004\u0005#\tXB\u0001B\n\u0015\r\u0011)B[\u0001\u0007yI|w\u000e\u001e \n\u0007\te\u0011/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005;\u0011yB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00053\t\u0018\u0001\u00059be\u0006lW\r^3s'R\fG/^:!\u0003A\u0001\u0018M]:fIN#\u0018\r^3nK:$8/\u0006\u0002\u0003(AA\u0011Q B\u0004\u0005\u0017\u0011I\u0003E\u0002m\u0005WI1A!\f_\u0005]\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e%pY\u0012,'/A\tqCJ\u001cX\rZ*uCR,W.\u001a8ug\u0002\nQ\"Y;uQ\u0016tG/[2bi\u0016$WC\u0001B\u001b!\r\u0001(qG\u0005\u0004\u0005s\t(a\u0002\"p_2,\u0017M\\\u0001\u0012CV$\b.\u001a8uS\u000e\fG/\u001a3`I\u0015\fH\u0003\u0002B \u0005\u000b\u00022\u0001\u001dB!\u0013\r\u0011\u0019%\u001d\u0002\u0005+:LG\u000fC\u0005\u0003H\u0005\n\t\u00111\u0001\u00036\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^3eA\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8GkR,(/Z\u000b\u0003\u0005\u001f\u0002b!a$\u0003R\u0005\u0015\u0016\u0002\u0002B*\u0003#\u0013q\u0001\u0015:p[&\u001cX-A\td_:tWm\u0019;j_:4U\u000f^;sK\u0002\n1B]3dK:$XI\u001d:pe\u0006y!/Z2f]R,%O]8s?\u0012*\u0017\u000f\u0006\u0003\u0003@\tu\u0003\"\u0003B$M\u0005\u0005\t\u0019\u0001B\u001b\u00031\u0011XmY3oi\u0016\u0013(o\u001c:!\u0003U\tX/\u001a:z!J|W.[:f%\u00164WM]3oG\u0016,\"A!\u001a\u0011\u000bi\u00149Ga\u001b\n\u0007\t%4PA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0015\u0001(Q\u000eB9\u0013\r\u0011y'\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005=%\u0011\u000bB:!\u0011\t9D!\u001e\n\u0007\t]\u0004MA\u0006Rk\u0016\u0014\u0018PU3tk2$\u0018AF9vKJL\bK]8nSN,'+\u001a4fe\u0016t7-\u001a\u0011\u0002\u0019\r,(O]3oiF+XM]=\u0016\u0005\t}\u0004#\u00029\u0003n\t\u0005\u0005C\u0002BB\u0005\u0013\u0013i)\u0004\u0002\u0003\u0006*\u0019!q\u00111\u0002\u000f\u001d,g.\u001a:bY&!!1\u0012BC\u0005A\u0011Vm];miN+GOQ;jY\u0012,'\u000f\u0005\u0003\u0003\u0010\neUB\u0001BI\u0015\u0011\u0011\u0019J!&\u0002\u000f\t\f7m[3oI*\u0019!q\u00130\u0002\u00115,7o]1hKNLAAa'\u0003\u0012\n!\u0002k\\:uOJ,7+\u0015'D_2,XN\u001c#bi\u0006\f\u0001cY;se\u0016tG/U;fef|F%Z9\u0015\t\t}\"\u0011\u0015\u0005\n\u0005\u000fZ\u0013\u0011!a\u0001\u0005\u007f\nQbY;se\u0016tG/U;fef\u0004\u0013\u0001G2veJ,g\u000e\u001e)sKB\f'/\u001a3Ti\u0006$X-\\3oiV\u0011!\u0011\u0016\t\u0006a\n5$\u0011F\u0001\u001dGV\u0014(/\u001a8u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$x\fJ3r)\u0011\u0011yDa,\t\u0013\t\u001dc&!AA\u0002\t%\u0016!G2veJ,g\u000e\u001e)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u0002\nqA^3sg&|g.\u0006\u0002\u00038B!!\u0011\u0018B_\u001b\t\u0011YLC\u0002\u0002\u0002\u0001LAAa0\u0003<\n9a+\u001a:tS>t\u0017a\u0003<feNLwN\\0%KF$BAa\u0010\u0003F\"I!qI\u0019\u0002\u0002\u0003\u0007!qW\u0001\tm\u0016\u00148/[8oA\u0005yan\u001c;jMfd\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u0003NB1!q\u001aBi\u0005+l\u0011!`\u0005\u0004\u0005'l(\u0001F\"paf|en\u0016:ji\u0016\f%O]1z\u0019&\u001cH\u000fE\u0004q\u0005/\u0014YNa\u0010\n\u0007\te\u0017OA\u0005Gk:\u001cG/[8ocA!!q\u0012Bo\u0013\u0011\u0011yN!%\u0003)9{G/\u001b4jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0003Mqw\u000e^5gs2K7\u000f^3oKJ\u001cx\fJ3r)\u0011\u0011yD!:\t\u0013\t\u001dC'!AA\u0002\t5\u0017\u0001\u00058pi&4\u0017\u0010T5ti\u0016tWM]:!\u0003-\tX/\u001a:z%\u0016\u001cX\u000f\u001c;\u0016\u0005\t5\b#\u00029\u0003n\tM\u0014aD9vKJL(+Z:vYR|F%Z9\u0015\t\t}\"1\u001f\u0005\n\u0005\u000f:\u0014\u0011!a\u0001\u0005[\fA\"];fef\u0014Vm];mi\u0002\na\"\u001a<f]Rdun\u001c9He>,\b/\u0006\u0002\u0002t\u0005y\u0011n\u001d*fC\u0012Lhi\u001c:Rk\u0016\u0014\u00180A\u0004d_:tWm\u0019;\u0016\u0005\r\u0005\u0001CBAH\u0007\u0007\t)+\u0003\u0003\u0004\u0006\u0005E%A\u0002$viV\u0014X-\u0001\u0006eSN\u001cwN\u001c8fGR\f\u0011b\u001c8US6,w.\u001e;\u0016\u0005\t}\u0012aC5t\u0007>tg.Z2uK\u0012\f\u0011\u0003]1sC6,G/\u001a:Ti\u0006$Xo]3t+\t\u0019\u0019\u0002\u0005\u0005\u0004\u0016\rm!1\u0002B\u0006\u001b\t\u00199B\u0003\u0003\u0004\u001a\t\r\u0011!C5n[V$\u0018M\u00197f\u0013\u0011\u0019iba\u0006\u0003\u00075\u000b\u0007/A\u0005tK:$\u0017+^3ssR!11EB\u0013!\u0019\tyia\u0001\u0003t!91q\u0005!A\u0002\t-\u0011!B9vKJL\u0018!F:f]\u0012\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u000b\u0007\u0007G\u0019ica\f\t\u000f\r\u001d\u0012\t1\u0001\u0003\f!I1\u0011G!\u0011\u0002\u0003\u000711G\u0001\u0007m\u0006dW/Z:\u0011\r\rU2qHB#\u001d\u0011\u00199da\u000f\u000f\t\tE1\u0011H\u0005\u0002e&\u00191QH9\u0002\u000fA\f7m[1hK&!1\u0011IB\"\u0005\r\u0019V-\u001d\u0006\u0004\u0007{\t\bc\u00019\u0004H%\u00191\u0011J9\u0003\u0007\u0005s\u00170A\u0010tK:$\u0007K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;%I\u00164\u0017-\u001e7uII*\"aa\u0014+\t\rM\u0012QH\u0001\b_:,%O]8s)\u0011\u0011yd!\u0016\t\u000f\r]3\t1\u0001\u0004Z\u0005IQ\r_2faRLwN\u001c\t\u0005\u0007k\u0019Y&\u0003\u0003\u0004^\r\r#!\u0003+ie><\u0018M\u00197f\u00039A\u0017m\u001d*fG\u0016tG/\u0012:s_J\f\u0011c]3u\u000bJ\u0014xN](o\rV$XO]3t)\u0011\u0011yd!\u001a\t\u000f\r\u001dT\t1\u0001\u0004Z\u0005\tQ-A\bp]J+\u0017\rZ=G_J\fV/\u001a:z)\t\u0011y\u0004\u0006\u0003\u0003@\r=\u0004bBB9\u000f\u0002\u000711O\u0001\u0002[B!!qRB;\u0013\u0011\u00199H!%\u0003\u0019\u0015\u0013(o\u001c:NKN\u001c\u0018mZ3\u0002#=t7i\\7nC:$7i\\7qY\u0016$X\r\u0006\u0003\u0003@\ru\u0004bBB9\u0011\u0002\u00071q\u0010\t\u0005\u0005\u001f\u001b\t)\u0003\u0003\u0004\u0004\nE%AF\"p[6\fg\u000eZ\"p[BdW\r^3NKN\u001c\u0018mZ3\u0002#=t\u0007+\u0019:b[\u0016$XM]*uCR,8\u000f\u0006\u0003\u0003@\r%\u0005bBB9\u0013\u0002\u000711\u0012\t\u0005\u0005\u001f\u001bi)\u0003\u0003\u0004\u0010\nE%A\u0006)be\u0006lW\r^3s'R\fG/^:NKN\u001c\u0018mZ3\u0002\u0013=tG)\u0019;b%><H\u0003\u0002B \u0007+Cqa!\u001dK\u0001\u0004\u00199\n\u0005\u0003\u0003\u0010\u000ee\u0015\u0002BBN\u0005#\u0013a\u0002R1uCJ{w/T3tg\u0006<W-\u0001\tp]J{w\u000fR3tGJL\u0007\u000f^5p]R!!qHBQ\u0011\u001d\u0019\th\u0013a\u0001\u0007G\u0003BAa$\u0004&&!1q\u0015BI\u0005U\u0011vn\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:lUm]:bO\u0016\fab]3u\u0007>dW/\u001c8ECR\f7\u000f\u0006\u0003\u0003@\r5\u0006bBBX\u0019\u0002\u00071\u0011W\u0001\fG>dW/\u001c8ECR\f7\u000fE\u0003q\u0007g\u0013i)C\u0002\u00046F\u0014Q!\u0011:sCf\f\u0001d\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0011\u0011yda/\t\u000f\ruV\n1\u0001\u0004@\u00069Q.Z:tC\u001e,\u0007\u0003\u0002BH\u0007\u0003LAaa1\u0003\u0012\n)\u0012)\u001e;iK:$\u0018nY1uS>tW*Z:tC\u001e,\u0017AF8o\u001d>$\u0018NZ5dCRLwN\u001c*fgB|gn]3\u0015\t\t}2\u0011\u001a\u0005\b\u0007{s\u0005\u0019\u0001Bn\u0003Y\u0011XmZ5ti\u0016\u0014hj\u001c;jMfd\u0015n\u001d;f]\u0016\u0014H\u0003\u0002B \u0007\u001fDqa!5P\u0001\u0004\u0011).\u0001\u0005mSN$XM\\3s\u0003a)hN]3hSN$XM\u001d(pi&4\u0017\u0010T5ti\u0016tWM\u001d\u000b\u0005\u0005\u007f\u00199\u000eC\u0004\u0004RB\u0003\rA!6\u0002)\rdW-\u0019:O_RLg-\u001f'jgR,g.\u001a:t\u0003)\u0019'/\u001a3f]RL\u0017\r\u001c\u000b\u0005\u0007?\u001cY\u000f\u0005\u0003\u0004b\u000e\u001dXBABr\u0015\u0011\u0019)O!&\u0002\u0011\u0019\u0014xN\u001c;f]\u0012LAa!;\u0004d\n\t2I]3eK:$\u0018.\u00197NKN\u001c\u0018mZ3\t\u000f\r5(\u000b1\u0001\u0004p\u0006)\u0012-\u001e;iK:$\u0018nY1uS>tW*Z:tC\u001e,\u0007\u0003\u0002BH\u0007cLAaa=\u0003\u0012\nq\u0012)\u001e;iK:$\u0018nY1uS>t7\t[1mY\u0016tw-Z'fgN\fw-Z\u0001\u0016]>$(+Z1es\u001a{'/U;fef,%O]8s)\u0019\u0019Ipa@\u0005\u0004A\u0019\u0001oa?\n\u0007\ru\u0018OA\u0004O_RD\u0017N\\4\t\u000f\u0011\u00051\u000b1\u0001\u0003\f\u0005aQM\u001d:pe6+7o]1hK\"9AQA*A\u0002\tU\u0012\u0001\u0002:bG\u0016\f1D^1mS\u0012\fG/Z%g\u0013RL5OU3bIf4uN])vKJLH\u0003\u0002B \t\u0017Aq\u0001\"\u0001U\u0001\u0004\u0011Y!A\u0007wC2LG-\u0019;f#V,'/\u001f\u000b\u0005\u0005\u007f!\t\u0002C\u0004\u0004(U\u0003\rAa\u0003\u0002\u0019E,XM]=Qe>l\u0017n]3\u0016\u0005\t-\u0014aD:fiF+XM]=Qe>l\u0017n]3\u0015\t\t}B1\u0004\u0005\b\t;9\u0006\u0019\u0001B9\u0003\u001d\u0001(o\\7jg\u0016\f\u0011c\u00197fCJ\fV/\u001a:z!J|W.[:f\u0003A1\u0017-\u001b7Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u0003@\u0011\u0015\u0002b\u0002C\u00143\u0002\u00071\u0011L\u0001\u0002i\u0006\u00192/^2dK\u0016$\u0017+^3ssB\u0013x.\\5tKR!!q\bC\u0017\u0011\u001d!yC\u0017a\u0001\u0005g\naA]3tk2$\u0018!B<sSR,G\u0003\u0002B \tkAqa!0\\\u0001\u0004!9\u0004\u0005\u0003\u0004b\u0012e\u0012\u0002\u0002C\u001e\u0007G\u0014Qb\u00117jK:$X*Z:tC\u001e,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0001")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final EventLoopGroup group;
    private final ExecutionContext executionContext;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger preparedStatementsCounter;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<ResultSetBuilder<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners;
    private Option<QueryResult> queryResult;
    private AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static EventLoopGroup $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public boolean isTimeouted() {
        return TimeoutScheduler.isTimeouted$((TimeoutScheduler)this);
    }

    public <A> Option<ScheduledFuture<?>> addTimeout(Promise<A> promise, Option<Duration> durationOption, ExecutionContext executionContext) {
        return TimeoutScheduler.addTimeout$((TimeoutScheduler)this, promise, durationOption, (ExecutionContext)executionContext);
    }

    public ScheduledFuture<?> schedule(Function0<BoxedUnit> block, Duration duration) {
        return TimeoutScheduler.schedule$((TimeoutScheduler)this, block, (Duration)duration);
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.inTransaction$((Connection)this, f, (ExecutionContext)executionContext);
    }

    public AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool() {
        return this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;
    }

    public void com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool_$eq(AtomicBoolean x$1) {
        this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool = x$1;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    private final AtomicInteger preparedStatementsCounter() {
        return this.preparedStatementsCounter;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    private HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    private Promise<Connection> connectionFuture() {
        return this.connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<ResultSetBuilder<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<ResultSetBuilder<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners() {
        return this.notifyListeners;
    }

    private void notifyListeners_$eq(CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> x$1) {
        this.notifyListeners = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.group;
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().failed().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PostgreSQLConnection.$anonfun$connect$1(this, x0$1)), this.executionContext());
        return this.connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1 & Serializable & scala.Serializable)c -> this, this.executionContext());
    }

    public void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.$conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query));
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        PreparedStatementMessage preparedStatementMessage;
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        PreparedStatementHolder holder = (PreparedStatementHolder)this.parsedStatements().getOrElseUpdate((Object)query, (Function0 & Serializable & scala.Serializable)() -> new PreparedStatementHolder(query, this.preparedStatementsCounter().incrementAndGet()));
        if (holder.paramsCount() != values.length()) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder.paramsCount(), values);
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder));
        this.currentQuery_$eq((Option<ResultSetBuilder<PostgreSQLColumnData>>)new Some((Object)new ResultSetBuilder((IndexedSeq)ArraySeq$.MODULE$.unsafeWrapArray((Object)holder.columnDatas()))));
        if (holder.prepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        } else {
            holder.prepared_$eq(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (!this.connectionFuture().isCompleted()) {
            this.connectionFuture().failure(e);
            future = this.disconnect();
        } else {
            future = BoxedUnit.UNIT;
        }
        this.currentPreparedStatement().map((Function1 & Serializable & scala.Serializable)p -> this.parsedStatements().remove((Object)p.query()));
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1 & Serializable & scala.Serializable)result -> {
            this.succeedQueryPromise(result);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", new Object[]{m});
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.build()))));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        this.parameterStatus().put((Object)m.key(), (Object)m.value());
        if ("server_version".equals(m.key())) {
            this.version_$eq(Version$.MODULE$.apply(m.value()));
            return;
        }
    }

    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.values())).size()];
        for (int x = 0; x < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.values())).size(); ++x) {
            Object object;
            ByteBuf buf = m.values()[x];
            if (buf == null) {
                object = null;
            } else {
                try {
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)((ResultSetBuilder)this.currentQuery().get()).columnTypes().apply(x);
                    object = this.decoderRegistry.decode((ColumnData)columnType, buf, this.configuration.charset());
                }
                finally {
                    buf.release();
                }
            }
            items[x] = object;
        }
        ((ResultSetBuilder)this.currentQuery().get()).addRow(items);
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<ResultSetBuilder<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new ResultSetBuilder((IndexedSeq)ArraySeq$.MODULE$.unsafeWrapArray((Object)m.columnDatas()))));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(PostgreSQLColumnData[] columnDatas) {
        this.currentPreparedStatement().foreach((Function1 & Serializable & scala.Serializable)holder -> {
            holder.columnDatas_$eq(columnDatas);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage = message;
        if (authenticationMessage instanceof AuthenticationOkMessage) {
            PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
            this.authenticated_$eq(true);
            return;
        }
        if (authenticationMessage instanceof AuthenticationChallengeCleartextMessage) {
            AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
            this.write(this.credential(authenticationChallengeCleartextMessage));
            return;
        }
        if (authenticationMessage instanceof AuthenticationChallengeMD5) {
            AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
            this.write(this.credential(authenticationChallengeMD5));
            return;
        }
        throw new MatchError((Object)authenticationMessage);
    }

    @Override
    public void onNotificationResponse(NotificationResponse message) {
        Iterator<Function1<NotificationResponse, BoxedUnit>> iterator = this.notifyListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().apply((Object)message);
        }
    }

    public void registerNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().add(listener);
    }

    public void unregisterNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().remove(listener);
    }

    public void clearNotifyListeners() {
        this.notifyListeners().clear();
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() != null && this.configuration.password().isDefined()) {
            return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
        }
        throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (!this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
        }
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1 & Serializable & scala.Serializable)promise -> {
            PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", new Object[]{promise});
            return promise.failure(t);
        });
    }

    private void succeedQueryPromise(QueryResult result) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.currentQuery_$eq((Option<ResultSetBuilder<PostgreSQLColumnData>>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.success((Object)result));
    }

    private void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringBuilder(10).append(this.getClass().getSimpleName()).append("{counter=").append(this.currentCount()).append("}").toString();
    }

    public static final /* synthetic */ boolean $anonfun$connect$1(PostgreSQLConnection $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        return $this.connectionFuture().tryFailure(throwable);
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.group = group;
        this.executionContext = executionContext;
        Connection.$init$((Connection)this);
        TimeoutScheduler.$init$((TimeoutScheduler)this);
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, group, executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.preparedStatementsCounter = new AtomicInteger();
        this.parameterStatus = new HashMap();
        this.parsedStatements = new HashMap();
        this.authenticated = false;
        this.connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.notifyListeners = new CopyOnWriteArrayList();
        this.queryResult = None$.MODULE$;
    }
}

