/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql.binary.encoder;

import com.github.mauricio.async.db.mysql.binary.encoder.BinaryEncoder;
import io.netty.buffer.ByteBuf;
import org.joda.time.LocalDateTime;

public final class LocalDateTimeEncoder$
implements BinaryEncoder {
    public static final LocalDateTimeEncoder$ MODULE$;

    static {
        new LocalDateTimeEncoder$();
    }

    @Override
    public void encode(Object value, ByteBuf buffer) {
        LocalDateTime instant = (LocalDateTime)value;
        boolean hasMillis = instant.getMillisOfSecond() != 0;
        ByteBuf byteBuf = hasMillis ? buffer.writeByte(11) : buffer.writeByte(7);
        buffer.writeShort(instant.getYear());
        buffer.writeByte(instant.getMonthOfYear());
        buffer.writeByte(instant.getDayOfMonth());
        buffer.writeByte(instant.getHourOfDay());
        buffer.writeByte(instant.getMinuteOfHour());
        buffer.writeByte(instant.getSecondOfMinute());
        if (hasMillis) {
            buffer.writeInt(instant.getMillisOfSecond() * 1000);
        }
    }

    @Override
    public int encodesTo() {
        return 7;
    }

    private LocalDateTimeEncoder$() {
        MODULE$ = this;
    }
}

