/*
 * Decompiled with CFR 0.152.
 */
package com.podio.user;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.contact.Profile;
import com.podio.contact.ProfileField;
import com.podio.contact.ProfileFieldValues;
import com.podio.contact.ProfileUpdate;
import com.podio.user.ProfileFieldMultiValue;
import com.podio.user.ProfileFieldSingleValue;
import com.podio.user.PropertyValue;
import com.podio.user.User;
import com.podio.user.UserStatus;
import com.podio.user.UserUpdate;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserAPI
extends BaseAPI {
    public UserAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public void updateUser(UserUpdate update) {
        this.getResourceFactory().getApiResource("/user/").put(Entity.entity((Object)update, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public UserStatus getStatus() {
        return (UserStatus)this.getResourceFactory().getApiResource("/user/status").get(UserStatus.class);
    }

    public Profile getProfile() {
        return (Profile)this.getResourceFactory().getApiResource("/user/profile/").get(Profile.class);
    }

    public <T, R> List<T> getProfileField(ProfileField<T, R> field) {
        List values = (List)this.getResourceFactory().getApiResource("/user/profile/" + field.getName()).get().readEntity(new GenericType<List<R>>(){});
        ArrayList<T> formatted = new ArrayList<T>();
        for (Object value : values) {
            formatted.add(field.parse(value));
        }
        return formatted;
    }

    public void updateProfile(ProfileUpdate profile) {
        this.getResourceFactory().getApiResource("/user/profile/").put(Entity.entity((Object)profile, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public <F> void updateProfileField(ProfileField<F, ?> field, F value) {
        if (field.isSingle()) {
            this.getResourceFactory().getApiResource("/user/profile/" + field.getName()).put(Entity.entity(new ProfileFieldSingleValue<F>(value), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        } else {
            this.getResourceFactory().getApiResource("/user/profile/" + field.getName()).put(Entity.entity(new ProfileFieldMultiValue<F>(value), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        }
    }

    public <F> void updateProfileField(ProfileField<F, ?> field, F ... values) {
        this.updateProfileField(field, Arrays.asList(values));
    }

    public <F> void updateProfileField(ProfileField<F, ?> field, List<F> values) {
        if (field.isSingle()) {
            throw new IllegalArgumentException("Field is only valid for single value");
        }
        this.getResourceFactory().getApiResource("/user/profile/" + field.getName()).put(Entity.entity(new ProfileFieldMultiValue<F>(values), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updateProfile(ProfileFieldValues values) {
        this.getResourceFactory().getApiResource("/user/profile/").put(Entity.entity((Object)values, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public User getUser() {
        return (User)this.getResourceFactory().getApiResource("/user/").get(User.class);
    }

    public boolean getProperty(String key) {
        return ((PropertyValue)this.getResourceFactory().getApiResource("/user/property/" + key).get(PropertyValue.class)).getValue();
    }

    public void setProperty(String key, boolean value) {
        this.getResourceFactory().getApiResource("/user/property/" + key).put(Entity.entity((Object)new PropertyValue(value), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteProperty(String key) {
        this.getResourceFactory().getApiResource("/user/property/" + key).delete();
    }
}

