/*
 * Decompiled with CFR 0.152.
 */
package com.podio.task;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.Empty;
import com.podio.common.Reference;
import com.podio.task.AssignValue;
import com.podio.task.Task;
import com.podio.task.TaskCreate;
import com.podio.task.TaskCreateResponse;
import com.podio.task.TaskDueDate;
import com.podio.task.TaskPrivate;
import com.podio.task.TaskText;
import com.podio.task.TasksByDue;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.HashMap;
import java.util.List;
import org.joda.time.LocalDate;

public class TaskAPI
extends BaseAPI {
    public TaskAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public Task getTask(int taskId) {
        return (Task)this.getResourceFactory().getApiResource("/task/" + taskId).get(Task.class);
    }

    public void assignTask(int taskId, int responsible) {
        this.getResourceFactory().getApiResource("/task/" + taskId + "/assign").post(Entity.entity((Object)new AssignValue(responsible), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void completeTask(int taskId) {
        this.getResourceFactory().getApiResource("/task/" + taskId + "/complete").post(Entity.entity((Object)new Empty(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void incompleteTask(int taskId) {
        this.getResourceFactory().getApiResource("/task/" + taskId + "/incomplete").post(Entity.entity((Object)new Empty(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updateDueDate(int taskId, LocalDate dueDate) {
        this.getResourceFactory().getApiResource("/task/" + taskId + "/due_date").put(Entity.entity((Object)new TaskDueDate(dueDate), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updatePrivate(int taskId, boolean priv) {
        this.getResourceFactory().getApiResource("/task/" + taskId + "/private").put(Entity.entity((Object)new TaskPrivate(priv), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updateText(int taskId, String text) {
        this.getResourceFactory().getApiResource("/task/" + taskId + "/text").put(Entity.entity((Object)new TaskText(text), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public long createTask(TaskCreate task, boolean silent) {
        return this.createTask(task, silent, true);
    }

    public long createTask(TaskCreate task, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        TaskCreateResponse response = (TaskCreateResponse)this.getResourceFactory().getApiResource("/task/", queryParams).post(Entity.entity((Object)task, (MediaType)MediaType.APPLICATION_JSON_TYPE), TaskCreateResponse.class);
        return response.getId();
    }

    public long createTaskWithReference(TaskCreate task, Reference reference, boolean silent) {
        return this.createTaskWithReference(task, reference, silent, true);
    }

    public long createTaskWithReference(TaskCreate task, Reference reference, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        return ((TaskCreateResponse)this.getResourceFactory().getApiResource("/task/" + reference.getType().name().toLowerCase() + "/" + reference.getId() + "/", queryParams).post(Entity.entity((Object)task, (MediaType)MediaType.APPLICATION_JSON_TYPE), TaskCreateResponse.class)).getId();
    }

    public List<Task> getTasksWithReference(Reference reference) {
        return (List)this.getResourceFactory().getApiResource("/task/" + reference.getType().name().toLowerCase() + "/" + reference.getId() + "/").get((GenericType)new GenericType<List<Task>>(){});
    }

    public TasksByDue getActiveTasks() {
        return (TasksByDue)this.getResourceFactory().getApiResource("/task/active/").get(TasksByDue.class);
    }

    public TasksByDue getAssignedActiveTasks() {
        return (TasksByDue)this.getResourceFactory().getApiResource("/task/assigned/active/").get(TasksByDue.class);
    }

    public List<Task> getCompletedTasks() {
        return (List)this.getResourceFactory().getApiResource("/task/completed/").get((GenericType)new GenericType<List<Task>>(){});
    }
}

