/*
 * Decompiled with CFR 0.152.
 */
package com.podio.tag;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.Reference;
import com.podio.tag.TagCount;
import com.podio.tag.TagReference;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagAPI
extends BaseAPI {
    public TagAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public void createTags(Reference reference, Collection<String> tags) {
        this.getResourceFactory().getApiResource("/tag/" + reference.toURLFragment()).post(Entity.entity(tags, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void createTags(Reference reference, String ... tags) {
        this.createTags(reference, Arrays.asList(tags));
    }

    public void updateTags(Reference reference, Collection<String> tags) {
        this.getResourceFactory().getApiResource("/tag/" + reference.toURLFragment()).put(Entity.entity(tags, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updateTags(Reference reference, String ... tags) {
        this.updateTags(reference, Arrays.asList(tags));
    }

    public void removeTag(Reference reference, String tag) {
        this.getResourceFactory().getApiResource("/tag/" + reference.toURLFragment(), Collections.singletonMap("text", tag)).delete();
    }

    public List<TagCount> getTagsOnApp(long appId) {
        return (List)this.getResourceFactory().getApiResource("/tag/app/" + appId + "/").get((GenericType)new GenericType<List<TagCount>>(){});
    }

    public List<TagCount> getTagsOnApp(long appId, Map<String, String> options) {
        return (List)this.getResourceFactory().getApiResource("/tag/app/" + appId + "/", options).get((GenericType)new GenericType<List<TagCount>>(){});
    }

    public List<TagCount> getTagsOnApp(long appId, int limit, String text) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", Integer.toString(limit));
        if (text != null && !text.isEmpty()) {
            params.put("text", text);
        }
        return this.getTagsOnApp(appId, params);
    }

    public List<TagCount> getTagsOnOrg(int orgId) {
        return (List)this.getResourceFactory().getApiResource("/tag/org/" + orgId + "/").get((GenericType)new GenericType<List<TagCount>>(){});
    }

    public List<TagCount> getTagsOnOrg(int orgId, Map<String, String> options) {
        return (List)this.getResourceFactory().getApiResource("/tag/org/" + orgId + "/", options).get((GenericType)new GenericType<List<TagCount>>(){});
    }

    public List<TagCount> getTagsOnOrg(int orgId, int limit, String text) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", Integer.toString(limit));
        if (text != null && !text.isEmpty()) {
            params.put("text", text);
        }
        return this.getTagsOnOrg(orgId, params);
    }

    public List<TagCount> getTagsOnSpace(int spaceId) {
        return (List)this.getResourceFactory().getApiResource("/tag/space/" + spaceId + "/").get((GenericType)new GenericType<List<TagCount>>(){});
    }

    public List<TagCount> getTagsOnSpace(int spaceId, Map<String, String> options) {
        return (List)this.getResourceFactory().getApiResource("/tag/space/" + spaceId + "/", options).get((GenericType)new GenericType<List<TagCount>>(){});
    }

    public List<TagCount> getTagsOnSpace(int spaceId, int limit, String text) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", Integer.toString(limit));
        if (text != null && !text.isEmpty()) {
            params.put("text", text);
        }
        return this.getTagsOnSpace(spaceId, params);
    }

    public List<TagReference> getTagsOnAppWithText(long appId, String text) {
        return (List)this.getResourceFactory().getApiResource("/tag/app/" + appId + "/search/", Collections.singletonMap("text", text)).get((GenericType)new GenericType<List<TagReference>>(){});
    }

    public List<TagReference> getTagsOnOrgWithText(int orgId, String text) {
        return (List)this.getResourceFactory().getApiResource("/tag/org/" + orgId + "/search/", Collections.singletonMap("text", text)).get((GenericType)new GenericType<List<TagReference>>(){});
    }

    public List<TagReference> getTagsOnSpaceWithText(int spaceId, String text) {
        return (List)this.getResourceFactory().getApiResource("/tag/space/" + spaceId + "/search/", Collections.singletonMap("text", text)).get((GenericType)new GenericType<List<TagReference>>(){});
    }
}

