/*
 * Decompiled with CFR 0.152.
 */
package com.podio.stream;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.Reference;
import com.podio.serialize.DateTimeUtil;
import com.podio.stream.StreamObject;
import com.podio.stream.StreamObjectV2;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;

public class StreamAPI
extends BaseAPI {
    public StreamAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public StreamObject getStreamObject(Reference reference) {
        return (StreamObject)this.getResourceFactory().getApiResource("/stream/" + reference.toURLFragment(false)).get(StreamObject.class);
    }

    public StreamObjectV2 getStreamObjectV2(Reference reference) {
        return (StreamObjectV2)this.getResourceFactory().getApiResource("/stream/" + reference.toURLFragment(false) + "/v2").get(StreamObjectV2.class);
    }

    public List<StreamObject> getGlobalStream(Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStream("/stream/", limit, offset, dateFrom, dateTo);
    }

    public List<StreamObjectV2> getGlobalStreamV2(Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStreamV2("/stream/v2/", limit, offset, dateFrom, dateTo);
    }

    public List<StreamObject> getOrganizationStream(int orgId, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStream("/stream/org/" + orgId + "/", limit, offset, dateFrom, dateTo);
    }

    public List<StreamObjectV2> getOrganizationStreamV2(int orgId, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStreamV2("/stream/org/" + orgId + "/v2/", limit, offset, dateFrom, dateTo);
    }

    public List<StreamObject> getSpaceStream(int spaceId, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStream("/stream/space/" + spaceId + "/", limit, offset, dateFrom, dateTo);
    }

    public List<StreamObjectV2> getSpaceStreamV2(int spaceId, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStreamV2("/stream/space/" + spaceId + "/v2/", limit, offset, dateFrom, dateTo);
    }

    public List<StreamObjectV2> getAppStream(long appId, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        return this.getStreamV2("/stream/app/" + appId + "/", limit, offset, dateFrom, dateTo);
    }

    private List<StreamObject> getStream(String path, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (dateFrom != null) {
            queryParams.put("date_from", DateTimeUtil.formatDateTime(dateFrom));
        }
        if (dateTo != null) {
            queryParams.put("date_to", DateTimeUtil.formatDateTime(dateTo));
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource(path, queryParams);
        return (List)resource.get((GenericType)new GenericType<List<StreamObject>>(){});
    }

    private List<StreamObjectV2> getStreamV2(String path, Integer limit, Integer offset, DateTime dateFrom, DateTime dateTo) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (dateFrom != null) {
            queryParams.put("date_from", DateTimeUtil.formatDateTime(dateFrom));
        }
        if (dateTo != null) {
            queryParams.put("date_to", DateTimeUtil.formatDateTime(dateTo));
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource(path, queryParams);
        return (List)resource.get((GenericType)new GenericType<List<StreamObjectV2>>(){});
    }
}

