/*
 * Decompiled with CFR 0.152.
 */
package com.podio.space;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.Role;
import com.podio.space.Space;
import com.podio.space.SpaceCreate;
import com.podio.space.SpaceCreateResponse;
import com.podio.space.SpaceMember;
import com.podio.space.SpaceMemberAdd;
import com.podio.space.SpaceMemberUpdate;
import com.podio.space.SpaceMemberV2;
import com.podio.space.SpaceUpdate;
import com.podio.space.SpaceWithOrganization;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpaceAPI
extends BaseAPI {
    public SpaceAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public SpaceCreateResponse createSpace(SpaceCreate data) {
        return (SpaceCreateResponse)this.getResourceFactory().getApiResource("/space/").post(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE), SpaceCreateResponse.class);
    }

    public Space getSpace(int spaceId) {
        return (Space)this.getResourceFactory().getApiResource("/space/" + spaceId).get(Space.class);
    }

    public void updateSpace(int spaceId, SpaceUpdate data) {
        this.getResourceFactory().getApiResource("/space/" + spaceId).put(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public SpaceWithOrganization getSpaceByURL(String url) {
        return (SpaceWithOrganization)this.getResourceFactory().getApiResource("/space/url", Collections.singletonMap("url", url)).get(SpaceWithOrganization.class);
    }

    public void addSpaceMembers(int spaceId, SpaceMemberAdd spaceMemberAdd) {
        this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/").post(Entity.entity((Object)spaceMemberAdd, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public SpaceMember getSpaceMembership(int spaceId, int userId) {
        return (SpaceMember)this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/" + userId).get(SpaceMember.class);
    }

    public void updateSpaceMembership(int spaceId, int userId, Role role) {
        this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/" + userId).put(Entity.entity((Object)new SpaceMemberUpdate(role), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void endSpaceMembership(int spaceId, int userId) {
        this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/" + userId).delete();
    }

    public List<SpaceMember> getActiveMembers(int spaceId) {
        return (List)this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/").get((GenericType)new GenericType<List<SpaceMember>>(){});
    }

    public List<SpaceMemberV2> getActiveMembersV2(int spaceId, int offset, int limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("offset", Integer.toString(offset));
        queryParams.put("limit", Integer.toString(limit));
        return (List)this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/v2/", queryParams).get((GenericType)new GenericType<List<SpaceMemberV2>>(){});
    }

    public List<SpaceMemberV2> getActiveMembersV2(int spaceId, Map<String, String> options) {
        return (List)this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/v2/", options).get((GenericType)new GenericType<List<SpaceMemberV2>>(){});
    }

    public List<SpaceMember> getEndedMembers(int spaceId) {
        return (List)this.getResourceFactory().getApiResource("/space/" + spaceId + "/member/ended/").get((GenericType)new GenericType<List<SpaceMember>>(){});
    }

    public List<SpaceWithOrganization> getTopSpaces(Integer limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/space/top/", queryParams);
        return (List)resource.get((GenericType)new GenericType<List<SpaceWithOrganization>>(){});
    }
}

