/*
 * Decompiled with CFR 0.152.
 */
package com.podio.rating;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.Reference;
import com.podio.rating.RatingCreateResponse;
import com.podio.rating.RatingType;
import com.podio.rating.RatingValuesMap;
import com.podio.rating.SingleRatingValue;
import com.podio.rating.TypeRating;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import java.util.Collections;

public class RatingAPI
extends BaseAPI {
    public RatingAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public long createRating(Reference reference, RatingType type, int value) {
        return ((RatingCreateResponse)this.getResourceFactory().getApiResource("/rating/" + reference.toURLFragment() + type).post(Entity.entity(Collections.singletonMap("value", value), (MediaType)MediaType.APPLICATION_JSON_TYPE), RatingCreateResponse.class)).getId();
    }

    public void deleteRating(Reference reference, RatingType type) {
        this.getResourceFactory().getApiResource("/rating/" + reference.toURLFragment() + type).delete();
    }

    public long like(Reference reference) {
        return this.createRating(reference, RatingType.LIKE, 1);
    }

    public long yes(Reference reference) {
        return this.createRating(reference, RatingType.YESNO, 0);
    }

    public long no(Reference reference) {
        return this.createRating(reference, RatingType.YESNO, 1);
    }

    public long approves(Reference reference) {
        return this.createRating(reference, RatingType.APPROVED, 0);
    }

    public long disapproves(Reference reference) {
        return this.createRating(reference, RatingType.APPROVED, 1);
    }

    public long fivestar(Reference reference, int stars) {
        return this.createRating(reference, RatingType.FIVESTAR, stars);
    }

    public long attend(Reference reference) {
        return this.createRating(reference, RatingType.RSVP, 0);
    }

    public long maybeAttend(Reference reference) {
        return this.createRating(reference, RatingType.RSVP, 2);
    }

    public long notAttend(Reference reference) {
        return this.createRating(reference, RatingType.RSVP, 1);
    }

    public long thumbsUp(Reference reference) {
        return this.createRating(reference, RatingType.THUMBS, 0);
    }

    public long thumbsDown(Reference reference) {
        return this.createRating(reference, RatingType.THUMBS, 1);
    }

    public RatingValuesMap getAllRatings(Reference reference) {
        return (RatingValuesMap)this.getResourceFactory().getApiResource("/rating/" + reference.toURLFragment()).get(RatingValuesMap.class);
    }

    public TypeRating getRatings(Reference reference, RatingType type) {
        return (TypeRating)this.getResourceFactory().getApiResource("/rating/" + reference.toURLFragment() + type).get(TypeRating.class);
    }

    public int getRating(Reference reference, RatingType type, int userId) {
        return ((SingleRatingValue)this.getResourceFactory().getApiResource("/rating/" + reference.toURLFragment() + type + "/" + userId).get(SingleRatingValue.class)).getValue();
    }
}

