/*
 * Decompiled with CFR 0.152.
 */
package com.podio.org;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.org.EndMemberInfo;
import com.podio.org.Organization;
import com.podio.org.OrganizationCreate;
import com.podio.org.OrganizationCreateResponse;
import com.podio.org.OrganizationMember;
import com.podio.org.OrganizationMini;
import com.podio.org.OrganizationWithSpaces;
import com.podio.space.Space;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrgAPI
extends BaseAPI {
    public OrgAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public OrganizationCreateResponse createOrganization(OrganizationCreate data) {
        return (OrganizationCreateResponse)this.getResourceFactory().getApiResource("/org/").post(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE), OrganizationCreateResponse.class);
    }

    public void updateOrganization(int orgId, OrganizationCreate data) {
        this.getResourceFactory().getApiResource("/org/" + orgId).put(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public Organization getOrganization(int orgId) {
        return (Organization)this.getResourceFactory().getApiResource("/org/" + orgId).get(Organization.class);
    }

    public List<OrganizationWithSpaces> getOrganizations() {
        return Arrays.asList((OrganizationWithSpaces[])this.getResourceFactory().getApiResource("/org/").get(OrganizationWithSpaces[].class));
    }

    public OrganizationMini getOrganizationByURL(String url) {
        return (OrganizationMini)this.getResourceFactory().getApiResource("/org/url", Collections.singletonMap("url", url)).get(OrganizationMini.class);
    }

    public List<OrganizationWithSpaces> getSharedOrganizations(int userId) {
        return (List)this.getResourceFactory().getApiResource("/org/shared/" + userId).get((GenericType)new GenericType<List<OrganizationWithSpaces>>(){});
    }

    public Space getSpaceByURL(int orgId, String url) {
        return (Space)this.getResourceFactory().getApiResource("/org/" + orgId + "/space/url/" + url).get(Space.class);
    }

    public List<Space> getSpaces(int orgId) {
        return (List)this.getResourceFactory().getApiResource("/org/" + orgId + "/space/").get((GenericType)new GenericType<List<Space>>(){});
    }

    public List<OrganizationMember> getMembers(int orgId) {
        return (List)this.getResourceFactory().getApiResource("/org/" + orgId + "/member/").get((GenericType)new GenericType<List<OrganizationMember>>(){});
    }

    public List<OrganizationMember> getMembers(int orgId, int offset, int limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("offset", Integer.toString(offset));
        queryParams.put("limit", Integer.toString(limit));
        return (List)this.getResourceFactory().getApiResource("/org/" + orgId + "/member/", queryParams).get((GenericType)new GenericType<List<OrganizationMember>>(){});
    }

    public List<OrganizationMember> getMembers(int orgId, Map<String, String> options) {
        return (List)this.getResourceFactory().getApiResource("/org/" + orgId + "/member/", options).get((GenericType)new GenericType<List<OrganizationMember>>(){});
    }

    public OrganizationMember getMember(int orgId, int userId) {
        return (OrganizationMember)this.getResourceFactory().getApiResource("/org/" + orgId + "/member/" + userId).get(OrganizationMember.class);
    }

    public OrganizationMember getMemberByMail(int orgId, String mail) {
        return (OrganizationMember)this.getResourceFactory().getApiResource("/org/" + orgId + "/member/mail/" + mail).get(OrganizationMember.class);
    }

    public EndMemberInfo getEndMemberInfo(int orgId, int userId) {
        return (EndMemberInfo)this.getResourceFactory().getApiResource("/org/" + orgId + "/member/" + userId + "/end_member_info").get(EndMemberInfo.class);
    }

    public void endMember(int orgId, int userId) {
        this.getResourceFactory().getApiResource("/org/" + orgId + "/member/" + userId).delete();
    }
}

