/*
 * Decompiled with CFR 0.152.
 */
package com.podio.oauth;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.oauth.OAuthClientCredentials;
import com.podio.oauth.OAuthToken;
import com.podio.oauth.OAuthUserCredentials;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class OAuthAPI
extends BaseAPI {
    public OAuthAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public OAuthToken getToken(OAuthClientCredentials clientCredentials, OAuthUserCredentials userCredentials) {
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        parameters.add((Object)"grant_type", (Object)userCredentials.getType());
        userCredentials.addParameters((MultivaluedMap<String, String>)parameters);
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/oauth/token", false);
        String cred = clientCredentials.getClientId() + ":" + clientCredentials.getClientSecret();
        resource.header("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(cred.getBytes(StandardCharsets.UTF_8))));
        return (OAuthToken)resource.post(Entity.form((MultivaluedMap)parameters), OAuthToken.class);
    }
}

