/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map.converter;

import com.podio.item.map.converter.FieldConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class MoneyConverter
implements FieldConverter {
    private final CurrencyUnit defaultCurrency;

    public MoneyConverter(CurrencyUnit defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Override
    public Map<String, ?> fromModel(Object value) {
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> javaClass = value.getClass();
        if (javaClass == Money.class) {
            Money moneyValue = (Money)value;
            map.put("value", moneyValue.getAmount().toPlainString());
            map.put("currency", moneyValue.getCurrencyUnit().getCode());
        } else {
            map.put("value", ((BigDecimal)ConvertUtils.convert((Object)value, BigDecimal.class)).toPlainString());
            map.put("currency", this.defaultCurrency.getCode());
        }
        return map;
    }

    @Override
    public Object toModel(Map<String, ?> map, Class modelClass) {
        if (modelClass == Money.class) {
            BigDecimal amount = new BigDecimal((String)map.get("value"));
            CurrencyUnit currency = CurrencyUnit.of((String)((String)map.get("currency")));
            BigDecimal roundedAmount = amount.setScale(currency.getDecimalPlaces(), RoundingMode.HALF_EVEN);
            return Money.of((CurrencyUnit)currency, (BigDecimal)roundedAmount);
        }
        return ConvertUtils.convert(map.get("value"), (Class)modelClass);
    }
}

