/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map.converter;

import com.podio.app.ApplicationField;
import com.podio.item.map.converter.CategoryConverterProvider;
import com.podio.item.map.converter.FieldConverter;
import com.podio.item.map.converter.FieldConverterProvider;
import com.podio.item.map.converter.MoneyConverterProvider;
import com.podio.item.map.converter.NumberConverterProvider;
import com.podio.item.map.converter.ProgressConverterProvider;
import com.podio.item.map.converter.TextConverterProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class FieldConverterRegistry {
    private static final List<FieldConverterProvider> REGISTRY = new ArrayList<FieldConverterProvider>();

    private FieldConverterRegistry() {
    }

    public static FieldConverter getConverter(ApplicationField field, Method readMethod) {
        for (FieldConverterProvider provider : REGISTRY) {
            if (!provider.isSupported(field.getType())) continue;
            return provider.getConverter(field, readMethod);
        }
        throw new RuntimeException("No converter found for field of type " + field.getType());
    }

    static {
        REGISTRY.add(new MoneyConverterProvider());
        REGISTRY.add(new CategoryConverterProvider());
        REGISTRY.add(new NumberConverterProvider());
        REGISTRY.add(new TextConverterProvider());
        REGISTRY.add(new ProgressConverterProvider());
    }
}

