/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map.converter;

import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils.ConvertUtils;

public class ExternalIdConverter {
    private final PropertyDescriptor descriptor;

    public ExternalIdConverter(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String fromModel(Object model) {
        Object value;
        try {
            value = this.descriptor.getReadMethod().invoke(model, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get external id");
        }
        if (value == null) {
            return null;
        }
        return (String)ConvertUtils.convert((Object)value, String.class);
    }

    public void toModel(String externalId, Object model) {
        Object value = ConvertUtils.convert((String)externalId, this.descriptor.getPropertyType());
        try {
            this.descriptor.getWriteMethod().invoke(model, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set external id", e);
        }
    }
}

