/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map.converter;

import com.podio.app.CategoryOption;
import com.podio.item.map.converter.FieldConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;

public class CategoryConverter
implements FieldConverter {
    private final List<CategoryOption> options;

    public CategoryConverter(List<CategoryOption> options) {
        this.options = options;
    }

    @Override
    public Map<String, ?> fromModel(Object value) {
        String stringValue;
        if (value.getClass().isEnum()) {
            stringValue = value.toString();
            stringValue = stringValue.replace(' ', '_');
        } else {
            stringValue = (String)ConvertUtils.convert((Object)value, String.class);
        }
        CategoryOption option = this.getOptionByText(stringValue);
        if (option != null) {
            return Collections.singletonMap("value", option.getId());
        }
        throw new RuntimeException("No state with name " + stringValue + " found");
    }

    private CategoryOption getOptionByText(String text) {
        for (CategoryOption option : this.options) {
            if (!option.getText().equalsIgnoreCase(text)) continue;
            return option;
        }
        return null;
    }

    @Override
    public Object toModel(Map<String, ?> map, Class modelClass) {
        Map option = (Map)map.get("value");
        String stringValue = (String)option.get("text");
        if (modelClass.isEnum()) {
            return Enum.valueOf(modelClass, stringValue.toUpperCase());
        }
        return ConvertUtils.convert((String)stringValue, (Class)modelClass);
    }
}

