/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map;

import com.podio.APIFactory;
import com.podio.app.AppAPI;
import com.podio.app.Application;
import com.podio.item.ItemAPI;
import com.podio.item.ItemsResponse;
import com.podio.item.map.ItemMap;
import org.apache.commons.beanutils.ConvertUtils;

public class MappedItemAPI<T> {
    private final APIFactory factory;
    private final Application application;
    private final ItemMap<T> map;

    public MappedItemAPI(APIFactory factory, long appId, Class<T> cls) {
        this.factory = factory;
        this.application = factory.getAPI(AppAPI.class).getApp(appId);
        this.map = ItemMap.get(this.application, cls);
    }

    public long insert(T object, boolean silent) {
        return this.factory.getAPI(ItemAPI.class).addItem(this.application.getId(), this.map.getCreate(object), silent);
    }

    public void update(T object, boolean silent) {
        this.factory.getAPI(ItemAPI.class).updateItem(-1L, this.map.getUpdate(object), silent, false);
    }

    public T get(Object externalId) {
        String stringExternalId = (String)ConvertUtils.convert((Object)externalId, String.class);
        ItemsResponse item = this.factory.getAPI(ItemAPI.class).getItemsByExternalId(this.application.getId(), stringExternalId);
        if (item.getFiltered() == 1) {
            return this.map.getView(item.getItems().get(0));
        }
        if (item.getFiltered() == 0) {
            return null;
        }
        throw new RuntimeException("Multiple items found with the external id " + externalId);
    }
}

