/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map;

import com.podio.app.Application;
import com.podio.app.ApplicationField;
import com.podio.item.FieldValuesUpdate;
import com.podio.item.FieldValuesView;
import com.podio.item.Item;
import com.podio.item.ItemBadge;
import com.podio.item.ItemCreate;
import com.podio.item.ItemUpdate;
import com.podio.item.map.ExternalId;
import com.podio.item.map.FieldMap;
import com.podio.item.map.Transient;
import com.podio.item.map.converter.ExternalIdConverter;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class ItemMap<T> {
    private final Class<T> modelClass;
    private final List<FieldMap> fieldMaps;
    private final ExternalIdConverter externalIdConverter;

    public ItemMap(Class<T> modelClass, List<FieldMap> fieldMaps, ExternalIdConverter externalIdConverter) {
        this.modelClass = modelClass;
        this.fieldMaps = fieldMaps;
        this.externalIdConverter = externalIdConverter;
    }

    public ItemCreate getCreate(T model) {
        return new ItemCreate(this.getExternalId(model), this.getUpdates(model), Collections.emptyList(), Collections.emptyList());
    }

    private String getExternalId(T model) {
        String externalId = null;
        if (this.externalIdConverter != null) {
            externalId = this.externalIdConverter.fromModel(model);
        }
        return externalId;
    }

    private void setExternalId(String externalId, T model) {
        if (this.externalIdConverter != null) {
            this.externalIdConverter.toModel(externalId, model);
        }
    }

    private List<FieldValuesUpdate> getUpdates(T model) {
        ArrayList<FieldValuesUpdate> updates = new ArrayList<FieldValuesUpdate>();
        for (FieldMap fieldMap : this.fieldMaps) {
            FieldValuesUpdate update = fieldMap.fromModel(model);
            updates.add(update);
        }
        return updates;
    }

    public ItemUpdate getUpdate(T model) {
        return new ItemUpdate(this.getExternalId(model), this.getUpdates(model));
    }

    public T getView(Item item) {
        return this.getView(item.getExternalId(), item.getFields());
    }

    public T getView(ItemBadge item) {
        return this.getView(item.getExternalId(), item.getFields());
    }

    private T getView(String externalId, List<FieldValuesView> views) {
        T model;
        try {
            model = this.modelClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create new " + this.modelClass.getName() + ", ensure that a non-arguments public constructor exists");
        }
        this.setExternalId(externalId, model);
        for (FieldMap fieldMap : this.fieldMaps) {
            fieldMap.toModel(model, views);
        }
        return model;
    }

    public static <T> ItemMap<T> get(Application application, Class<T> modelClass) {
        PropertyDescriptor[] descriptors;
        HashMap<String, ApplicationField> fields = new HashMap<String, ApplicationField>();
        for (ApplicationField field : application.getFields()) {
            fields.put(field.getExternalId(), field);
        }
        ArrayList<FieldMap> fieldMaps = new ArrayList<FieldMap>();
        ExternalIdConverter externalIdConverter = null;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(modelClass)) {
            Transient tr;
            if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || (tr = descriptor.getReadMethod().getAnnotation(Transient.class)) != null) continue;
            ExternalId externalId = descriptor.getReadMethod().getAnnotation(ExternalId.class);
            if (externalId != null) {
                externalIdConverter = new ExternalIdConverter(descriptor);
                continue;
            }
            fieldMaps.add(FieldMap.get(descriptor, fields));
        }
        return new ItemMap<T>(modelClass, fieldMaps, externalIdConverter);
    }
}

