/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item.map;

import com.podio.app.ApplicationField;
import com.podio.item.FieldValuesUpdate;
import com.podio.item.FieldValuesView;
import com.podio.item.map.Field;
import com.podio.item.map.NameUtil;
import com.podio.item.map.converter.FieldConverter;
import com.podio.item.map.converter.FieldConverterRegistry;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldMap {
    private final String externalId;
    private final PropertyDescriptor property;
    private final boolean single;
    private final FieldConverter converter;

    private FieldMap(String externalId, PropertyDescriptor property, boolean single, FieldConverter converter) {
        this.externalId = externalId;
        this.property = property;
        this.single = single;
        this.converter = converter;
    }

    public FieldValuesUpdate fromModel(Object model) {
        Object value;
        try {
            value = this.property.getReadMethod().invoke(model, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get model value", e);
        }
        ArrayList apiValues = new ArrayList();
        if (value != null) {
            if (!this.single) {
                Collection subValues = (Collection)value;
                for (Object subValue : subValues) {
                    apiValues.add(this.converter.fromModel(subValue));
                }
            } else {
                apiValues.add(this.converter.fromModel(value));
            }
        }
        return new FieldValuesUpdate(this.externalId, apiValues);
    }

    public void toModel(Object model, List<FieldValuesView> views) {
        for (FieldValuesView view : views) {
            if (!view.getExternalId().equals(this.externalId) || view.getValues().size() <= 0) continue;
            try {
                if (this.single) {
                    if (view.getValues().size() > 1) {
                        throw new RuntimeException("Expected at most one value");
                    }
                    Object value = this.converter.toModel(view.getValues().get(0), this.property.getPropertyType());
                    this.property.getWriteMethod().invoke(model, value);
                    continue;
                }
                ParameterizedType innerType = (ParameterizedType)this.property.getReadMethod().getGenericReturnType();
                Collection<?> col = this.getCollectionInstance();
                for (Map<String, ?> values : view.getValues()) {
                    Object value = this.converter.toModel(values, (Class)innerType.getActualTypeArguments()[0]);
                    col.add(value);
                }
                this.property.getWriteMethod().invoke(model, col);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to set model value", e);
            }
        }
    }

    private Collection<?> getCollectionInstance() throws InstantiationException, IllegalAccessException {
        if (this.property.getPropertyType() == Collection.class || this.property.getPropertyType() == List.class) {
            return new ArrayList();
        }
        if (this.property.getPropertyType() == Set.class) {
            return new HashSet();
        }
        return (Collection)this.property.getPropertyType().newInstance();
    }

    public static FieldMap get(PropertyDescriptor property, Map<String, ApplicationField> fieldMap) {
        Field field = property.getReadMethod().getAnnotation(Field.class);
        String externalId = field == null || field.value() == "" ? NameUtil.toAPI(property.getName()) : field.value();
        ApplicationField applicationField = fieldMap.get(externalId);
        if (applicationField == null) {
            throw new RuntimeException("No field found with external id " + externalId);
        }
        boolean single = !Collection.class.isAssignableFrom(property.getPropertyType());
        FieldConverter converter = FieldConverterRegistry.getConverter(applicationField, property.getReadMethod());
        return new FieldMap(externalId, property, single, converter);
    }
}

