/*
 * Decompiled with CFR 0.152.
 */
package com.podio.item;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.ToStringUtil;
import com.podio.filter.ExternalIdFilterBy;
import com.podio.filter.FilterByValue;
import com.podio.filter.SortBy;
import com.podio.item.FieldValuesUpdate;
import com.podio.item.FieldValuesView;
import com.podio.item.Item;
import com.podio.item.ItemCreate;
import com.podio.item.ItemCreateResponse;
import com.podio.item.ItemFieldDifference;
import com.podio.item.ItemMini;
import com.podio.item.ItemReference;
import com.podio.item.ItemRevision;
import com.podio.item.ItemUpdate;
import com.podio.item.ItemsResponse;
import com.podio.item.filter.ItemFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemAPI
extends BaseAPI {
    public ItemAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public long addItem(long appId, ItemCreate create, boolean silent) {
        return ((ItemCreateResponse)this.getResourceFactory().getApiResource("/item/app/" + appId + "/", Collections.singletonMap("silent", silent ? "1" : "0")).post(Entity.entity((Object)create, (MediaType)MediaType.APPLICATION_JSON_TYPE), ItemCreateResponse.class)).getId();
    }

    public Item getItem(long itemId) {
        return (Item)this.getResourceFactory().getApiResource("/item/" + itemId).get(Item.class);
    }

    public void updateItem(long itemId, ItemUpdate update, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        this.getResourceFactory().getApiResource("/item/" + itemId, queryParams).put(Entity.entity((Object)update, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updateItemValues(long itemId, List<FieldValuesUpdate> values, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        this.getResourceFactory().getApiResource("/item/" + itemId + "/value/", queryParams).put(Entity.entity(values, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void updateItemFieldValues(long itemId, String fieldOrExternalId, List<?> values, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        this.getResourceFactory().getApiResource("/item/" + itemId + "/value/" + fieldOrExternalId, queryParams).put(Entity.entity(values, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteItem(long itemId, boolean silent) {
        this.getResourceFactory().getApiResource("/item/" + itemId, Collections.singletonMap("silent", silent ? "1" : "0")).delete();
    }

    public List<Map<String, Object>> getItemFieldValues(long itemId, int fieldId) {
        return (List)this.getResourceFactory().getApiResource("/item/" + itemId + "/value/" + fieldId).get((GenericType)new GenericType<List<Map<String, Object>>>(){});
    }

    public List<FieldValuesView> getItemValues(long itemId) {
        return (List)this.getResourceFactory().getApiResource("/item/" + itemId + "/value/").get((GenericType)new GenericType<List<FieldValuesView>>(){});
    }

    public List<ItemMini> getItemsByFieldAndTitle(int fieldId, String text, List<Integer> notItemIds, Integer limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (notItemIds != null && notItemIds.size() > 0) {
            queryParams.put("not_item_id", ToStringUtil.toString(notItemIds, ","));
        }
        queryParams.put("text", text);
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/item/field/" + fieldId + "/find", queryParams);
        return (List)resource.get((GenericType)new GenericType<List<ItemMini>>(){});
    }

    public List<ItemReference> getItemReference(long itemId) {
        return (List)this.getResourceFactory().getApiResource("/item/" + itemId + "/reference/").get((GenericType)new GenericType<List<ItemReference>>(){});
    }

    public ItemRevision getItemRevision(long itemId, int revisionId) {
        return (ItemRevision)this.getResourceFactory().getApiResource("/item/" + itemId + "/revision/" + revisionId).get(ItemRevision.class);
    }

    public List<ItemFieldDifference> getItemRevisionDifference(long itemId, int revisionFrom, int revisionTo) {
        return (List)this.getResourceFactory().getApiResource("/item/" + itemId + "/revision/" + revisionFrom + "/" + revisionTo).get((GenericType)new GenericType<List<ItemFieldDifference>>(){});
    }

    public List<ItemRevision> getItemRevisions(long itemId) {
        return (List)this.getResourceFactory().getApiResource("/item/" + itemId + "/revision/").get((GenericType)new GenericType<List<ItemRevision>>(){});
    }

    public ItemsResponse filterItems(long appId, ItemFilter filter) {
        return (ItemsResponse)this.getResourceFactory().getApiResource("/item/app/" + appId + "/filter/").post(Entity.entity((Object)filter, (MediaType)MediaType.APPLICATION_JSON_TYPE), ItemsResponse.class);
    }

    public ItemsResponse getItems(long appId, Integer limit, Integer offset, SortBy sortBy, Boolean sortDesc, FilterByValue<?> ... filters) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (sortBy != null) {
            queryParams.put("sort_by", sortBy.getKey());
        }
        if (sortDesc != null) {
            queryParams.put("sort_desc", sortDesc != false ? "1" : "0");
        }
        for (FilterByValue<?> filter : filters) {
            queryParams.put(filter.getBy().getKey(), filter.getFormattedValue());
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/item/app/" + appId + "/v2/", queryParams);
        return (ItemsResponse)resource.get(ItemsResponse.class);
    }

    public ItemsResponse getItemsByExternalId(long appId, String externalId) {
        return this.getItems(appId, null, null, null, null, new FilterByValue<String>(new ExternalIdFilterBy(), externalId));
    }
}

