/*
 * Decompiled with CFR 0.152.
 */
package com.podio.file;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.file.File;
import com.podio.file.FileSize;
import com.podio.file.FileUpdate;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class FileAPI
extends BaseAPI {
    public FileAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public void downloadFile(int fileId, java.io.File target, FileSize size) throws IOException {
        String path = "/" + fileId;
        if (size != null) {
            path = path + "/" + size.name().toLowerCase();
        }
        Invocation.Builder builder = this.getResourceFactory().getFileResource(path);
        byte[] data = (byte[])builder.get(byte[].class);
        FileUtils.writeByteArrayToFile((java.io.File)target, (byte[])data);
    }

    public long uploadFile(String name, java.io.File file) {
        FileDataBodyPart filePart = new FileDataBodyPart("source", file);
        FormDataContentDisposition.FormDataContentDispositionBuilder builder = FormDataContentDisposition.name((String)filePart.getName());
        builder.fileName(file.getName());
        builder.size(file.length());
        filePart.setFormDataContentDisposition(builder.build());
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.bodyPart((BodyPart)filePart);
        multiPart.field("filename", name);
        File resource = (File)this.getResourceFactory().getApiResource("/file/v2/").post(Entity.entity((Object)multiPart, (MediaType)new MediaType("multipart", "form-data", Collections.singletonMap("boundary", "AaB03x"))), File.class);
        return resource.getId();
    }

    public Long uploadImage(URL url) throws IOException {
        return this.uploadImage(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long uploadImage(URL url, String name) throws IOException {
        java.io.File file = FileAPI.readURL(url);
        try {
            String path = url.getPath();
            int lastSlashIdx = path.lastIndexOf(47);
            if (name == null) {
                name = path.substring(lastSlashIdx + 1);
            }
            long l = this.uploadFile(name, file);
            return l;
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static java.io.File readURL(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            java.io.File file = java.io.File.createTempFile(Integer.toString(url.hashCode()), null);
            file.deleteOnExit();
            try (FileOutputStream os = FileUtils.openOutputStream((java.io.File)file);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            java.io.File file2 = file;
            return file2;
        }
    }

    public File getFile(int fileId) {
        return (File)this.getResourceFactory().getApiResource("/file/" + fileId).get(File.class);
    }

    public void updateFile(int fileId, FileUpdate update) {
        this.getResourceFactory().getApiResource("/file/" + fileId).put(Entity.entity((Object)update, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteFile(int fileId) {
        this.getResourceFactory().getApiResource("/file/" + fileId).delete();
    }

    public List<File> getOnApp(long appId, Integer limit, Integer offset) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/file/app/" + appId + "/", queryParams);
        return (List)resource.get((GenericType)new GenericType<List<File>>(){});
    }

    public List<File> getOnSpace(int spaceId, Integer limit, Integer offset) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/file/space/" + spaceId + "/", queryParams);
        return (List)resource.get((GenericType)new GenericType<List<File>>(){});
    }
}

