/*
 * Decompiled with CFR 0.152.
 */
package com.podio.conversation;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.common.Reference;
import com.podio.conversation.Conversation;
import com.podio.conversation.ConversationCreate;
import com.podio.conversation.ConversationCreateResponse;
import com.podio.conversation.MessageCreate;
import com.podio.conversation.MessageCreateResponse;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.List;

public class ConversationAPI
extends BaseAPI {
    public ConversationAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public long createConversation(String subject, String text, List<Integer> participants) {
        return this.createConversation(subject, text, participants, null);
    }

    public long createConversation(String subject, String text, List<Integer> participants, Reference reference) {
        String url = reference != null ? "/conversation/" + reference.toURLFragment() : "/conversation/";
        return ((ConversationCreateResponse)this.getResourceFactory().getApiResource(url).post(Entity.entity((Object)new ConversationCreate(subject, text, participants), (MediaType)MediaType.APPLICATION_JSON_TYPE), ConversationCreateResponse.class)).getConversationId();
    }

    public Conversation getConversation(int conversationId) {
        return (Conversation)this.getResourceFactory().getApiResource("/conversation/" + conversationId).get(Conversation.class);
    }

    public List<Conversation> getConversationsOnObject(Reference object) {
        return (List)this.getResourceFactory().getApiResource("/conversation/" + object.toURLFragment()).get((GenericType)new GenericType<List<Conversation>>(){});
    }

    public long addReply(int conversationId, String text) {
        return ((MessageCreateResponse)this.getResourceFactory().getApiResource("/conversation/" + conversationId + "/reply").post(Entity.entity((Object)new MessageCreate(text), (MediaType)MediaType.APPLICATION_JSON_TYPE), MessageCreateResponse.class)).getMessageId();
    }
}

