/*
 * Decompiled with CFR 0.152.
 */
package com.podio.contact;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.podio.serialize.DateTimeUtil;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.LocalDate;

public abstract class ProfileField<F, R> {
    private static final Map<String, ProfileField<?, ?>> MAP = new HashMap();
    public static final ProfileField<String, String> NAME = new StringProfileField("name", true);
    public static final ProfileField<Integer, Integer> AVATAR = new IntegerProfileField("avatar", true);
    public static final ProfileField<LocalDate, String> BIRTHDATE = new DateProfileField("birthdate", true);
    public static final ProfileField<String, String> ORGANIZATION = new StringProfileField("organization", true);
    public static final ProfileField<String, String> SKYPE = new StringProfileField("skype", true);
    public static final ProfileField<String, String> ABOUT = new StringProfileField("about", true);
    public static final ProfileField<String, String> MAIL = new StringProfileField("mail", false);
    public static final ProfileField<String, String> ADDRESS = new StringProfileField("address", false);
    public static final ProfileField<String, String> IM = new StringProfileField("im", false);
    public static final ProfileField<String, String> LOCATION = new StringProfileField("location", false);
    public static final ProfileField<String, String> PHONE = new StringProfileField("phone", false);
    public static final ProfileField<String, String> TITLE = new StringProfileField("title", false);
    public static final ProfileField<String, String> URL = new StringProfileField("url", false);
    private final String name;
    private final boolean single;

    public ProfileField(String name, boolean single) {
        this.name = name;
        this.single = single;
        MAP.put(name, this);
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public boolean isSingle() {
        return this.single;
    }

    public String toString() {
        return this.getName();
    }

    public abstract F parse(R var1);

    public abstract R format(F var1);

    @JsonCreator
    public static ProfileField<?, ?> getByName(String value) {
        return MAP.get(value);
    }

    private static class DateProfileField
    extends ProfileField<LocalDate, String> {
        public DateProfileField(String name, boolean single) {
            super(name, single);
        }

        @Override
        public LocalDate parse(String object) {
            return DateTimeUtil.parseDate(object);
        }

        @Override
        public String format(LocalDate object) {
            return DateTimeUtil.formatDate(object);
        }
    }

    private static class IntegerProfileField
    extends ProfileField<Integer, Integer> {
        public IntegerProfileField(String name, boolean single) {
            super(name, single);
        }

        @Override
        public Integer parse(Integer object) {
            return object;
        }

        @Override
        public Integer format(Integer object) {
            return object;
        }
    }

    private static class StringProfileField
    extends ProfileField<String, String> {
        public StringProfileField(String name, boolean single) {
            super(name, single);
        }

        @Override
        public String parse(String object) {
            return object;
        }

        @Override
        public String format(String object) {
            return object;
        }
    }
}

