/*
 * Decompiled with CFR 0.152.
 */
package com.podio.contact;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.contact.ContactCreate;
import com.podio.contact.ContactCreateResponse;
import com.podio.contact.ContactOrder;
import com.podio.contact.ContactTotal;
import com.podio.contact.ContactType;
import com.podio.contact.ContactUpdate;
import com.podio.contact.Profile;
import com.podio.contact.ProfileField;
import com.podio.contact.ProfileType;
import com.podio.contact.SpaceContactTotals;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ContactAPI
extends BaseAPI {
    public ContactAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public long addSpaceContact(int spaceId, ContactCreate create, boolean silent) {
        return ((ContactCreateResponse)this.getResourceFactory().getApiResource("/contact/space/" + spaceId + "/", Collections.singletonMap("silent", silent ? "1" : "0")).post(Entity.entity((Object)create, (MediaType)MediaType.APPLICATION_JSON_TYPE), ContactCreateResponse.class)).getId();
    }

    public void updateSpaceContact(int profileId, ContactUpdate update, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        this.getResourceFactory().getApiResource("/contact/" + profileId, queryParams).put(Entity.entity((Object)update, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteSpaceContact(int profileId, boolean silent) {
        this.getResourceFactory().getApiResource("/contact/" + profileId, Collections.singletonMap("silent", silent ? "1" : "0")).delete();
    }

    public Profile getContact(int profileId) {
        return (Profile)this.getResourceFactory().getApiResource("/contact/" + profileId + "/v2").get(Profile.class);
    }

    public <T, R> List<T> getContactField(int userId, ProfileField<T, R> field) {
        List values = (List)this.getResourceFactory().getApiResource("/contact/" + userId + "/" + field.getName()).get(new GenericType<List<R>>(){});
        ArrayList<T> formatted = new ArrayList<T>();
        for (Object value : values) {
            formatted.add(field.parse(value));
        }
        return formatted;
    }

    public ContactTotal getContactTotal() {
        return (ContactTotal)this.getResourceFactory().getApiResource("/contact/totals/").get(ContactTotal.class);
    }

    public <T, F, R> List<T> getContacts(ProfileField<F, R> key, F value, Integer limit, Integer offset, ProfileType<T> type, ContactOrder order, ContactType contactType) {
        return this.getContactsCommon("/contact/", key, value, limit, offset, type, order, contactType);
    }

    public <T, F, R> List<T> getOrganizationContacts(int organizationId, ProfileField<F, R> key, F value, Integer limit, Integer offset, ProfileType<T> type, ContactOrder order, ContactType contactType) {
        return this.getContactsCommon("/contact/org/" + organizationId, key, value, limit, offset, type, order, contactType);
    }

    public <T, F, R> List<T> getSpaceContacts(int spaceId, ProfileField<F, R> key, F value, Integer limit, Integer offset, ProfileType<T> type, ContactOrder order, ContactType contactType) {
        return this.getContactsCommon("/contact/space/" + spaceId, key, value, limit, offset, type, order, contactType);
    }

    public SpaceContactTotals getSpaceContactTotals(int spaceId) {
        return (SpaceContactTotals)this.getResourceFactory().getApiResource("/contact/space/" + spaceId + "/totals/space/").get(SpaceContactTotals.class);
    }

    private <T, F, R> List<T> getContactsCommon(String url, ProfileField<F, R> key, F value, Integer limit, Integer offset, ProfileType<T> type, ContactOrder order, ContactType contactType) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (key != null && value != null) {
            queryParams.put("key", key.getName().toLowerCase());
            queryParams.put("value", key.format(value).toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        queryParams.put("type", type.getName());
        if (order != null) {
            queryParams.put("order", order.name().toLowerCase());
        }
        if (contactType != null) {
            queryParams.put("contact_type", contactType.name().toLowerCase());
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource(url, queryParams);
        return (List)resource.get(this.getGenericType(type));
    }

    private <T> GenericType<List<T>> getGenericType(final ProfileType<T> type) {
        return new GenericType((Type)new ParameterizedType(){

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{type.getType()};
            }
        });
    }
}

