/*
 * Decompiled with CFR 0.152.
 */
package com.podio.comment;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.comment.Comment;
import com.podio.comment.CommentCreate;
import com.podio.comment.CommentCreateResponse;
import com.podio.comment.CommentUpdate;
import com.podio.common.Reference;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.HashMap;
import java.util.List;

public class CommentAPI
extends BaseAPI {
    public CommentAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public List<Comment> getComments(Reference reference) {
        return (List)this.getResourceFactory().getApiResource("/comment/" + reference.getType() + "/" + reference.getId()).get((GenericType)new GenericType<List<Comment>>(){});
    }

    public Comment getComment(int commentId) {
        return (Comment)this.getResourceFactory().getApiResource("/comment/" + commentId).get(Comment.class);
    }

    public long addComment(Reference reference, CommentCreate comment, boolean silent, boolean hook) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("silent", silent ? "1" : "0");
        queryParams.put("hook", hook ? "1" : "0");
        return ((CommentCreateResponse)this.getResourceFactory().getApiResource("/comment/" + reference.getType() + "/" + reference.getId(), queryParams).post(Entity.entity((Object)comment, (MediaType)MediaType.APPLICATION_JSON_TYPE), CommentCreateResponse.class)).getId();
    }

    public void updateComment(int commentId, CommentUpdate comment) {
        this.getResourceFactory().getApiResource("/comment/" + commentId).put(Entity.entity((Object)comment, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteComment(int commentId) {
        this.getResourceFactory().getApiResource("/comment/" + commentId).delete();
    }
}

