/*
 * Decompiled with CFR 0.152.
 */
package com.podio.calendar;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.calendar.Event;
import com.podio.common.CSVUtil;
import com.podio.common.ReferenceType;
import com.podio.serialize.DateTimeUtil;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.HashMap;
import java.util.List;
import org.joda.time.LocalDate;

public class CalendarAPI
extends BaseAPI {
    public CalendarAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    private List<Event> getCalendar(String path, LocalDate dateFrom, LocalDate dateTo, List<Integer> spaceIds, ReferenceType ... types) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("date_from", DateTimeUtil.formatDate(dateFrom));
        queryParams.put("date_to", DateTimeUtil.formatDate(dateTo));
        if (spaceIds != null && spaceIds.size() > 0) {
            queryParams.put("space_ids", CSVUtil.toCSV(spaceIds));
        }
        if (types.length > 0) {
            queryParams.put("types", CSVUtil.toCSV((Object[])types));
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/calendar/" + path + "/", queryParams);
        return (List)resource.get((GenericType)new GenericType<List<Event>>(){});
    }

    public List<Event> getApp(long appId, LocalDate dateFrom, LocalDate dateTo, ReferenceType ... types) {
        return this.getCalendar("app/" + appId, dateFrom, dateTo, null, types);
    }

    public List<Event> getSpace(int spaceId, LocalDate dateFrom, LocalDate dateTo, ReferenceType ... types) {
        return this.getCalendar("space/" + spaceId, dateFrom, dateTo, null, types);
    }

    public List<Event> getGlobal(LocalDate dateFrom, LocalDate dateTo, List<Integer> spaceIds, ReferenceType ... types) {
        return this.getCalendar("", dateFrom, dateTo, spaceIds, types);
    }
}

